/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Streams;
import com.google.common.collect.TreeRangeSet;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.googlejavaformat.CloseOp;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.FormattingError;
import com.google.googlejavaformat.Indent;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpenOp;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.Output;
import com.google.googlejavaformat.java.AutoOneOf_JavaInputAstVisitor_AnnotationOrModifier;
import com.google.googlejavaformat.java.AutoValue_JavaInputAstVisitor_DeclarationModifiersAndTypeAnnotations;
import com.google.googlejavaformat.java.DimensionHelpers;
import com.google.googlejavaformat.java.Trees;
import com.google.googlejavaformat.java.TypeNameClassifier;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseLabelTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DirectiveTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.UsesTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.tree.YieldTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Name;
import org.jspecify.annotations.Nullable;

public class JavaInputAstVisitor
extends TreePathScanner<Void, Void> {
    private static final ImmutableMultimap<String, String> TYPE_ANNOTATIONS = JavaInputAstVisitor.typeAnnotations();
    protected final OpsBuilder builder;
    protected static final Indent.Const ZERO = Indent.Const.ZERO;
    protected final int indentMultiplier;
    protected final Indent.Const minusTwo;
    protected final Indent.Const minusFour;
    protected final Indent.Const plusTwo;
    protected final Indent.Const plusFour;
    private final Set<Name> typeAnnotationSimpleNames = new HashSet<Name>();
    private static final int MAX_ITEM_LENGTH_FOR_FILLING = 10;
    private final Deque<Boolean> inExpression = new ArrayDeque<Boolean>((Collection<Boolean>)ImmutableList.of((Object)false));
    protected static final long COMPACT_RECORD_CONSTRUCTOR = 0x8000000000000L;
    protected static final long RECORD = 0x2000000000000000L;
    static final ImmutableSet<String> LOG_METHODS = ImmutableSet.of((Object)"at", (Object)"atConfig", (Object)"atDebug", (Object)"atFine", (Object)"atFiner", (Object)"atFinest", (Object[])new String[]{"atInfo", "atMostEvery", "atSevere", "atWarning", "every", "log", "logVarargs", "perUnique", "withCause", "withStackTrace"});
    private static final Pattern FORMAT_SPECIFIER = Pattern.compile("%|\\{[0-9]\\}");

    private static ImmutableSetMultimap<String, String> typeAnnotations() {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (String annotation : ImmutableList.of((Object)"org.jspecify.annotations.NonNull", (Object)"org.jspecify.annotations.Nullable", (Object)"org.jspecify.annotations.Nullable", (Object)"org.checkerframework.checker.nullness.qual.NonNull", (Object)"org.checkerframework.checker.nullness.qual.Nullable")) {
            String simpleName = annotation.substring(annotation.lastIndexOf(46) + 1);
            result.put((Object)simpleName, (Object)annotation);
        }
        return result.build();
    }

    private static final ImmutableList<Op> breakList(Optional<Output.BreakTag> breakTag) {
        return ImmutableList.of((Object)Doc.Break.make(Doc.FillMode.UNIFIED, " ", ZERO, breakTag));
    }

    private static final ImmutableList<Op> breakFillList(Optional<Output.BreakTag> breakTag) {
        return ImmutableList.of((Object)OpenOp.make(ZERO), (Object)Doc.Break.make(Doc.FillMode.INDEPENDENT, " ", ZERO, breakTag), (Object)CloseOp.make());
    }

    private static final ImmutableList<Op> forceBreakList(Optional<Output.BreakTag> breakTag) {
        return ImmutableList.of((Object)Doc.Break.make(Doc.FillMode.FORCED, "", Indent.Const.ZERO, breakTag));
    }

    public JavaInputAstVisitor(OpsBuilder builder, int indentMultiplier) {
        this.builder = builder;
        this.indentMultiplier = indentMultiplier;
        this.minusTwo = Indent.Const.make(-2, indentMultiplier);
        this.minusFour = Indent.Const.make(-4, indentMultiplier);
        this.plusTwo = Indent.Const.make(2, indentMultiplier);
        this.plusFour = Indent.Const.make(4, indentMultiplier);
    }

    private boolean inExpression() {
        return this.inExpression.peekLast();
    }

    @Override
    public Void scan(Tree tree, Void unused) {
        this.inExpression.addLast(tree instanceof ExpressionTree || this.inExpression.peekLast() != false);
        int previous = this.builder.depth();
        try {
            super.scan(tree, null);
        }
        catch (FormattingError e) {
            throw e;
        }
        catch (Throwable t) {
            throw new FormattingError(this.builder.diagnostic(Throwables.getStackTraceAsString((Throwable)t)));
        }
        finally {
            this.inExpression.removeLast();
        }
        this.builder.checkClosed(previous);
        return null;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree node, Void unused) {
        boolean afterFirstToken = false;
        if (node.getPackageName() != null) {
            this.markForPartialFormat();
            this.visitPackage(node.getPackageName(), node.getPackageAnnotations());
            this.builder.forcedBreak();
            afterFirstToken = true;
        }
        this.dropEmptyDeclarations();
        if (!node.getImports().isEmpty()) {
            if (afterFirstToken) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
            }
            for (ImportTree importTree : node.getImports()) {
                this.markForPartialFormat();
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                this.scan((Tree)importTree, null);
                this.builder.forcedBreak();
            }
            afterFirstToken = true;
        }
        this.dropEmptyDeclarations();
        for (Tree tree : node.getTypeDecls()) {
            if (tree.getKind() == Tree.Kind.IMPORT) continue;
            if (afterFirstToken) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
            }
            this.markForPartialFormat();
            this.scan(tree, null);
            this.builder.forcedBreak();
            afterFirstToken = true;
            this.dropEmptyDeclarations();
        }
        this.handleModule(afterFirstToken, node);
        this.markForPartialFormat();
        return null;
    }

    protected void handleModule(boolean afterFirstToken, CompilationUnitTree node) {
        ModuleTree module = node.getModule();
        if (module != null) {
            if (afterFirstToken) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
            }
            this.markForPartialFormat();
            this.visitModule(module, null);
            this.builder.forcedBreak();
        }
    }

    protected void dropEmptyDeclarations() {
        if (this.builder.peekToken().equals(Optional.of(";"))) {
            while (this.builder.peekToken().equals(Optional.of(";"))) {
                this.builder.forcedBreak();
                this.markForPartialFormat();
                this.token(";");
            }
        }
    }

    @Override
    public Void visitClass(ClassTree tree, Void unused) {
        switch (tree.getKind()) {
            case ANNOTATION_TYPE: {
                this.visitAnnotationType(tree);
                break;
            }
            case CLASS: 
            case INTERFACE: {
                this.visitClassDeclaration(tree);
                break;
            }
            case ENUM: {
                this.visitEnumDeclaration(tree);
                break;
            }
            case RECORD: {
                this.visitRecordDeclaration(tree);
                break;
            }
            default: {
                throw new AssertionError((Object)tree.getKind());
            }
        }
        return null;
    }

    public void visitAnnotationType(ClassTree node) {
        this.sync(node);
        this.builder.open(ZERO);
        this.typeDeclarationModifiers(node.getModifiers());
        this.builder.open(ZERO);
        this.token("@");
        this.token("interface");
        this.builder.breakOp(" ");
        this.visit(node.getSimpleName());
        this.builder.close();
        this.builder.close();
        if (node.getMembers() == null) {
            this.builder.open(this.plusFour);
            this.token(";");
            this.builder.close();
        } else {
            this.addBodyDeclarations(node.getMembers(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
        this.builder.guessToken(";");
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree node, Void unused) {
        this.sync(node);
        this.visitDot(node);
        return null;
    }

    @Override
    public Void visitNewArray(NewArrayTree node, Void unused) {
        if (node.getType() != null) {
            this.builder.open(this.plusFour);
            this.token("new");
            this.builder.space();
            DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(node.getType(), DimensionHelpers.SortedDims.YES);
            Tree base = extractedDims.node;
            ArrayDeque<ExpressionTree> dimExpressions = new ArrayDeque<ExpressionTree>(node.getDimensions());
            ArrayDeque<List<? extends AnnotationTree>> annotations = new ArrayDeque<List<? extends AnnotationTree>>();
            annotations.add((List<? extends AnnotationTree>)ImmutableList.copyOf(node.getAnnotations()));
            annotations.addAll(node.getDimAnnotations());
            annotations.addAll((Collection<List<? extends AnnotationTree>>)extractedDims.dims);
            this.scan(base, null);
            this.builder.open(ZERO);
            this.maybeAddDims(dimExpressions, annotations);
            this.builder.close();
            this.builder.close();
        }
        if (node.getInitializers() != null) {
            if (node.getType() != null) {
                this.builder.space();
            }
            this.visitArrayInitializer(node.getInitializers());
        }
        return null;
    }

    public boolean visitArrayInitializer(List<? extends ExpressionTree> expressions) {
        if (expressions.isEmpty()) {
            this.tokenBreakTrailingComment("{", this.plusTwo);
            if (this.builder.peekToken().equals(Optional.of(","))) {
                this.token(",");
            }
            this.token("}", this.plusTwo);
        } else {
            int cols = this.argumentsAreTabular(expressions);
            if (cols != -1) {
                this.builder.open(this.plusTwo);
                this.token("{");
                this.builder.forcedBreak();
                boolean afterFirstToken = false;
                for (Iterable row : Iterables.partition(expressions, (int)cols)) {
                    if (afterFirstToken) {
                        this.builder.forcedBreak();
                    }
                    this.builder.open(((ExpressionTree)row.iterator().next()).getKind() == Tree.Kind.NEW_ARRAY || cols == 1 ? ZERO : this.plusFour);
                    boolean firstInRow = true;
                    for (ExpressionTree item : row) {
                        if (!firstInRow) {
                            this.token(",");
                            this.builder.breakToFill(" ");
                        }
                        this.scan((Tree)item, null);
                        firstInRow = false;
                    }
                    this.builder.guessToken(",");
                    this.builder.close();
                    afterFirstToken = true;
                }
                this.builder.breakOp(this.minusTwo);
                this.builder.close();
                this.token("}", this.plusTwo);
            } else {
                boolean shortItems;
                boolean inMemberValuePair = false;
                TreePath path = this.getCurrentPath();
                for (int i = 0; i < 2 && path != null; path = path.getParentPath(), ++i) {
                    if (path.getLeaf().getKind() != Tree.Kind.ANNOTATION) continue;
                    inMemberValuePair = true;
                    break;
                }
                boolean allowFilledElementsOnOwnLine = (shortItems = this.hasOnlyShortItems(expressions)) || !inMemberValuePair;
                this.builder.open(this.plusTwo);
                this.tokenBreakTrailingComment("{", this.plusTwo);
                boolean hasTrailingComma = this.hasTrailingToken(this.builder.getInput(), expressions, ",");
                this.builder.breakOp(hasTrailingComma ? Doc.FillMode.FORCED : Doc.FillMode.UNIFIED, "", ZERO);
                if (allowFilledElementsOnOwnLine) {
                    this.builder.open(ZERO);
                }
                boolean afterFirstToken = false;
                Doc.FillMode fillMode = shortItems ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
                for (ExpressionTree expressionTree : expressions) {
                    if (afterFirstToken) {
                        this.token(",");
                        this.builder.breakOp(fillMode, " ", ZERO);
                    }
                    this.scan((Tree)expressionTree, null);
                    afterFirstToken = true;
                }
                this.builder.guessToken(",");
                if (allowFilledElementsOnOwnLine) {
                    this.builder.close();
                }
                this.builder.breakOp(this.minusTwo);
                this.builder.close();
                this.token("}", this.plusTwo);
            }
        }
        return false;
    }

    private boolean hasOnlyShortItems(List<? extends ExpressionTree> expressions) {
        for (ExpressionTree expressionTree : expressions) {
            int startPosition = Trees.getStartPosition(expressionTree);
            if (this.builder.actualSize(startPosition, Trees.getEndPosition(expressionTree, this.getCurrentPath()) - startPosition) < 10) continue;
            return false;
        }
        return true;
    }

    @Override
    public Void visitArrayType(ArrayTypeTree node, Void unused) {
        this.sync(node);
        this.visitAnnotatedArrayType(node);
        return null;
    }

    private void visitAnnotatedArrayType(Tree node) {
        DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(node, DimensionHelpers.SortedDims.YES);
        this.builder.open(this.plusFour);
        this.scan(extractedDims.node, null);
        ArrayDeque<List<? extends AnnotationTree>> dims = new ArrayDeque<List<? extends AnnotationTree>>((Collection<List<? extends AnnotationTree>>)extractedDims.dims);
        this.maybeAddDims(dims);
        Verify.verify((boolean)dims.isEmpty());
        this.builder.close();
    }

    @Override
    public Void visitAssert(AssertTree node, Void unused) {
        this.sync(node);
        this.builder.open(ZERO);
        this.token("assert");
        this.builder.space();
        this.builder.open(node.getDetail() == null ? ZERO : this.plusFour);
        this.scan((Tree)node.getCondition(), null);
        if (node.getDetail() != null) {
            this.builder.breakOp(" ");
            this.token(":");
            this.builder.space();
            this.scan((Tree)node.getDetail(), null);
        }
        this.builder.close();
        this.builder.close();
        this.token(";");
        return null;
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getVariable(), null);
        this.builder.space();
        this.splitToken(Trees.operatorName(node));
        this.builder.breakOp(" ");
        this.scan((Tree)node.getExpression(), null);
        this.builder.close();
        return null;
    }

    @Override
    public Void visitBlock(BlockTree node, Void unused) {
        this.visitBlock(node, CollapseEmptyOrNot.NO, AllowLeadingBlankLine.NO, AllowTrailingBlankLine.NO);
        return null;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getVariable(), null);
        this.builder.space();
        this.splitToken(Trees.operatorName(node));
        this.builder.breakOp(" ");
        this.scan((Tree)node.getExpression(), null);
        this.builder.close();
        return null;
    }

    @Override
    public Void visitBreak(BreakTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.token("break");
        if (node.getLabel() != null) {
            this.builder.breakOp(" ");
            this.visit(node.getLabel());
        }
        this.builder.close();
        this.token(";");
        return null;
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.token("(");
        this.scan(node.getType(), null);
        this.token(")");
        this.builder.breakOp(" ");
        this.scan((Tree)node.getExpression(), null);
        this.builder.close();
        return null;
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void unused) {
        this.sync(node);
        this.builder.open(ZERO);
        if (node.getEnclosingExpression() != null) {
            this.scan((Tree)node.getEnclosingExpression(), null);
            this.builder.breakOp();
            this.token(".");
        }
        this.token("new");
        this.builder.space();
        this.addTypeArguments(node.getTypeArguments(), this.plusFour);
        if (node.getClassBody() != null) {
            ImmutableList<AnnotationTree> annotations = this.visitModifiers(node.getClassBody().getModifiers(), Direction.HORIZONTAL, Optional.empty());
            this.visitAnnotations((List<? extends AnnotationTree>)annotations, BreakOrNot.NO, BreakOrNot.YES);
        }
        this.scan((Tree)node.getIdentifier(), null);
        this.addArguments(node.getArguments(), this.plusFour);
        this.builder.close();
        if (node.getClassBody() != null) {
            this.addBodyDeclarations(node.getClassBody().getMembers(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
        return null;
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getCondition(), null);
        this.builder.breakOp(" ");
        this.token("?");
        this.builder.space();
        this.scan((Tree)node.getTrueExpression(), null);
        this.builder.breakOp(" ");
        this.token(":");
        this.builder.space();
        this.scan((Tree)node.getFalseExpression(), null);
        this.builder.close();
        return null;
    }

    @Override
    public Void visitContinue(ContinueTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.token("continue");
        if (node.getLabel() != null) {
            this.builder.breakOp(" ");
            this.visit(node.getLabel());
        }
        this.token(";");
        this.builder.close();
        return null;
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree node, Void unused) {
        this.sync(node);
        this.token("do");
        this.visitStatement(node.getStatement(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.YES);
        if (node.getStatement().getKind() == Tree.Kind.BLOCK) {
            this.builder.space();
        } else {
            this.builder.breakOp(" ");
        }
        this.token("while");
        this.builder.space();
        this.token("(");
        this.scan((Tree)Trees.skipParen(node.getCondition()), null);
        this.token(")");
        this.token(";");
        return null;
    }

    @Override
    public Void visitEmptyStatement(EmptyStatementTree node, Void unused) {
        this.sync(node);
        this.dropEmptyDeclarations();
        return null;
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void unused) {
        this.sync(node);
        this.builder.open(ZERO);
        this.token("for");
        this.builder.space();
        this.token("(");
        this.builder.open(ZERO);
        this.visitToDeclare(DeclarationKind.NONE, Direction.HORIZONTAL, node.getVariable(), Optional.of(node.getExpression()), ":", Optional.empty());
        this.builder.close();
        this.token(")");
        this.builder.close();
        this.visitStatement(node.getStatement(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        return null;
    }

    private void visitEnumConstantDeclaration(VariableTree enumConstant) {
        for (AnnotationTree annotationTree : enumConstant.getModifiers().getAnnotations()) {
            this.scan((Tree)annotationTree, null);
            this.builder.forcedBreak();
        }
        this.visit(enumConstant.getName());
        NewClassTree init = (NewClassTree)enumConstant.getInitializer();
        if (init.getArguments().isEmpty()) {
            this.builder.guessToken("(");
            this.builder.guessToken(")");
        } else {
            this.addArguments(init.getArguments(), this.plusFour);
        }
        if (init.getClassBody() != null) {
            this.addBodyDeclarations(init.getClassBody().getMembers(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
    }

    public boolean visitEnumDeclaration(ClassTree node) {
        this.sync(node);
        this.builder.open(ZERO);
        this.typeDeclarationModifiers(node.getModifiers());
        this.builder.open(this.plusFour);
        this.token("enum");
        this.builder.breakOp(" ");
        this.visit(node.getSimpleName());
        this.builder.close();
        this.builder.close();
        if (!node.getImplementsClause().isEmpty()) {
            this.builder.open(this.plusFour);
            this.builder.breakOp(" ");
            this.builder.open(this.plusFour);
            this.token("implements");
            this.builder.breakOp(" ");
            this.builder.open(ZERO);
            boolean afterFirstToken = false;
            for (Tree tree : node.getImplementsClause()) {
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                this.scan(tree, null);
                afterFirstToken = true;
            }
            this.builder.close();
            this.builder.close();
            this.builder.close();
        }
        this.builder.space();
        this.tokenBreakTrailingComment("{", this.plusTwo);
        ArrayList<JCTree.JCVariableDecl> enumConstants = new ArrayList<JCTree.JCVariableDecl>();
        ArrayList<Tree> members = new ArrayList<Tree>();
        for (Tree tree : node.getMembers()) {
            if (tree instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)tree;
                if ((jCVariableDecl.mods.flags & 0x4000L) == 16384L) {
                    enumConstants.add(jCVariableDecl);
                    continue;
                }
            }
            members.add(tree);
        }
        if (enumConstants.isEmpty() && members.isEmpty()) {
            if (this.builder.peekToken().equals(Optional.of(";"))) {
                this.builder.open(this.plusTwo);
                this.builder.forcedBreak();
                this.token(";");
                this.builder.forcedBreak();
                this.dropEmptyDeclarations();
                this.builder.close();
                this.builder.open(ZERO);
                this.builder.forcedBreak();
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.token("}", this.plusTwo);
                this.builder.close();
            } else {
                this.builder.open(ZERO);
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.token("}");
                this.builder.close();
            }
        } else {
            this.builder.open(this.plusTwo);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.builder.forcedBreak();
            this.builder.open(ZERO);
            boolean bl = false;
            for (VariableTree variableTree : enumConstants) {
                boolean bl2;
                if (bl2) {
                    this.token(",");
                    this.builder.forcedBreak();
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                }
                this.markForPartialFormat();
                this.visitEnumConstantDeclaration(variableTree);
                bl2 = true;
            }
            if (this.builder.peekToken().orElse("").equals(",")) {
                this.token(",");
                this.builder.forcedBreak();
            }
            this.builder.close();
            this.builder.close();
            if (this.builder.peekToken().equals(Optional.of(";"))) {
                this.builder.open(this.plusTwo);
                this.token(";");
                this.builder.forcedBreak();
                this.dropEmptyDeclarations();
                this.builder.close();
            }
            this.builder.open(ZERO);
            this.addBodyDeclarations(members, BracesOrNot.NO, FirstDeclarationsOrNot.NO);
            this.builder.forcedBreak();
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.token("}", this.plusTwo);
            this.builder.close();
        }
        this.builder.guessToken(";");
        return false;
    }

    public void visitRecordDeclaration(ClassTree node) {
        this.sync(node);
        this.typeDeclarationModifiers(node.getModifiers());
        Verify.verify((node.getExtendsClause() == null ? 1 : 0) != 0);
        boolean hasSuperInterfaceTypes = !node.getImplementsClause().isEmpty();
        this.token("record");
        this.builder.space();
        this.visit(node.getSimpleName());
        if (!node.getTypeParameters().isEmpty()) {
            this.token("<");
        }
        this.builder.open(this.plusFour);
        if (!node.getTypeParameters().isEmpty()) {
            this.typeParametersRest(node.getTypeParameters(), hasSuperInterfaceTypes ? this.plusFour : ZERO);
        }
        ImmutableList<JCTree.JCVariableDecl> parameters = JavaInputAstVisitor.recordVariables(node);
        this.token("(");
        if (!parameters.isEmpty()) {
            this.builder.breakToFill("");
        }
        this.visitFormals(Optional.empty(), (List<? extends VariableTree>)parameters);
        this.token(")");
        if (hasSuperInterfaceTypes) {
            this.builder.breakToFill(" ");
            this.builder.open(node.getImplementsClause().size() > 1 ? this.plusFour : ZERO);
            this.token("implements");
            this.builder.space();
            boolean afterFirstToken = false;
            for (Tree tree : node.getImplementsClause()) {
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.scan(tree, null);
                afterFirstToken = true;
            }
            this.builder.close();
        }
        this.builder.close();
        if (node.getMembers() == null) {
            this.token(";");
        } else {
            ImmutableList members = (ImmutableList)node.getMembers().stream().filter(t -> (TreeInfo.flags((JCTree)t) & 0x1000000L) == 0L).collect(ImmutableList.toImmutableList());
            this.addBodyDeclarations((List<? extends Tree>)members, BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
        this.dropEmptyDeclarations();
    }

    private static ImmutableList<JCTree.JCVariableDecl> recordVariables(ClassTree node) {
        return (ImmutableList)node.getMembers().stream().filter(JCTree.JCVariableDecl.class::isInstance).map(JCTree.JCVariableDecl.class::cast).filter(m -> (m.mods.flags & 0x2000000000000000L) == 0x2000000000000000L).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree node, Void unused) {
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getQualifierExpression(), null);
        this.builder.breakOp();
        this.builder.op("::");
        this.addTypeArguments(node.getTypeArguments(), this.plusFour);
        switch (node.getMode()) {
            case INVOKE: {
                this.visit(node.getName());
                break;
            }
            case NEW: {
                this.token("new");
                break;
            }
            default: {
                throw new AssertionError((Object)node.getMode());
            }
        }
        this.builder.close();
        return null;
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree node, Void unused) {
        this.sync(node);
        this.scan((Tree)node.getExpression(), null);
        this.token(";");
        return null;
    }

    @Override
    public Void visitVariable(VariableTree node, Void unused) {
        this.sync(node);
        this.visitVariables((List<VariableTree>)ImmutableList.of((Object)node), DeclarationKind.NONE, JavaInputAstVisitor.fieldAnnotationDirection(node.getModifiers()));
        return null;
    }

    void visitVariables(List<VariableTree> fragments, DeclarationKind declarationKind, Direction annotationDirection) {
        if (fragments.size() == 1) {
            VariableTree fragment = fragments.get(0);
            this.declareOne(declarationKind, annotationDirection, Optional.of(fragment.getModifiers()), fragment.getType(), fragment.getName(), "", "=", Optional.ofNullable(fragment.getInitializer()), Optional.of(";"), Optional.empty(), Optional.ofNullable(JavaInputAstVisitor.variableFragmentDims(false, 0, fragment.getType())));
        } else {
            this.declareMany(fragments, annotationDirection);
        }
    }

    private static DimensionHelpers.TypeWithDims variableFragmentDims(boolean afterFirstToken, int leadingDims, Tree type) {
        if (type == null) {
            return null;
        }
        if (!afterFirstToken) {
            return DimensionHelpers.extractDims(type, DimensionHelpers.SortedDims.YES);
        }
        DimensionHelpers.TypeWithDims dims = DimensionHelpers.extractDims(type, DimensionHelpers.SortedDims.NO);
        return new DimensionHelpers.TypeWithDims(null, leadingDims > 0 ? dims.dims.subList(0, dims.dims.size() - leadingDims) : dims.dims);
    }

    @Override
    public Void visitForLoop(ForLoopTree node, Void unused) {
        this.sync(node);
        this.token("for");
        this.builder.space();
        this.token("(");
        this.builder.open(this.plusFour);
        this.builder.open(node.getInitializer().size() > 1 && node.getInitializer().get(0).getKind() == Tree.Kind.EXPRESSION_STATEMENT ? this.plusFour : ZERO);
        if (!node.getInitializer().isEmpty()) {
            if (node.getInitializer().get(0).getKind() == Tree.Kind.VARIABLE) {
                PeekingIterator it = Iterators.peekingIterator(node.getInitializer().iterator());
                this.visitVariables(JavaInputAstVisitor.variableFragments((PeekingIterator<? extends Tree>)it, (Tree)it.next()), DeclarationKind.NONE, Direction.HORIZONTAL);
            } else {
                boolean afterFirstToken = false;
                this.builder.open(ZERO);
                for (StatementTree statementTree : node.getInitializer()) {
                    if (afterFirstToken) {
                        this.token(",");
                        this.builder.breakOp(" ");
                    }
                    this.scan((Tree)((ExpressionStatementTree)statementTree).getExpression(), null);
                    afterFirstToken = true;
                }
                this.token(";");
                this.builder.close();
            }
        } else {
            this.token(";");
        }
        this.builder.close();
        this.builder.breakOp(" ");
        if (node.getCondition() != null) {
            this.scan((Tree)node.getCondition(), null);
        }
        this.token(";");
        if (!node.getUpdate().isEmpty()) {
            this.builder.breakOp(" ");
            this.builder.open(node.getUpdate().size() <= 1 ? ZERO : this.plusFour);
            boolean firstUpdater = true;
            for (ExpressionStatementTree expressionStatementTree : node.getUpdate()) {
                if (!firstUpdater) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                this.scan((Tree)expressionStatementTree.getExpression(), null);
                firstUpdater = false;
            }
            this.builder.guessToken(";");
            this.builder.close();
        } else {
            this.builder.space();
        }
        this.builder.close();
        this.token(")");
        this.visitStatement(node.getStatement(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        return null;
    }

    @Override
    public Void visitIf(IfTree node, Void unused) {
        this.sync(node);
        ArrayList<ExpressionTree> expressions = new ArrayList<ExpressionTree>();
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
        while (true) {
            expressions.add(node.getCondition());
            statements.add(node.getThenStatement());
            if (node.getElseStatement() == null || node.getElseStatement().getKind() != Tree.Kind.IF) break;
            node = (IfTree)node.getElseStatement();
        }
        this.builder.open(ZERO);
        boolean afterFirstToken = false;
        boolean followingBlock = false;
        int expressionsN = expressions.size();
        for (int i = 0; i < expressionsN; ++i) {
            if (afterFirstToken) {
                if (followingBlock) {
                    this.builder.space();
                } else {
                    this.builder.forcedBreak();
                }
                this.token("else");
                this.builder.space();
            }
            this.token("if");
            this.builder.space();
            this.token("(");
            this.scan((Tree)Trees.skipParen((ExpressionTree)expressions.get(i)), null);
            this.token(")");
            boolean onlyClause = expressionsN == 1 && node.getElseStatement() == null;
            boolean trailingClauses = i < expressionsN - 1 || node.getElseStatement() != null;
            this.visitStatement((StatementTree)statements.get(i), CollapseEmptyOrNot.valueOf(onlyClause), AllowLeadingBlankLine.YES, AllowTrailingBlankLine.valueOf(trailingClauses));
            followingBlock = ((StatementTree)statements.get(i)).getKind() == Tree.Kind.BLOCK;
            afterFirstToken = true;
        }
        if (node.getElseStatement() != null) {
            if (followingBlock) {
                this.builder.space();
            } else {
                this.builder.forcedBreak();
            }
            this.token("else");
            this.visitStatement(node.getElseStatement(), CollapseEmptyOrNot.NO, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        }
        this.builder.close();
        return null;
    }

    @Override
    public Void visitImport(ImportTree node, Void unused) {
        this.checkForTypeAnnotation(node);
        this.sync(node);
        this.token("import");
        this.builder.space();
        if (node.isStatic()) {
            this.token("static");
            this.builder.space();
        }
        this.visitName(node.getQualifiedIdentifier());
        this.token(";");
        this.dropEmptyDeclarations();
        return null;
    }

    private void checkForTypeAnnotation(ImportTree node) {
        Name simpleName = JavaInputAstVisitor.getSimpleName(node);
        ImmutableCollection wellKnownAnnotations = TYPE_ANNOTATIONS.get((Object)simpleName.toString());
        if (!wellKnownAnnotations.isEmpty() && wellKnownAnnotations.contains(node.getQualifiedIdentifier().toString())) {
            this.typeAnnotationSimpleNames.add(simpleName);
        }
    }

    private static Name getSimpleName(ImportTree importTree) {
        return importTree.getQualifiedIdentifier() instanceof IdentifierTree ? ((IdentifierTree)importTree.getQualifiedIdentifier()).getName() : ((MemberSelectTree)importTree.getQualifiedIdentifier()).getIdentifier();
    }

    @Override
    public Void visitBinary(BinaryTree node, Void unused) {
        this.sync(node);
        ArrayList<ExpressionTree> operands = new ArrayList<ExpressionTree>();
        ArrayList<String> operators = new ArrayList<String>();
        JavaInputAstVisitor.walkInfix(Trees.precedence(node), node, operands, operators);
        Doc.FillMode fillMode = this.hasOnlyShortItems(operands) ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
        this.builder.open(this.plusFour);
        this.scan((Tree)operands.get(0), null);
        int operatorsN = operators.size();
        for (int i = 0; i < operatorsN; ++i) {
            this.builder.breakOp(fillMode, " ", ZERO);
            this.builder.op((String)operators.get(i));
            this.builder.space();
            this.scan((Tree)operands.get(i + 1), null);
        }
        this.builder.close();
        return null;
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getExpression(), null);
        this.builder.breakOp(" ");
        this.builder.open(ZERO);
        this.token("instanceof");
        this.builder.breakOp(" ");
        if (node.getPattern() != null) {
            this.scan((Tree)node.getPattern(), null);
        } else {
            this.scan(node.getType(), null);
        }
        this.builder.close();
        this.builder.close();
        return null;
    }

    @Override
    public Void visitIntersectionType(IntersectionTypeTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        boolean afterFirstToken = false;
        for (Tree tree : node.getBounds()) {
            if (afterFirstToken) {
                this.builder.breakToFill(" ");
                this.token("&");
                this.builder.space();
            }
            this.scan(tree, null);
            afterFirstToken = true;
        }
        this.builder.close();
        return null;
    }

    @Override
    public Void visitLabeledStatement(LabeledStatementTree node, Void unused) {
        this.sync(node);
        this.builder.open(ZERO);
        this.visit(node.getLabel());
        this.token(":");
        this.builder.forcedBreak();
        this.builder.close();
        this.scan((Tree)node.getStatement(), null);
        return null;
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
        this.sync(node);
        boolean statementBody = node.getBodyKind() == LambdaExpressionTree.BodyKind.STATEMENT;
        boolean parens = this.builder.peekToken().equals(Optional.of("("));
        this.builder.open(parens ? this.plusFour : ZERO);
        if (parens) {
            this.token("(");
        }
        boolean afterFirstToken = false;
        for (VariableTree variableTree : node.getParameters()) {
            if (afterFirstToken) {
                this.token(",");
                this.builder.breakOp(" ");
            }
            this.visitVariables((List<VariableTree>)ImmutableList.of((Object)variableTree), DeclarationKind.NONE, JavaInputAstVisitor.fieldAnnotationDirection(variableTree.getModifiers()));
            afterFirstToken = true;
        }
        if (parens) {
            this.token(")");
        }
        this.builder.close();
        this.builder.space();
        this.builder.op("->");
        this.builder.open(statementBody ? ZERO : this.plusFour);
        if (statementBody) {
            this.builder.space();
        } else {
            this.builder.breakOp(" ");
        }
        if (node.getBody().getKind() == Tree.Kind.BLOCK) {
            this.visitBlock((BlockTree)node.getBody(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.NO, AllowTrailingBlankLine.NO);
        } else {
            this.scan(node.getBody(), null);
        }
        this.builder.close();
        return null;
    }

    @Override
    public Void visitAnnotation(AnnotationTree node, Void unused) {
        this.sync(node);
        if (this.visitSingleMemberAnnotation(node)) {
            return null;
        }
        this.builder.open(ZERO);
        this.token("@");
        this.scan(node.getAnnotationType(), null);
        if (!node.getArguments().isEmpty()) {
            this.builder.open(this.plusFour);
            this.token("(");
            this.builder.breakOp();
            boolean afterFirstToken = false;
            boolean hasArrayInitializer = Iterables.any(node.getArguments(), JavaInputAstVisitor::isArrayValue);
            for (ExpressionTree expressionTree : node.getArguments()) {
                if (afterFirstToken) {
                    this.token(",");
                    if (hasArrayInitializer) {
                        this.builder.forcedBreak();
                    } else {
                        this.builder.breakOp(" ");
                    }
                }
                if (expressionTree instanceof AssignmentTree) {
                    this.visitAnnotationArgument((AssignmentTree)expressionTree);
                } else {
                    this.scan((Tree)expressionTree, null);
                }
                afterFirstToken = true;
            }
            this.token(")");
            this.builder.close();
            this.builder.close();
            return null;
        }
        if (this.builder.peekToken().equals(Optional.of("("))) {
            this.token("(");
            this.token(")");
        }
        this.builder.close();
        return null;
    }

    private static boolean isArrayValue(ExpressionTree argument) {
        if (!(argument instanceof AssignmentTree)) {
            return false;
        }
        ExpressionTree expression = ((AssignmentTree)argument).getExpression();
        return expression instanceof NewArrayTree && ((NewArrayTree)expression).getType() == null;
    }

    public void visitAnnotationArgument(AssignmentTree node) {
        boolean isArrayInitializer = node.getExpression().getKind() == Tree.Kind.NEW_ARRAY;
        this.sync(node);
        this.builder.open(isArrayInitializer ? ZERO : this.plusFour);
        this.scan((Tree)node.getVariable(), null);
        this.builder.space();
        this.token("=");
        if (isArrayInitializer) {
            this.builder.space();
        } else {
            this.builder.breakOp(" ");
        }
        this.scan((Tree)node.getExpression(), null);
        this.builder.close();
    }

    @Override
    public Void visitAnnotatedType(AnnotatedTypeTree node, Void unused) {
        this.sync(node);
        ExpressionTree base = node.getUnderlyingType();
        if (base instanceof MemberSelectTree) {
            MemberSelectTree selectTree = (MemberSelectTree)base;
            this.scan((Tree)selectTree.getExpression(), null);
            this.token(".");
            this.visitAnnotations(node.getAnnotations(), BreakOrNot.NO, BreakOrNot.NO);
            this.builder.breakToFill(" ");
            this.visit(selectTree.getIdentifier());
        } else if (base instanceof ArrayTypeTree) {
            this.visitAnnotatedArrayType(node);
        } else {
            this.visitAnnotations(node.getAnnotations(), BreakOrNot.NO, BreakOrNot.NO);
            this.builder.breakToFill(" ");
            this.scan((Tree)base, null);
        }
        return null;
    }

    @Override
    public Void visitMethod(MethodTree node, Void unused) {
        String name;
        boolean isRecordConstructor;
        this.sync(node);
        List<? extends AnnotationTree> annotations = node.getModifiers().getAnnotations();
        Object returnTypeAnnotations = ImmutableList.of();
        boolean bl = isRecordConstructor = (((JCTree.JCMethodDecl)node).mods.flags & 0x8000000000000L) == 0x8000000000000L;
        if (!node.getTypeParameters().isEmpty() && !annotations.isEmpty()) {
            int typeParameterStart = Trees.getStartPosition(node.getTypeParameters().get(0));
            for (int i = 0; i < annotations.size(); ++i) {
                if (Trees.getStartPosition(annotations.get(i)) <= typeParameterStart) continue;
                returnTypeAnnotations = annotations.subList(i, annotations.size());
                annotations = annotations.subList(0, i);
                break;
            }
        }
        ImmutableList typeAnnotations = this.visitModifiers(node.getModifiers(), annotations, Direction.VERTICAL, Optional.empty());
        if (node.getTypeParameters().isEmpty() && node.getReturnType() != null) {
            returnTypeAnnotations = typeAnnotations;
            typeAnnotations = ImmutableList.of();
        }
        Tree baseReturnType = null;
        ArrayDeque<List<? extends AnnotationTree>> dims = null;
        if (node.getReturnType() != null) {
            DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(node.getReturnType(), DimensionHelpers.SortedDims.YES);
            baseReturnType = extractedDims.node;
            dims = new ArrayDeque<List<? extends AnnotationTree>>((Collection<List<? extends AnnotationTree>>)extractedDims.dims);
        } else {
            this.verticalAnnotations((List<AnnotationTree>)typeAnnotations);
            typeAnnotations = ImmutableList.of();
        }
        this.builder.open(this.plusFour);
        Output.BreakTag breakBeforeName = this.genSym();
        Output.BreakTag breakBeforeType = this.genSym();
        this.builder.open(ZERO);
        boolean afterFirstToken = false;
        if (!typeAnnotations.isEmpty()) {
            this.visitAnnotations((List<? extends AnnotationTree>)typeAnnotations, BreakOrNot.NO, BreakOrNot.NO);
            afterFirstToken = true;
        }
        if (!node.getTypeParameters().isEmpty()) {
            if (afterFirstToken) {
                this.builder.breakToFill(" ");
            }
            this.token("<");
            this.typeParametersRest(node.getTypeParameters(), this.plusFour);
            afterFirstToken = true;
        }
        boolean openedNameAndTypeScope = false;
        if (baseReturnType != null) {
            if (afterFirstToken) {
                this.builder.breakOp(Doc.FillMode.INDEPENDENT, " ", ZERO, Optional.of(breakBeforeType));
            } else {
                afterFirstToken = true;
            }
            if (!openedNameAndTypeScope) {
                this.builder.open(Indent.If.make(breakBeforeType, this.plusFour, ZERO));
                openedNameAndTypeScope = true;
            }
            this.builder.open(ZERO);
            if (!returnTypeAnnotations.isEmpty()) {
                this.visitAnnotations((List<? extends AnnotationTree>)returnTypeAnnotations, BreakOrNot.NO, BreakOrNot.NO);
                this.builder.breakOp(" ");
            }
            this.scan(baseReturnType, null);
            this.maybeAddDims(dims);
            this.builder.close();
        }
        if (afterFirstToken) {
            this.builder.breakOp(Doc.FillMode.INDEPENDENT, " ", ZERO, Optional.of(breakBeforeName));
        } else {
            afterFirstToken = true;
        }
        if (!openedNameAndTypeScope) {
            this.builder.open(ZERO);
            openedNameAndTypeScope = true;
        }
        if ((name = node.getName().toString()).equals("<init>")) {
            name = this.builder.peekToken().get();
        }
        this.token(name);
        if (!isRecordConstructor) {
            this.token("(");
        }
        this.builder.close();
        this.builder.close();
        this.builder.open(Indent.If.make(breakBeforeName, this.plusFour, ZERO));
        this.builder.open(Indent.If.make(breakBeforeType, this.plusFour, ZERO));
        this.builder.open(ZERO);
        if (!isRecordConstructor) {
            if (!node.getParameters().isEmpty() || node.getReceiverParameter() != null) {
                this.builder.breakToFill("");
                this.visitFormals(Optional.ofNullable(node.getReceiverParameter()), node.getParameters());
            }
            this.token(")");
        }
        if (dims != null) {
            this.maybeAddDims(dims);
        }
        if (!node.getThrows().isEmpty()) {
            this.builder.breakToFill(" ");
            this.builder.open(this.plusFour);
            this.visitThrowsClause(node.getThrows());
            this.builder.close();
        }
        if (node.getDefaultValue() != null) {
            this.builder.space();
            this.token("default");
            if (node.getDefaultValue().getKind() == Tree.Kind.NEW_ARRAY) {
                this.builder.open(this.minusFour);
                this.builder.space();
                this.scan(node.getDefaultValue(), null);
                this.builder.close();
            } else {
                this.builder.open(ZERO);
                this.builder.breakToFill(" ");
                this.scan(node.getDefaultValue(), null);
                this.builder.close();
            }
        }
        this.builder.close();
        this.builder.close();
        this.builder.close();
        if (node.getBody() == null) {
            this.token(";");
        } else {
            this.builder.space();
            this.builder.token("{", Doc.Token.RealOrImaginary.REAL, this.plusTwo, Optional.of(this.plusTwo));
        }
        this.builder.close();
        if (node.getBody() != null) {
            this.methodBody(node);
        }
        return null;
    }

    private void methodBody(MethodTree node) {
        if (node.getBody().getStatements().isEmpty()) {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        } else {
            this.builder.open(this.plusTwo);
            this.builder.forcedBreak();
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            this.visitStatements(node.getBody().getStatements());
            this.builder.close();
            this.builder.forcedBreak();
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.markForPartialFormat();
        }
        this.token("}", this.plusTwo);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
        this.sync(node);
        if (this.handleLogStatement(node)) {
            return null;
        }
        this.visitDot(node);
        return null;
    }

    private boolean handleLogStatement(MethodInvocationTree node) {
        if (!Trees.getMethodName(node).contentEquals("log")) {
            return false;
        }
        ArrayDeque<MethodInvocationTree> parts = new ArrayDeque<MethodInvocationTree>();
        ExpressionTree curr = node;
        while (curr instanceof MethodInvocationTree) {
            MethodInvocationTree method = curr;
            parts.addFirst(method);
            if (!LOG_METHODS.contains((Object)Trees.getMethodName(method).toString())) {
                return false;
            }
            curr = Trees.getMethodReceiver(method);
        }
        if (!(curr instanceof IdentifierTree)) {
            return false;
        }
        parts.addFirst((MethodInvocationTree)curr);
        this.visitDotWithPrefix((List<ExpressionTree>)ImmutableList.copyOf(parts), false, (Collection<Integer>)ImmutableList.of((Object)(parts.size() - 1)), Doc.FillMode.INDEPENDENT);
        return true;
    }

    private static List<Long> handleStream(List<ExpressionTree> parts) {
        return JavaInputAstVisitor.indexes(parts.stream(), p -> {
            if (!(p instanceof MethodInvocationTree)) {
                return false;
            }
            Name name = Trees.getMethodName((MethodInvocationTree)p);
            return Stream.of("stream", "parallelStream", "toBuilder").anyMatch(name::contentEquals);
        }).collect(Collectors.toList());
    }

    private static <T> Stream<Long> indexes(Stream<T> stream, Predicate<T> predicate) {
        return Streams.mapWithIndex(stream, (x, i) -> predicate.apply(x) ? i : -1L).filter(x -> x != -1L);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void unused) {
        this.sync(node);
        this.visitDot(node);
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree node, Void unused) {
        this.sync(node);
        String sourceForNode = Trees.getSourceForNode(node, this.getCurrentPath());
        if (JavaInputAstVisitor.isUnaryMinusLiteral(sourceForNode)) {
            this.token("-");
            sourceForNode = sourceForNode.substring(1).trim();
        }
        this.token(sourceForNode);
        return null;
    }

    private static boolean isUnaryMinusLiteral(String literalTreeSource) {
        return literalTreeSource.startsWith("-");
    }

    private void visitPackage(ExpressionTree packageName, List<? extends AnnotationTree> packageAnnotations) {
        if (!packageAnnotations.isEmpty()) {
            for (AnnotationTree annotationTree : packageAnnotations) {
                this.builder.forcedBreak();
                this.scan((Tree)annotationTree, null);
            }
            this.builder.forcedBreak();
        }
        this.builder.open(this.plusFour);
        this.token("package");
        this.builder.space();
        this.visitName(packageName);
        this.builder.close();
        this.token(";");
    }

    @Override
    public Void visitParameterizedType(ParameterizedTypeTree node, Void unused) {
        this.sync(node);
        if (node.getTypeArguments().isEmpty()) {
            this.scan(node.getType(), null);
            this.token("<");
            this.token(">");
        } else {
            this.builder.open(this.plusFour);
            this.scan(node.getType(), null);
            this.token("<");
            this.builder.breakOp();
            this.builder.open(ZERO);
            boolean afterFirstToken = false;
            for (Tree tree : node.getTypeArguments()) {
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.scan(tree, null);
                afterFirstToken = true;
            }
            this.builder.close();
            this.builder.close();
            this.token(">");
        }
        return null;
    }

    @Override
    public Void visitParenthesized(ParenthesizedTree node, Void unused) {
        this.token("(");
        this.scan((Tree)node.getExpression(), null);
        this.token(")");
        return null;
    }

    @Override
    public Void visitUnary(UnaryTree node, Void unused) {
        this.sync(node);
        String operatorName = Trees.operatorName(node);
        if (((JCTree)((Object)node)).getTag().isPostUnaryOp()) {
            this.scan((Tree)node.getExpression(), null);
            this.splitToken(operatorName);
        } else {
            this.splitToken(operatorName);
            if (this.ambiguousUnaryOperator(node, operatorName)) {
                this.builder.space();
            }
            this.scan((Tree)node.getExpression(), null);
        }
        return null;
    }

    private void splitToken(String operatorName) {
        for (int i = 0; i < operatorName.length(); ++i) {
            this.token(String.valueOf(operatorName.charAt(i)));
        }
    }

    private boolean ambiguousUnaryOperator(UnaryTree node, String operatorName) {
        switch (node.getKind()) {
            case UNARY_MINUS: 
            case UNARY_PLUS: {
                break;
            }
            default: {
                return false;
            }
        }
        JCTree.Tag tag = this.unaryTag(node.getExpression());
        if (tag == null) {
            return false;
        }
        if (tag.isPostUnaryOp()) {
            return false;
        }
        return Trees.operatorName(node).startsWith(operatorName);
    }

    private JCTree.Tag unaryTag(ExpressionTree expression) {
        if (expression instanceof UnaryTree) {
            return ((JCTree)((Object)expression)).getTag();
        }
        if (expression instanceof LiteralTree && JavaInputAstVisitor.isUnaryMinusLiteral(Trees.getSourceForNode(expression, this.getCurrentPath()))) {
            return JCTree.Tag.MINUS;
        }
        return null;
    }

    @Override
    public Void visitPrimitiveType(PrimitiveTypeTree node, Void unused) {
        this.sync(node);
        switch (node.getPrimitiveTypeKind()) {
            case BOOLEAN: {
                this.token("boolean");
                break;
            }
            case BYTE: {
                this.token("byte");
                break;
            }
            case SHORT: {
                this.token("short");
                break;
            }
            case INT: {
                this.token("int");
                break;
            }
            case LONG: {
                this.token("long");
                break;
            }
            case CHAR: {
                this.token("char");
                break;
            }
            case FLOAT: {
                this.token("float");
                break;
            }
            case DOUBLE: {
                this.token("double");
                break;
            }
            case VOID: {
                this.token("void");
                break;
            }
            default: {
                throw new AssertionError((Object)node.getPrimitiveTypeKind());
            }
        }
        return null;
    }

    public boolean visit(Name name) {
        this.token(name.toString());
        return false;
    }

    @Override
    public Void visitReturn(ReturnTree node, Void unused) {
        this.sync(node);
        this.token("return");
        if (node.getExpression() != null) {
            this.builder.space();
            this.scan((Tree)node.getExpression(), null);
        }
        this.token(";");
        return null;
    }

    boolean visitSingleMemberAnnotation(AnnotationTree node) {
        if (node.getArguments().size() != 1) {
            return false;
        }
        ExpressionTree value = (ExpressionTree)Iterables.getOnlyElement(node.getArguments());
        if (value.getKind() == Tree.Kind.ASSIGNMENT) {
            return false;
        }
        boolean isArrayInitializer = value.getKind() == Tree.Kind.NEW_ARRAY;
        this.builder.open(isArrayInitializer ? ZERO : this.plusFour);
        this.token("@");
        this.scan(node.getAnnotationType(), null);
        this.token("(");
        if (!isArrayInitializer) {
            this.builder.breakOp();
        }
        this.scan((Tree)value, null);
        this.builder.close();
        this.token(")");
        return true;
    }

    @Override
    public Void visitCase(CaseTree node, Void unused) {
        this.sync(node);
        this.markForPartialFormat();
        this.builder.forcedBreak();
        List<? extends CaseLabelTree> labels = node.getLabels();
        boolean isDefault = labels.size() == 1 && ((CaseLabelTree)Iterables.getOnlyElement(labels)).getKind().name().equals("DEFAULT_CASE_LABEL");
        this.builder.open(node.getCaseKind().equals((Object)CaseTree.CaseKind.RULE) ? this.plusFour : ZERO);
        if (isDefault) {
            this.token("default", ZERO);
        } else {
            this.token("case", ZERO);
            this.builder.open(ZERO);
            this.builder.space();
            boolean afterFirstToken = false;
            for (Tree tree : labels) {
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.scan(tree, null);
                afterFirstToken = true;
            }
            this.builder.close();
        }
        ExpressionTree guard = this.getGuard(node);
        if (guard != null) {
            this.builder.breakToFill(" ");
            this.token("when");
            this.builder.space();
            this.scan((Tree)guard, null);
        }
        switch (node.getCaseKind()) {
            case STATEMENT: {
                this.token(":");
                this.builder.open(this.plusTwo);
                this.visitStatements(node.getStatements());
                this.builder.close();
                this.builder.close();
                break;
            }
            case RULE: {
                this.builder.space();
                this.token("-");
                this.token(">");
                if (node.getBody().getKind() == Tree.Kind.BLOCK) {
                    this.builder.close();
                    this.builder.space();
                    this.visitBlock((BlockTree)node.getBody(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.NO, AllowTrailingBlankLine.NO);
                } else {
                    this.builder.breakOp(" ");
                    this.scan(node.getBody(), null);
                    this.builder.close();
                }
                this.builder.guessToken(";");
            }
        }
        return null;
    }

    protected ExpressionTree getGuard(CaseTree node) {
        return null;
    }

    @Override
    public Void visitSwitch(SwitchTree node, Void unused) {
        this.sync(node);
        this.visitSwitch(node.getExpression(), node.getCases());
        return null;
    }

    protected void visitSwitch(ExpressionTree expression, List<? extends CaseTree> cases) {
        this.token("switch");
        this.builder.space();
        this.token("(");
        this.scan((Tree)Trees.skipParen(expression), null);
        this.token(")");
        this.builder.space();
        this.tokenBreakTrailingComment("{", this.plusTwo);
        this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        this.builder.open(this.plusTwo);
        boolean afterFirstToken = false;
        for (CaseTree caseTree : cases) {
            if (afterFirstToken) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            this.scan((Tree)caseTree, null);
            afterFirstToken = true;
        }
        this.builder.close();
        this.builder.forcedBreak();
        this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        this.token("}", this.plusFour);
    }

    @Override
    public Void visitSynchronized(SynchronizedTree node, Void unused) {
        this.sync(node);
        this.token("synchronized");
        this.builder.space();
        this.token("(");
        this.builder.open(this.plusFour);
        this.builder.breakOp();
        this.scan((Tree)Trees.skipParen(node.getExpression()), null);
        this.builder.close();
        this.token(")");
        this.builder.space();
        this.scan((Tree)node.getBlock(), null);
        return null;
    }

    @Override
    public Void visitThrow(ThrowTree node, Void unused) {
        this.sync(node);
        this.token("throw");
        this.builder.space();
        this.scan((Tree)node.getExpression(), null);
        this.token(";");
        return null;
    }

    @Override
    public Void visitTry(TryTree node, Void unused) {
        this.sync(node);
        this.builder.open(ZERO);
        this.token("try");
        this.builder.space();
        if (!node.getResources().isEmpty()) {
            this.token("(");
            this.builder.open(node.getResources().size() > 1 ? this.plusFour : ZERO);
            boolean afterFirstToken = false;
            for (Tree tree : node.getResources()) {
                if (afterFirstToken) {
                    this.builder.forcedBreak();
                }
                if (tree instanceof VariableTree) {
                    VariableTree variableTree = (VariableTree)tree;
                    this.declareOne(DeclarationKind.PARAMETER, JavaInputAstVisitor.fieldAnnotationDirection(variableTree.getModifiers()), Optional.of(variableTree.getModifiers()), variableTree.getType(), variableTree.getName(), "", "=", Optional.ofNullable(variableTree.getInitializer()), Optional.empty(), Optional.empty(), Optional.empty());
                } else {
                    this.scan(tree, null);
                }
                if (this.builder.peekToken().equals(Optional.of(";"))) {
                    this.token(";");
                    this.builder.space();
                }
                afterFirstToken = true;
            }
            if (this.builder.peekToken().equals(Optional.of(";"))) {
                this.token(";");
                this.builder.space();
            }
            this.token(")");
            this.builder.close();
            this.builder.space();
        }
        boolean trailingClauses = !node.getCatches().isEmpty() || node.getFinallyBlock() != null;
        this.visitBlock(node.getBlock(), CollapseEmptyOrNot.valueOf(!trailingClauses), AllowLeadingBlankLine.YES, AllowTrailingBlankLine.valueOf(trailingClauses));
        for (int i = 0; i < node.getCatches().size(); ++i) {
            CatchTree catchTree = node.getCatches().get(i);
            trailingClauses = i < node.getCatches().size() - 1 || node.getFinallyBlock() != null;
            this.visitCatchClause(catchTree, AllowTrailingBlankLine.valueOf(trailingClauses));
        }
        if (node.getFinallyBlock() != null) {
            this.builder.space();
            this.token("finally");
            this.builder.space();
            this.visitBlock(node.getFinallyBlock(), CollapseEmptyOrNot.NO, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        }
        this.builder.close();
        return null;
    }

    public void visitClassDeclaration(ClassTree node) {
        this.sync(node);
        this.typeDeclarationModifiers(node.getModifiers());
        List<? extends Tree> permitsTypes = node.getPermitsClause();
        boolean hasSuperclassType = node.getExtendsClause() != null;
        boolean hasSuperInterfaceTypes = !node.getImplementsClause().isEmpty();
        boolean hasPermitsTypes = !permitsTypes.isEmpty();
        this.token(node.getKind() == Tree.Kind.INTERFACE ? "interface" : "class");
        this.builder.space();
        this.visit(node.getSimpleName());
        if (!node.getTypeParameters().isEmpty()) {
            this.token("<");
        }
        this.builder.open(this.plusFour);
        if (!node.getTypeParameters().isEmpty()) {
            this.typeParametersRest(node.getTypeParameters(), hasSuperclassType || hasSuperInterfaceTypes || hasPermitsTypes ? this.plusFour : ZERO);
        }
        if (hasSuperclassType) {
            this.builder.breakToFill(" ");
            this.token("extends");
            this.builder.space();
            this.scan(node.getExtendsClause(), null);
        }
        this.classDeclarationTypeList(node.getKind() == Tree.Kind.INTERFACE ? "extends" : "implements", node.getImplementsClause());
        this.classDeclarationTypeList("permits", permitsTypes);
        this.builder.close();
        if (node.getMembers() == null) {
            this.token(";");
        } else {
            this.addBodyDeclarations(node.getMembers(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
        this.dropEmptyDeclarations();
    }

    @Override
    public Void visitTypeParameter(TypeParameterTree node, Void unused) {
        this.sync(node);
        this.builder.open(ZERO);
        this.visitAnnotations(node.getAnnotations(), BreakOrNot.NO, BreakOrNot.YES);
        this.visit(node.getName());
        if (!node.getBounds().isEmpty()) {
            this.builder.space();
            this.token("extends");
            this.builder.open(this.plusFour);
            this.builder.breakOp(" ");
            this.builder.open(this.plusFour);
            boolean afterFirstToken = false;
            for (Tree tree : node.getBounds()) {
                if (afterFirstToken) {
                    this.builder.breakToFill(" ");
                    this.token("&");
                    this.builder.space();
                }
                this.scan(tree, null);
                afterFirstToken = true;
            }
            this.builder.close();
            this.builder.close();
        }
        this.builder.close();
        return null;
    }

    @Override
    public Void visitUnionType(UnionTypeTree node, Void unused) {
        throw new IllegalStateException("expected manual descent into union types");
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree node, Void unused) {
        this.sync(node);
        this.token("while");
        this.builder.space();
        this.token("(");
        this.scan((Tree)Trees.skipParen(node.getCondition()), null);
        this.token(")");
        this.visitStatement(node.getStatement(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        return null;
    }

    @Override
    public Void visitWildcard(WildcardTree node, Void unused) {
        this.sync(node);
        this.builder.open(ZERO);
        this.token("?");
        if (node.getBound() != null) {
            this.builder.open(this.plusFour);
            this.builder.space();
            this.token(node.getKind() == Tree.Kind.EXTENDS_WILDCARD ? "extends" : "super");
            this.builder.breakOp(" ");
            this.scan(node.getBound(), null);
            this.builder.close();
        }
        this.builder.close();
        return null;
    }

    protected void visitAnnotations(List<? extends AnnotationTree> annotations, BreakOrNot breakBefore, BreakOrNot breakAfter) {
        if (!annotations.isEmpty()) {
            if (breakBefore.isYes()) {
                this.builder.breakToFill(" ");
            }
            boolean afterFirstToken = false;
            for (AnnotationTree annotationTree : annotations) {
                if (afterFirstToken) {
                    this.builder.breakToFill(" ");
                }
                this.scan((Tree)annotationTree, null);
                afterFirstToken = true;
            }
            if (breakAfter.isYes()) {
                this.builder.breakToFill(" ");
            }
        }
    }

    void verticalAnnotations(List<AnnotationTree> annotations) {
        for (AnnotationTree annotation : annotations) {
            this.builder.forcedBreak();
            this.scan((Tree)annotation, null);
            this.builder.forcedBreak();
        }
    }

    protected void visitBlock(BlockTree node, CollapseEmptyOrNot collapseEmptyOrNot, AllowLeadingBlankLine allowLeadingBlankLine, AllowTrailingBlankLine allowTrailingBlankLine) {
        this.sync(node);
        if (node.isStatic()) {
            this.token("static");
            this.builder.space();
        }
        if (collapseEmptyOrNot.isYes() && node.getStatements().isEmpty()) {
            if (this.builder.peekToken().equals(Optional.of(";"))) {
                this.token(";");
            } else {
                this.tokenBreakTrailingComment("{", this.plusTwo);
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.token("}", this.plusTwo);
            }
        } else {
            this.builder.open(ZERO);
            this.builder.open(this.plusTwo);
            this.tokenBreakTrailingComment("{", this.plusTwo);
            if (allowLeadingBlankLine == AllowLeadingBlankLine.NO) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            } else {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            this.visitStatements(node.getStatements());
            this.builder.close();
            this.builder.forcedBreak();
            this.builder.close();
            if (allowTrailingBlankLine == AllowTrailingBlankLine.NO) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            } else {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            this.markForPartialFormat();
            this.token("}", this.plusTwo);
        }
    }

    private void visitStatement(StatementTree node, CollapseEmptyOrNot collapseEmptyOrNot, AllowLeadingBlankLine allowLeadingBlank, AllowTrailingBlankLine allowTrailingBlank) {
        this.sync(node);
        switch (node.getKind()) {
            case BLOCK: {
                this.builder.space();
                this.visitBlock((BlockTree)node, collapseEmptyOrNot, allowLeadingBlank, allowTrailingBlank);
                break;
            }
            default: {
                this.builder.open(this.plusTwo);
                this.builder.breakOp(" ");
                this.scan((Tree)node, null);
                this.builder.close();
            }
        }
    }

    protected void visitStatements(List<? extends StatementTree> statements) {
        boolean afterFirstToken = false;
        PeekingIterator it = Iterators.peekingIterator(statements.iterator());
        this.dropEmptyDeclarations();
        while (it.hasNext()) {
            StatementTree tree = (StatementTree)it.next();
            this.builder.forcedBreak();
            if (afterFirstToken) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            this.markForPartialFormat();
            afterFirstToken = true;
            List<VariableTree> fragments = JavaInputAstVisitor.variableFragments((PeekingIterator<? extends Tree>)it, tree);
            if (!fragments.isEmpty()) {
                this.visitVariables(fragments, DeclarationKind.NONE, JavaInputAstVisitor.canLocalHaveHorizontalAnnotations(fragments.get(0).getModifiers()));
                continue;
            }
            this.scan((Tree)tree, null);
        }
    }

    protected void typeDeclarationModifiers(ModifiersTree modifiers) {
        ImmutableList<AnnotationTree> typeAnnotations = this.visitModifiers(modifiers, Direction.VERTICAL, Optional.empty());
        this.verticalAnnotations((List<AnnotationTree>)typeAnnotations);
    }

    void visitAndBreakModifiers(ModifiersTree modifiers, Direction annotationDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        ImmutableList<AnnotationTree> typeAnnotations = this.visitModifiers(modifiers, annotationDirection, declarationAnnotationBreak);
        this.visitAnnotations((List<? extends AnnotationTree>)typeAnnotations, BreakOrNot.NO, BreakOrNot.YES);
    }

    @Override
    public Void visitModifiers(ModifiersTree node, Void unused) {
        throw new IllegalStateException("expected manual descent into modifiers");
    }

    @CheckReturnValue
    protected ImmutableList<AnnotationTree> visitModifiers(ModifiersTree modifiersTree, Direction annotationsDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        return this.visitModifiers(modifiersTree, modifiersTree.getAnnotations(), annotationsDirection, declarationAnnotationBreak);
    }

    @CheckReturnValue
    protected ImmutableList<AnnotationTree> visitModifiers(ModifiersTree modifiersTree, List<? extends AnnotationTree> annotationTrees, Direction annotationsDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        DeclarationModifiersAndTypeAnnotations splitModifiers = this.splitModifiers(modifiersTree, annotationTrees);
        return this.visitModifiers(splitModifiers, annotationsDirection, declarationAnnotationBreak);
    }

    @CheckReturnValue
    private ImmutableList<AnnotationTree> visitModifiers(DeclarationModifiersAndTypeAnnotations splitModifiers, Direction annotationsDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        ImmutableList<Op> trailingBreak;
        if (splitModifiers.declarationModifiers().isEmpty()) {
            return splitModifiers.typeAnnotations();
        }
        ArrayDeque<AnnotationOrModifier> declarationModifiers = new ArrayDeque<AnnotationOrModifier>((Collection<AnnotationOrModifier>)splitModifiers.declarationModifiers());
        this.builder.open(ZERO);
        boolean afterFirstToken = false;
        boolean lastWasAnnotation = false;
        while (!declarationModifiers.isEmpty() && !((AnnotationOrModifier)declarationModifiers.peekFirst()).isModifier()) {
            if (afterFirstToken) {
                this.builder.addAll((List<Op>)(annotationsDirection.isVertical() ? JavaInputAstVisitor.forceBreakList(declarationAnnotationBreak) : JavaInputAstVisitor.breakList(declarationAnnotationBreak)));
            }
            this.formatAnnotationOrModifier(declarationModifiers);
            afterFirstToken = true;
            lastWasAnnotation = true;
        }
        this.builder.close();
        ImmutableList<Op> immutableList = trailingBreak = annotationsDirection.isVertical() ? JavaInputAstVisitor.forceBreakList(declarationAnnotationBreak) : JavaInputAstVisitor.breakList(declarationAnnotationBreak);
        if (declarationModifiers.isEmpty()) {
            this.builder.addAll((List<Op>)trailingBreak);
            return splitModifiers.typeAnnotations();
        }
        if (lastWasAnnotation) {
            this.builder.addAll((List<Op>)trailingBreak);
        }
        this.builder.open(ZERO);
        afterFirstToken = false;
        while (!declarationModifiers.isEmpty()) {
            if (afterFirstToken) {
                this.builder.addAll((List<Op>)JavaInputAstVisitor.breakFillList(Optional.empty()));
            }
            this.formatAnnotationOrModifier(declarationModifiers);
            afterFirstToken = true;
        }
        this.builder.close();
        this.builder.addAll((List<Op>)JavaInputAstVisitor.breakFillList(Optional.empty()));
        return splitModifiers.typeAnnotations();
    }

    DeclarationModifiersAndTypeAnnotations splitModifiers(ModifiersTree modifiersTree, List<? extends AnnotationTree> annotations) {
        AnnotationOrModifier modifier;
        int idx;
        if (annotations.isEmpty() && !JavaInputAstVisitor.isModifier(this.builder.peekToken().get())) {
            return DeclarationModifiersAndTypeAnnotations.empty();
        }
        TreeRangeSet annotationRanges = TreeRangeSet.create();
        for (AnnotationTree annotationTree : annotations) {
            annotationRanges.add(Range.closedOpen((Comparable)Integer.valueOf(Trees.getStartPosition(annotationTree)), (Comparable)Integer.valueOf(Trees.getEndPosition(annotationTree, this.getCurrentPath()))));
        }
        ImmutableList<Input.Tok> toks = this.builder.peekTokens(Trees.getStartPosition(modifiersTree), (Predicate<Input.Tok>)((Predicate)arg_0 -> JavaInputAstVisitor.lambda$splitModifiers$5((RangeSet)annotationRanges, arg_0)));
        ImmutableList immutableList = ImmutableList.copyOf((Collection)Streams.concat((Stream[])new Stream[]{toks.stream().filter(arg_0 -> JavaInputAstVisitor.lambda$splitModifiers$6((RangeSet)annotationRanges, arg_0)).map(AnnotationOrModifier::ofModifier), annotations.stream().map(AnnotationOrModifier::ofAnnotation)}).sorted().collect(Collectors.toList()));
        ImmutableList.Builder typeAnnotations = ImmutableList.builder();
        for (idx = immutableList.size() - 1; idx >= 0 && (modifier = (AnnotationOrModifier)immutableList.get(idx)).isAnnotation() && this.isTypeAnnotation(modifier.annotation()); --idx) {
            typeAnnotations.add((Object)modifier.annotation());
        }
        return DeclarationModifiersAndTypeAnnotations.create((ImmutableList<AnnotationOrModifier>)immutableList.subList(0, idx + 1), (ImmutableList<AnnotationTree>)typeAnnotations.build().reverse());
    }

    private void formatAnnotationOrModifier(Deque<AnnotationOrModifier> modifiers) {
        AnnotationOrModifier modifier = modifiers.removeFirst();
        switch (modifier.getKind().ordinal()) {
            case 0: {
                this.token(modifier.modifier().getText());
                if (!modifier.modifier().getText().equals("non")) break;
                this.token(modifiers.removeFirst().modifier().getText());
                this.token(modifiers.removeFirst().modifier().getText());
                break;
            }
            case 1: {
                this.scan((Tree)modifier.annotation(), null);
            }
        }
    }

    boolean isTypeAnnotation(AnnotationTree annotationTree) {
        Tree annotationType = annotationTree.getAnnotationType();
        if (!(annotationType instanceof IdentifierTree)) {
            return false;
        }
        return this.typeAnnotationSimpleNames.contains(((IdentifierTree)annotationType).getName());
    }

    private static boolean isModifier(String token) {
        switch (token) {
            case "public": 
            case "protected": 
            case "private": 
            case "abstract": 
            case "static": 
            case "final": 
            case "transient": 
            case "volatile": 
            case "synchronized": 
            case "native": 
            case "strictfp": 
            case "default": 
            case "sealed": 
            case "non": 
            case "-": {
                return true;
            }
        }
        return false;
    }

    @Override
    public Void visitCatch(CatchTree node, Void unused) {
        throw new IllegalStateException("expected manual descent into catch trees");
    }

    private void visitCatchClause(CatchTree node, AllowTrailingBlankLine allowTrailingBlankLine) {
        this.sync(node);
        this.builder.space();
        this.token("catch");
        this.builder.space();
        this.token("(");
        this.builder.open(this.plusFour);
        VariableTree ex = node.getParameter();
        if (ex.getType().getKind() == Tree.Kind.UNION_TYPE) {
            this.builder.open(ZERO);
            this.visitUnionType(ex);
            this.builder.close();
        } else {
            this.builder.breakToFill();
            this.builder.open(ZERO);
            this.scan((Tree)ex, null);
            this.builder.close();
        }
        this.builder.close();
        this.token(")");
        this.builder.space();
        this.visitBlock(node.getBlock(), CollapseEmptyOrNot.NO, AllowLeadingBlankLine.YES, allowTrailingBlankLine);
    }

    private void visitUnionType(VariableTree declaration) {
        UnionTypeTree type = (UnionTypeTree)declaration.getType();
        this.builder.open(ZERO);
        this.sync(declaration);
        this.visitAndBreakModifiers(declaration.getModifiers(), Direction.HORIZONTAL, Optional.empty());
        List<? extends Tree> union = type.getTypeAlternatives();
        boolean afterFirstToken = false;
        for (int i = 0; i < union.size() - 1; ++i) {
            if (afterFirstToken) {
                this.builder.breakOp(" ");
                this.token("|");
                this.builder.space();
            } else {
                afterFirstToken = true;
            }
            this.scan(union.get(i), null);
        }
        this.builder.breakOp(" ");
        this.token("|");
        this.builder.space();
        Tree last = union.get(union.size() - 1);
        this.declareOne(DeclarationKind.NONE, Direction.HORIZONTAL, Optional.empty(), last, declaration.getName(), "", "=", Optional.ofNullable(declaration.getInitializer()), Optional.empty(), Optional.empty(), Optional.empty());
        this.builder.close();
    }

    private static void walkInfix(int precedence, ExpressionTree expression, List<ExpressionTree> operands, List<String> operators) {
        if (expression instanceof BinaryTree) {
            BinaryTree binaryTree = (BinaryTree)expression;
            if (Trees.precedence(binaryTree) == precedence) {
                JavaInputAstVisitor.walkInfix(precedence, binaryTree.getLeftOperand(), operands, operators);
                operators.add(Trees.operatorName(expression));
                JavaInputAstVisitor.walkInfix(precedence, binaryTree.getRightOperand(), operands, operators);
            } else {
                operands.add(expression);
            }
        } else {
            operands.add(expression);
        }
    }

    protected void visitFormals(Optional<VariableTree> receiver, List<? extends VariableTree> parameters) {
        if (!receiver.isPresent() && parameters.isEmpty()) {
            return;
        }
        this.builder.open(ZERO);
        boolean afterFirstToken = false;
        if (receiver.isPresent()) {
            this.declareOne(DeclarationKind.PARAMETER, Direction.HORIZONTAL, Optional.of(receiver.get().getModifiers()), receiver.get().getType(), receiver.get().getName(), "", "", Optional.empty(), !parameters.isEmpty() ? Optional.of(",") : Optional.empty(), Optional.of(receiver.get().getNameExpression()), Optional.empty());
            afterFirstToken = true;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            VariableTree parameter = parameters.get(i);
            if (afterFirstToken) {
                this.builder.breakOp(" ");
            }
            this.visitToDeclare(DeclarationKind.PARAMETER, Direction.HORIZONTAL, parameter, Optional.empty(), "=", i < parameters.size() - 1 ? Optional.of(",") : Optional.empty());
            afterFirstToken = true;
        }
        this.builder.close();
    }

    private void visitThrowsClause(List<? extends ExpressionTree> thrownExceptionTypes) {
        this.token("throws");
        this.builder.breakToFill(" ");
        boolean afterFirstToken = false;
        for (ExpressionTree expressionTree : thrownExceptionTypes) {
            if (afterFirstToken) {
                this.token(",");
                this.builder.breakOp(" ");
            }
            this.scan((Tree)expressionTree, null);
            afterFirstToken = true;
        }
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void unused) {
        this.sync(node);
        this.token(node.getName().toString());
        return null;
    }

    @Override
    public Void visitModule(ModuleTree node, Void unused) {
        for (AnnotationTree annotationTree : node.getAnnotations()) {
            this.scan((Tree)annotationTree, null);
            this.builder.forcedBreak();
        }
        if (node.getModuleType() == ModuleTree.ModuleKind.OPEN) {
            this.token("open");
            this.builder.space();
        }
        this.token("module");
        this.builder.space();
        this.scan((Tree)node.getName(), null);
        this.builder.space();
        if (node.getDirectives().isEmpty()) {
            this.tokenBreakTrailingComment("{", this.plusTwo);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.token("}", this.plusTwo);
        } else {
            this.builder.open(this.plusTwo);
            this.token("{");
            this.builder.forcedBreak();
            Optional<Tree.Kind> previousDirective = Optional.empty();
            for (DirectiveTree directiveTree : node.getDirectives()) {
                this.markForPartialFormat();
                this.builder.blankLineWanted(previousDirective.map(k -> !k.equals((Object)directiveTree.getKind())).orElse(false) != false ? OpsBuilder.BlankLineWanted.YES : OpsBuilder.BlankLineWanted.NO);
                this.builder.forcedBreak();
                this.scan((Tree)directiveTree, null);
                previousDirective = Optional.of(directiveTree.getKind());
            }
            this.builder.close();
            this.builder.forcedBreak();
            this.token("}");
        }
        return null;
    }

    private void visitDirective(String name, String separator, ExpressionTree nameExpression, @Nullable List<? extends ExpressionTree> items) {
        this.token(name);
        this.builder.space();
        this.scan((Tree)nameExpression, null);
        if (items != null) {
            this.builder.open(this.plusFour);
            this.builder.space();
            this.token(separator);
            this.builder.forcedBreak();
            boolean afterFirstToken = false;
            for (ExpressionTree expressionTree : items) {
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.forcedBreak();
                }
                this.scan((Tree)expressionTree, null);
                afterFirstToken = true;
            }
            this.token(";");
            this.builder.close();
        } else {
            this.token(";");
        }
    }

    @Override
    public Void visitExports(ExportsTree node, Void unused) {
        this.visitDirective("exports", "to", node.getPackageName(), node.getModuleNames());
        return null;
    }

    @Override
    public Void visitOpens(OpensTree node, Void unused) {
        this.visitDirective("opens", "to", node.getPackageName(), node.getModuleNames());
        return null;
    }

    @Override
    public Void visitProvides(ProvidesTree node, Void unused) {
        this.visitDirective("provides", "with", node.getServiceName(), node.getImplementationNames());
        return null;
    }

    @Override
    public Void visitRequires(RequiresTree node, Void unused) {
        this.token("requires");
        this.builder.space();
        while (true) {
            if (this.builder.peekToken().equals(Optional.of("static"))) {
                this.token("static");
                this.builder.space();
                continue;
            }
            if (!this.builder.peekToken().equals(Optional.of("transitive"))) break;
            this.token("transitive");
            this.builder.space();
        }
        this.scan((Tree)node.getModuleName(), null);
        this.token(";");
        return null;
    }

    @Override
    public Void visitUses(UsesTree node, Void unused) {
        this.token("uses");
        this.builder.space();
        this.scan((Tree)node.getServiceName(), null);
        this.token(";");
        return null;
    }

    private void visitName(Tree node) {
        ArrayDeque<Name> stack = new ArrayDeque<Name>();
        while (node instanceof MemberSelectTree) {
            stack.addFirst(((MemberSelectTree)node).getIdentifier());
            node = ((MemberSelectTree)node).getExpression();
        }
        stack.addFirst(((IdentifierTree)node).getName());
        boolean afterFirstToken = false;
        for (Name name : stack) {
            if (afterFirstToken) {
                this.token(".");
            }
            this.token(name.toString());
            afterFirstToken = true;
        }
    }

    private void visitToDeclare(DeclarationKind kind, Direction annotationsDirection, VariableTree node, Optional<ExpressionTree> initializer, String equals, Optional<String> trailing) {
        Tree type;
        Optional<DimensionHelpers.TypeWithDims> typeWithDims;
        this.sync(node);
        if (node.getType() != null) {
            DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(node.getType(), DimensionHelpers.SortedDims.YES);
            typeWithDims = Optional.of(extractedDims);
            type = extractedDims.node;
        } else {
            typeWithDims = Optional.empty();
            type = null;
        }
        this.declareOne(kind, annotationsDirection, Optional.of(node.getModifiers()), type, node.getName(), "", equals, initializer, trailing, Optional.empty(), typeWithDims);
    }

    protected void typeParametersRest(List<? extends TypeParameterTree> typeParameters, Indent plusIndent) {
        this.builder.open(plusIndent);
        this.builder.breakOp();
        this.builder.open(ZERO);
        boolean afterFirstToken = false;
        for (TypeParameterTree typeParameterTree : typeParameters) {
            if (afterFirstToken) {
                this.token(",");
                this.builder.breakOp(" ");
            }
            this.scan((Tree)typeParameterTree, null);
            afterFirstToken = true;
        }
        this.token(">");
        this.builder.close();
        this.builder.close();
    }

    void visitDot(ExpressionTree node0) {
        ExpressionTree node = node0;
        ArrayDeque<ExpressionTree> stack = new ArrayDeque<ExpressionTree>();
        block12: do {
            stack.addFirst(node);
            if (node.getKind() == Tree.Kind.ARRAY_ACCESS) {
                node = JavaInputAstVisitor.getArrayBase(node);
            }
            switch (node.getKind()) {
                case MEMBER_SELECT: {
                    node = ((MemberSelectTree)node).getExpression();
                    break;
                }
                case METHOD_INVOCATION: {
                    node = JavaInputAstVisitor.getMethodReceiver((MethodInvocationTree)node);
                    break;
                }
                case IDENTIFIER: {
                    node = null;
                    break block12;
                }
                default: {
                    node = (ExpressionTree)stack.removeFirst();
                    break block12;
                }
            }
        } while (node != null);
        ArrayList<ExpressionTree> items = new ArrayList<ExpressionTree>(stack);
        boolean needDot = false;
        if (node != null) {
            if (node.getKind() == Tree.Kind.NEW_CLASS && ((NewClassTree)node).getClassBody() != null) {
                this.builder.open(ZERO);
                this.scan((Tree)JavaInputAstVisitor.getArrayBase(node), null);
                this.token(".");
            } else {
                this.builder.open(this.plusFour);
                this.scan((Tree)JavaInputAstVisitor.getArrayBase(node), null);
                this.builder.breakOp();
                needDot = true;
            }
            this.formatArrayIndices(JavaInputAstVisitor.getArrayIndices(node));
            if (stack.isEmpty()) {
                this.builder.close();
                return;
            }
        }
        LinkedHashSet<Integer> prefixes = new LinkedHashSet<Integer>();
        TypeNameClassifier.typePrefixLength(JavaInputAstVisitor.simpleNames(stack)).ifPresent(prefixes::add);
        int invocationCount = 0;
        int firstInvocationIndex = -1;
        for (int i = 0; i < items.size(); ++i) {
            ExpressionTree expression = (ExpressionTree)items.get(i);
            if (expression.getKind() != Tree.Kind.METHOD_INVOCATION) continue;
            if (i > 0 || node != null) {
                ++invocationCount;
            }
            if (firstInvocationIndex >= 0) continue;
            firstInvocationIndex = i;
        }
        if (invocationCount == 1 && firstInvocationIndex > 0) {
            prefixes.add(firstInvocationIndex);
        }
        if (prefixes.isEmpty() && items.get(0) instanceof IdentifierTree) {
            switch (((IdentifierTree)items.get(0)).getName().toString()) {
                case "this": 
                case "super": {
                    prefixes.add(1);
                    break;
                }
            }
        }
        List<Long> streamPrefixes = JavaInputAstVisitor.handleStream(items);
        streamPrefixes.forEach(x -> prefixes.add(x.intValue()));
        if (!prefixes.isEmpty()) {
            this.visitDotWithPrefix(items, needDot, prefixes, streamPrefixes.isEmpty() ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED);
        } else {
            this.visitRegularDot(items, needDot);
        }
        if (node != null) {
            this.builder.close();
        }
    }

    private void visitRegularDot(List<ExpressionTree> items, boolean needDot) {
        boolean trailingDereferences = items.size() > 1;
        boolean needDot0 = needDot;
        if (!needDot0) {
            this.builder.open(this.plusFour);
        }
        int minLength = this.indentMultiplier * 4;
        int length = needDot0 ? minLength : 0;
        for (ExpressionTree e : items) {
            if (needDot) {
                if (length > minLength) {
                    this.builder.breakOp(Doc.FillMode.UNIFIED, "", ZERO);
                }
                this.token(".");
                ++length;
            }
            if (!this.fillFirstArgument(e, items, trailingDereferences ? ZERO : this.minusFour)) {
                Output.BreakTag tyargTag = this.genSym();
                this.dotExpressionUpToArgs(e, Optional.of(tyargTag));
                Indent.If tyargIndent = Indent.If.make(tyargTag, this.plusFour, ZERO);
                this.dotExpressionArgsAndParen(e, tyargIndent, trailingDereferences || needDot ? this.plusFour : ZERO);
            }
            length += Trees.getLength(e, this.getCurrentPath());
            needDot = true;
        }
        if (!needDot0) {
            this.builder.close();
        }
    }

    private boolean fillFirstArgument(ExpressionTree e, List<ExpressionTree> items, Indent indent) {
        if (items.size() < 2) {
            return false;
        }
        if (e.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return false;
        }
        MethodInvocationTree methodInvocation = (MethodInvocationTree)e;
        Name name = Trees.getMethodName(methodInvocation);
        if (!(methodInvocation.getMethodSelect() instanceof IdentifierTree) || name.length() > 4 || !methodInvocation.getTypeArguments().isEmpty() || methodInvocation.getArguments().size() != 1) {
            return false;
        }
        this.builder.open(ZERO);
        this.builder.open(indent);
        this.visit(name);
        this.token("(");
        ExpressionTree arg = (ExpressionTree)Iterables.getOnlyElement(methodInvocation.getArguments());
        this.scan((Tree)arg, null);
        this.builder.close();
        this.token(")");
        this.builder.close();
        return true;
    }

    private void visitDotWithPrefix(List<ExpressionTree> items, boolean needDot, Collection<Integer> prefixes, Doc.FillMode prefixFillMode) {
        boolean trailingDereferences = !prefixes.isEmpty() && (Integer)Iterables.getLast(prefixes) < items.size() - 1;
        this.builder.open(this.plusFour);
        for (int times = 0; times < prefixes.size(); ++times) {
            this.builder.open(ZERO);
        }
        ArrayDeque unconsumedPrefixes = new ArrayDeque(ImmutableSortedSet.copyOf(prefixes));
        Output.BreakTag nameTag = this.genSym();
        for (int i = 0; i < items.size(); ++i) {
            ExpressionTree e = items.get(i);
            if (needDot) {
                Doc.FillMode fillMode = !unconsumedPrefixes.isEmpty() && i <= (Integer)unconsumedPrefixes.peekFirst() ? prefixFillMode : Doc.FillMode.UNIFIED;
                this.builder.breakOp(fillMode, "", ZERO, Optional.of(nameTag));
                this.token(".");
            }
            Output.BreakTag tyargTag = this.genSym();
            this.dotExpressionUpToArgs(e, Optional.of(tyargTag));
            if (!unconsumedPrefixes.isEmpty() && i == (Integer)unconsumedPrefixes.peekFirst()) {
                this.builder.close();
                unconsumedPrefixes.removeFirst();
            }
            Indent.If tyargIndent = Indent.If.make(tyargTag, this.plusFour, ZERO);
            Indent.If argsIndent = Indent.If.make(nameTag, this.plusFour, trailingDereferences ? this.plusFour : ZERO);
            this.dotExpressionArgsAndParen(e, tyargIndent, argsIndent);
            needDot = true;
        }
        this.builder.close();
    }

    private static ImmutableList<String> simpleNames(Deque<ExpressionTree> stack) {
        ImmutableList.Builder simpleNames = ImmutableList.builder();
        block5: for (ExpressionTree expression : stack) {
            boolean isArray = expression.getKind() == Tree.Kind.ARRAY_ACCESS;
            expression = JavaInputAstVisitor.getArrayBase(expression);
            switch (expression.getKind()) {
                case MEMBER_SELECT: {
                    simpleNames.add((Object)((MemberSelectTree)expression).getIdentifier().toString());
                    break;
                }
                case IDENTIFIER: {
                    simpleNames.add((Object)((IdentifierTree)expression).getName().toString());
                    break;
                }
                case METHOD_INVOCATION: {
                    simpleNames.add((Object)Trees.getMethodName((MethodInvocationTree)expression).toString());
                    break block5;
                }
                default: {
                    break block5;
                }
            }
            if (!isArray) continue;
            break;
        }
        return simpleNames.build();
    }

    private void dotExpressionUpToArgs(ExpressionTree expression, Optional<Output.BreakTag> tyargTag) {
        expression = JavaInputAstVisitor.getArrayBase(expression);
        switch (expression.getKind()) {
            case MEMBER_SELECT: {
                MemberSelectTree fieldAccess = (MemberSelectTree)expression;
                this.visit(fieldAccess.getIdentifier());
                break;
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)expression;
                if (!methodInvocation.getTypeArguments().isEmpty()) {
                    this.builder.open(this.plusFour);
                    this.addTypeArguments(methodInvocation.getTypeArguments(), ZERO);
                    this.builder.breakOp(Doc.FillMode.UNIFIED, "", ZERO, tyargTag);
                    this.builder.close();
                }
                this.visit(Trees.getMethodName(methodInvocation));
                break;
            }
            case IDENTIFIER: {
                this.visit(((IdentifierTree)expression).getName());
                break;
            }
            default: {
                this.scan((Tree)expression, null);
            }
        }
    }

    private static ExpressionTree getArrayBase(ExpressionTree node) {
        while (node instanceof ArrayAccessTree) {
            node = ((ArrayAccessTree)node).getExpression();
        }
        return node;
    }

    private static ExpressionTree getMethodReceiver(MethodInvocationTree methodInvocation) {
        ExpressionTree select = methodInvocation.getMethodSelect();
        return select instanceof MemberSelectTree ? ((MemberSelectTree)select).getExpression() : null;
    }

    private void dotExpressionArgsAndParen(ExpressionTree expression, Indent tyargIndent, Indent indent) {
        Deque<ExpressionTree> indices = JavaInputAstVisitor.getArrayIndices(expression);
        expression = JavaInputAstVisitor.getArrayBase(expression);
        switch (expression.getKind()) {
            case METHOD_INVOCATION: {
                this.builder.open(tyargIndent);
                MethodInvocationTree methodInvocation = (MethodInvocationTree)expression;
                this.addArguments(methodInvocation.getArguments(), indent);
                this.builder.close();
                break;
            }
        }
        this.formatArrayIndices(indices);
    }

    private void formatArrayIndices(Deque<ExpressionTree> indices) {
        if (indices.isEmpty()) {
            return;
        }
        this.builder.open(ZERO);
        do {
            this.token("[");
            this.builder.breakToFill();
            this.scan((Tree)indices.removeLast(), null);
            this.token("]");
        } while (!indices.isEmpty());
        this.builder.close();
    }

    private static Deque<ExpressionTree> getArrayIndices(ExpressionTree expression) {
        ArrayDeque<ExpressionTree> indices = new ArrayDeque<ExpressionTree>();
        while (expression instanceof ArrayAccessTree) {
            ArrayAccessTree array = (ArrayAccessTree)expression;
            indices.addLast(array.getIndex());
            expression = array.getExpression();
        }
        return indices;
    }

    void addTypeArguments(List<? extends Tree> typeArguments, Indent plusIndent) {
        if (typeArguments == null || typeArguments.isEmpty()) {
            return;
        }
        this.token("<");
        this.builder.open(plusIndent);
        boolean afterFirstToken = false;
        for (Tree tree : typeArguments) {
            if (afterFirstToken) {
                this.token(",");
                this.builder.breakToFill(" ");
            }
            this.scan(tree, null);
            afterFirstToken = true;
        }
        this.builder.close();
        this.token(">");
    }

    void addArguments(List<? extends ExpressionTree> arguments, Indent plusIndent) {
        this.builder.open(plusIndent);
        this.token("(");
        if (!arguments.isEmpty()) {
            if (arguments.size() % 2 == 0 && this.argumentsAreTabular(arguments) == 2) {
                this.builder.forcedBreak();
                this.builder.open(ZERO);
                boolean afterFirstToken = false;
                for (int i = 0; i < arguments.size() - 1; i += 2) {
                    ExpressionTree argument0 = arguments.get(i);
                    ExpressionTree argument1 = arguments.get(i + 1);
                    if (afterFirstToken) {
                        this.token(",");
                        this.builder.forcedBreak();
                    }
                    this.builder.open(this.plusFour);
                    this.scan((Tree)argument0, null);
                    this.token(",");
                    this.builder.breakOp(" ");
                    this.scan((Tree)argument1, null);
                    this.builder.close();
                    afterFirstToken = true;
                }
                this.builder.close();
            } else if (this.isFormatMethod(arguments)) {
                this.builder.breakOp();
                this.builder.open(ZERO);
                this.scan((Tree)arguments.get(0), null);
                this.token(",");
                this.builder.breakOp(" ");
                this.builder.open(ZERO);
                this.argList(arguments.subList(1, arguments.size()));
                this.builder.close();
                this.builder.close();
            } else {
                this.builder.breakOp();
                this.argList(arguments);
            }
        }
        this.token(")");
        this.builder.close();
    }

    private void argList(List<? extends ExpressionTree> arguments) {
        this.builder.open(ZERO);
        boolean afterFirstToken = false;
        Doc.FillMode fillMode = this.hasOnlyShortItems(arguments) ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
        for (ExpressionTree expressionTree : arguments) {
            if (afterFirstToken) {
                this.token(",");
                this.builder.breakOp(fillMode, " ", ZERO);
            }
            this.scan((Tree)expressionTree, null);
            afterFirstToken = true;
        }
        this.builder.close();
    }

    private boolean isFormatMethod(List<? extends ExpressionTree> arguments) {
        if (arguments.size() < 2) {
            return false;
        }
        return this.isStringConcat(arguments.get(0));
    }

    private boolean isStringConcat(ExpressionTree first) {
        final boolean[] stringLiteral = new boolean[]{true};
        final boolean[] formatString = new boolean[]{false};
        new TreeScanner(){

            @Override
            public void scan(JCTree tree) {
                Object value;
                if (tree == null) {
                    return;
                }
                switch (tree.getKind()) {
                    case STRING_LITERAL: {
                        break;
                    }
                    case PLUS: {
                        super.scan(tree);
                        break;
                    }
                    default: {
                        stringLiteral[0] = false;
                    }
                }
                if (tree.getKind() == Tree.Kind.STRING_LITERAL && (value = ((LiteralTree)((Object)tree)).getValue()) instanceof String && FORMAT_SPECIFIER.matcher(value.toString()).find()) {
                    formatString[0] = true;
                }
            }
        }.scan((JCTree)((Object)first));
        return stringLiteral[0] && formatString[0];
    }

    private int argumentsAreTabular(List<? extends ExpressionTree> arguments) {
        int i;
        if (arguments.isEmpty()) {
            return -1;
        }
        ArrayList<List<ExpressionTree>> rows = new ArrayList<List<ExpressionTree>>();
        PeekingIterator it = Iterators.peekingIterator(arguments.iterator());
        int start0 = this.actualColumn((ExpressionTree)it.peek());
        ArrayList<ExpressionTree> row = new ArrayList<ExpressionTree>();
        row.add((ExpressionTree)it.next());
        while (it.hasNext() && this.actualColumn((ExpressionTree)it.peek()) > start0) {
            row.add((ExpressionTree)it.next());
        }
        if (!it.hasNext()) {
            return -1;
        }
        if (JavaInputAstVisitor.rowLength(row) <= 1) {
            return -1;
        }
        rows.add(row);
        while (it.hasNext()) {
            row = new ArrayList();
            int start = this.actualColumn((ExpressionTree)it.peek());
            if (start != start0) {
                return -1;
            }
            row.add((ExpressionTree)it.next());
            while (it.hasNext() && this.actualColumn((ExpressionTree)it.peek()) > start0) {
                row.add((ExpressionTree)it.next());
            }
            rows.add(row);
        }
        int size0 = ((List)rows.get(0)).size();
        if (!JavaInputAstVisitor.expressionsAreParallel(rows, 0, rows.size())) {
            return -1;
        }
        for (i = 1; i < size0; ++i) {
            if (JavaInputAstVisitor.expressionsAreParallel(rows, i, rows.size() / 2 + 1)) continue;
            return -1;
        }
        if (rows.size() == 2) {
            if (size0 == ((List)rows.get(1)).size()) {
                return size0;
            }
            return -1;
        }
        for (i = 1; i < rows.size() - 1; ++i) {
            if (size0 == ((List)rows.get(i)).size()) continue;
            return -1;
        }
        if (size0 < ((List)Iterables.getLast(rows)).size()) {
            return -1;
        }
        return size0;
    }

    static int rowLength(List<? extends ExpressionTree> row) {
        int size = 0;
        for (ExpressionTree expressionTree : row) {
            if (expressionTree.getKind() != Tree.Kind.NEW_ARRAY) {
                ++size;
                continue;
            }
            NewArrayTree array = (NewArrayTree)expressionTree;
            if (array.getInitializers() == null) {
                ++size;
                continue;
            }
            size += JavaInputAstVisitor.rowLength(array.getInitializers());
        }
        return size;
    }

    private Integer actualColumn(ExpressionTree expression) {
        ImmutableMap<Integer, Integer> positionToColumnMap = this.builder.getInput().getPositionToColumnMap();
        return (Integer)positionToColumnMap.get(this.builder.actualStartColumn(Trees.getStartPosition(expression)));
    }

    private static boolean expressionsAreParallel(List<List<ExpressionTree>> rows, int column, int atLeastM) {
        HashMultiset nodeTypes = HashMultiset.create();
        for (List<ExpressionTree> row : rows) {
            if (column >= row.size()) continue;
            if (row.get(column) instanceof UnaryTree) {
                nodeTypes.add((Object)((UnaryTree)row.get(column)).getExpression().getKind());
                continue;
            }
            nodeTypes.add((Object)row.get(column).getKind());
        }
        for (Multiset.Entry nodeType : nodeTypes.entrySet()) {
            if (nodeType.getCount() < atLeastM) continue;
            return true;
        }
        return false;
    }

    protected int declareOne(DeclarationKind kind, Direction annotationsDirection, Optional<ModifiersTree> modifiers, Tree type, Name name, String op, String equals, Optional<ExpressionTree> initializer, Optional<String> trailing, Optional<ExpressionTree> receiverExpression, Optional<DimensionHelpers.TypeWithDims> typeWithDims) {
        boolean isField;
        Output.BreakTag typeBreak = this.genSym();
        Output.BreakTag verticalAnnotationBreak = this.genSym();
        boolean bl = isField = kind == DeclarationKind.FIELD;
        if (isField) {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.conditional(verticalAnnotationBreak));
        }
        ArrayDeque<List<? extends AnnotationTree>> dims = new ArrayDeque<List<? extends AnnotationTree>>((Collection<List<? extends AnnotationTree>>)(typeWithDims.isPresent() ? typeWithDims.get().dims : ImmutableList.of()));
        int baseDims = 0;
        DeclarationModifiersAndTypeAnnotations declarationAndTypeModifiers = modifiers.map(m -> this.splitModifiers((ModifiersTree)m, m.getAnnotations())).orElse(DeclarationModifiersAndTypeAnnotations.empty());
        this.builder.open(kind == DeclarationKind.PARAMETER && declarationAndTypeModifiers.hasDeclarationAnnotation() ? this.plusFour : ZERO);
        ImmutableList<AnnotationTree> annotations = this.visitModifiers(declarationAndTypeModifiers, annotationsDirection, Optional.of(verticalAnnotationBreak));
        boolean isVar = this.builder.peekToken().get().equals("var") && (!name.contentEquals("var") || this.builder.peekToken(1).get().equals("var"));
        boolean hasType = type != null || isVar;
        this.builder.open(hasType ? this.plusFour : ZERO);
        this.builder.open(ZERO);
        this.builder.open(ZERO);
        this.visitAnnotations((List<? extends AnnotationTree>)annotations, BreakOrNot.NO, BreakOrNot.YES);
        if (typeWithDims.isPresent() && typeWithDims.get().node != null) {
            this.scan(typeWithDims.get().node, null);
            int totalDims = dims.size();
            this.builder.open(this.plusFour);
            this.maybeAddDims(dims);
            this.builder.close();
            baseDims = totalDims - dims.size();
        } else if (isVar) {
            this.token("var");
        } else {
            this.scan(type, null);
        }
        this.builder.close();
        if (hasType) {
            this.builder.breakOp(Doc.FillMode.INDEPENDENT, " ", ZERO, Optional.of(typeBreak));
        }
        this.builder.open(Indent.If.make(typeBreak, this.plusFour, ZERO));
        if (receiverExpression.isPresent()) {
            this.scan((Tree)receiverExpression.get(), null);
        } else {
            this.variableName(name);
        }
        this.builder.op(op);
        this.maybeAddDims(dims);
        this.builder.close();
        this.builder.close();
        if (initializer.isPresent()) {
            this.builder.space();
            this.token(equals);
            if (initializer.get().getKind() == Tree.Kind.NEW_ARRAY && ((NewArrayTree)initializer.get()).getType() == null) {
                this.builder.open(this.minusFour);
                this.builder.space();
                initializer.get().accept(this, null);
                this.builder.close();
            } else {
                this.builder.open(Indent.If.make(typeBreak, this.plusFour, ZERO));
                this.builder.breakToFill(" ");
                this.scan((Tree)initializer.get(), null);
                this.builder.close();
            }
        }
        if (trailing.isPresent() && this.builder.peekToken().equals(trailing)) {
            this.builder.guessToken(trailing.get());
        }
        this.builder.close();
        this.builder.close();
        if (isField) {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.conditional(verticalAnnotationBreak));
        }
        return baseDims;
    }

    protected void variableName(Name name) {
        this.visit(name);
    }

    private void maybeAddDims(Deque<List<? extends AnnotationTree>> annotations) {
        this.maybeAddDims(new ArrayDeque<ExpressionTree>(), annotations);
    }

    private void maybeAddDims(Deque<ExpressionTree> dimExpressions, Deque<List<? extends AnnotationTree>> annotations) {
        boolean lastWasAnnotation = false;
        block10: while (this.builder.peekToken().isPresent()) {
            switch (this.builder.peekToken().get()) {
                case "@": {
                    if (annotations.isEmpty()) {
                        return;
                    }
                    List<? extends AnnotationTree> dimAnnotations = annotations.removeFirst();
                    if (dimAnnotations.isEmpty()) continue block10;
                    this.builder.breakToFill(" ");
                    this.visitAnnotations(dimAnnotations, BreakOrNot.NO, BreakOrNot.NO);
                    lastWasAnnotation = true;
                    continue block10;
                }
                case "[": {
                    if (lastWasAnnotation) {
                        this.builder.breakToFill(" ");
                    } else {
                        this.builder.breakToFill();
                    }
                    this.token("[");
                    if (!this.builder.peekToken().get().equals("]")) {
                        this.scan((Tree)dimExpressions.removeFirst(), null);
                    }
                    this.token("]");
                    lastWasAnnotation = false;
                    continue block10;
                }
                case ".": {
                    if (!this.builder.peekToken().get().equals(".") || !this.builder.peekToken(1).get().equals(".")) {
                        return;
                    }
                    if (lastWasAnnotation) {
                        this.builder.breakToFill(" ");
                    } else {
                        this.builder.breakToFill();
                    }
                    this.builder.op("...");
                    lastWasAnnotation = false;
                    continue block10;
                }
            }
            return;
        }
    }

    private void declareMany(List<VariableTree> fragments, Direction annotationDirection) {
        this.builder.open(ZERO);
        ModifiersTree modifiers = fragments.get(0).getModifiers();
        Tree type = fragments.get(0).getType();
        this.visitAndBreakModifiers(modifiers, annotationDirection, Optional.empty());
        this.builder.open(this.plusFour);
        this.builder.open(ZERO);
        DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(type, DimensionHelpers.SortedDims.YES);
        ArrayDeque<List<? extends AnnotationTree>> dims = new ArrayDeque<List<? extends AnnotationTree>>((Collection<List<? extends AnnotationTree>>)extractedDims.dims);
        this.scan(extractedDims.node, null);
        int baseDims = dims.size();
        this.maybeAddDims(dims);
        baseDims -= dims.size();
        boolean afterFirstToken = false;
        for (VariableTree fragment : fragments) {
            if (afterFirstToken) {
                this.token(",");
            }
            DimensionHelpers.TypeWithDims fragmentDims = JavaInputAstVisitor.variableFragmentDims(afterFirstToken, baseDims, fragment.getType());
            dims = new ArrayDeque<List<AnnotationTree>>((Collection<List<AnnotationTree>>)fragmentDims.dims);
            this.builder.breakOp(" ");
            this.builder.open(ZERO);
            this.maybeAddDims(dims);
            this.variableName(fragment.getName());
            this.maybeAddDims(dims);
            ExpressionTree initializer = fragment.getInitializer();
            if (initializer != null) {
                this.builder.space();
                this.token("=");
                this.builder.open(this.plusFour);
                this.builder.breakOp(" ");
                this.scan((Tree)initializer, null);
                this.builder.close();
            }
            this.builder.close();
            if (!afterFirstToken) {
                this.builder.close();
            }
            afterFirstToken = true;
        }
        this.builder.close();
        this.token(";");
        this.builder.close();
    }

    protected void addBodyDeclarations(List<? extends Tree> bodyDeclarations, BracesOrNot braces, FirstDeclarationsOrNot first0) {
        if (bodyDeclarations.isEmpty()) {
            if (braces.isYes()) {
                this.builder.space();
                this.tokenBreakTrailingComment("{", this.plusTwo);
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.builder.open(ZERO);
                if (this.builder.peekToken().equals(Optional.of(";"))) {
                    this.builder.open(this.plusTwo);
                    this.dropEmptyDeclarations();
                    this.builder.close();
                    this.builder.forcedBreak();
                }
                this.token("}", this.plusTwo);
                this.builder.close();
            }
        } else {
            if (braces.isYes()) {
                this.builder.space();
                this.tokenBreakTrailingComment("{", this.plusTwo);
                this.builder.open(ZERO);
            }
            this.builder.open(this.plusTwo);
            boolean first = first0.isYes();
            boolean lastOneGotBlankLineBefore = false;
            PeekingIterator it = Iterators.peekingIterator(bodyDeclarations.iterator());
            while (it.hasNext()) {
                boolean thisOneGetsBlankLineBefore;
                Tree bodyDeclaration = (Tree)it.next();
                this.dropEmptyDeclarations();
                this.builder.forcedBreak();
                boolean bl = thisOneGetsBlankLineBefore = bodyDeclaration.getKind() != Tree.Kind.VARIABLE || this.hasJavaDoc(bodyDeclaration);
                if (first) {
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                } else if (!first && (thisOneGetsBlankLineBefore || lastOneGotBlankLineBefore)) {
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
                }
                this.markForPartialFormat();
                if (bodyDeclaration.getKind() == Tree.Kind.VARIABLE) {
                    this.visitVariables(JavaInputAstVisitor.variableFragments((PeekingIterator<? extends Tree>)it, bodyDeclaration), DeclarationKind.FIELD, JavaInputAstVisitor.fieldAnnotationDirection(((VariableTree)bodyDeclaration).getModifiers()));
                } else {
                    this.scan(bodyDeclaration, null);
                }
                first = false;
                lastOneGotBlankLineBefore = thisOneGetsBlankLineBefore;
            }
            this.dropEmptyDeclarations();
            this.builder.forcedBreak();
            this.builder.close();
            this.builder.forcedBreak();
            this.markForPartialFormat();
            if (braces.isYes()) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.token("}", this.plusTwo);
                this.builder.close();
            }
        }
    }

    private void classDeclarationTypeList(String token, List<? extends Tree> types) {
        if (types.isEmpty()) {
            return;
        }
        this.builder.breakToFill(" ");
        this.builder.open(types.size() > 1 ? this.plusFour : ZERO);
        this.token(token);
        this.builder.space();
        boolean afterFirstToken = false;
        for (Tree tree : types) {
            if (afterFirstToken) {
                this.token(",");
                this.builder.breakOp(" ");
            }
            this.scan(tree, null);
            afterFirstToken = true;
        }
        this.builder.close();
    }

    private static List<VariableTree> variableFragments(PeekingIterator<? extends Tree> it, Tree first) {
        ArrayList<VariableTree> fragments = new ArrayList<VariableTree>();
        if (first.getKind() == Tree.Kind.VARIABLE) {
            int start = Trees.getStartPosition(first);
            fragments.add((VariableTree)first);
            while (it.hasNext() && ((Tree)it.peek()).getKind() == Tree.Kind.VARIABLE && Trees.getStartPosition((Tree)it.peek()) == start) {
                fragments.add((VariableTree)it.next());
            }
        }
        return fragments;
    }

    private boolean hasJavaDoc(Tree bodyDeclaration) {
        int position = ((JCTree)bodyDeclaration).getStartPosition();
        Input.Token token = (Input.Token)this.builder.getInput().getPositionTokenMap().get((Comparable)Integer.valueOf(position));
        if (token != null) {
            for (Input.Tok tok : token.getToksBefore()) {
                if (!tok.getText().startsWith("/**")) continue;
                return true;
            }
        }
        return false;
    }

    private static Optional<? extends Input.Token> getNextToken(Input input, int position) {
        return Optional.ofNullable((Input.Token)input.getPositionTokenMap().get((Comparable)Integer.valueOf(position)));
    }

    private boolean hasTrailingToken(Input input, List<? extends Tree> nodes, String token) {
        if (nodes.isEmpty()) {
            return false;
        }
        Tree lastNode = (Tree)Iterables.getLast(nodes);
        Optional<? extends Input.Token> nextToken = JavaInputAstVisitor.getNextToken(input, Trees.getEndPosition(lastNode, this.getCurrentPath()));
        return nextToken.isPresent() && nextToken.get().getTok().getText().equals(token);
    }

    private static Direction canLocalHaveHorizontalAnnotations(ModifiersTree modifiers) {
        int parameterlessAnnotations = 0;
        for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
            if (!annotationTree.getArguments().isEmpty()) continue;
            ++parameterlessAnnotations;
        }
        return parameterlessAnnotations <= 1 && parameterlessAnnotations == modifiers.getAnnotations().size() ? Direction.HORIZONTAL : Direction.VERTICAL;
    }

    private static Direction fieldAnnotationDirection(ModifiersTree modifiers) {
        for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
            if (annotationTree.getArguments().isEmpty()) continue;
            return Direction.VERTICAL;
        }
        return Direction.HORIZONTAL;
    }

    protected final void token(String token) {
        this.builder.token(token, Doc.Token.RealOrImaginary.REAL, ZERO, Optional.empty());
    }

    protected final void token(String token, Indent plusIndentCommentsBefore) {
        this.builder.token(token, Doc.Token.RealOrImaginary.REAL, plusIndentCommentsBefore, Optional.empty());
    }

    final void tokenBreakTrailingComment(String token, Indent breakAndIndentTrailingComment) {
        this.builder.token(token, Doc.Token.RealOrImaginary.REAL, ZERO, Optional.of(breakAndIndentTrailingComment));
    }

    protected void markForPartialFormat() {
        if (!this.inExpression()) {
            this.builder.markForPartialFormat();
        }
    }

    protected final void sync(Tree node) {
        this.builder.sync(((JCTree)node).getStartPosition());
    }

    final Output.BreakTag genSym() {
        return new Output.BreakTag();
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("builder", (Object)this.builder).toString();
    }

    @Override
    public Void visitBindingPattern(BindingPatternTree node, Void unused) {
        this.sync(node);
        VariableTree variableTree = node.getVariable();
        this.declareOne(DeclarationKind.PARAMETER, Direction.HORIZONTAL, Optional.of(variableTree.getModifiers()), variableTree.getType(), variableTree.getName(), "", "", Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        return null;
    }

    @Override
    public Void visitYield(YieldTree node, Void aVoid) {
        this.sync(node);
        this.token("yield");
        this.builder.space();
        this.scan((Tree)node.getValue(), null);
        this.token(";");
        return null;
    }

    @Override
    public Void visitSwitchExpression(SwitchExpressionTree node, Void aVoid) {
        this.sync(node);
        this.visitSwitch(node.getExpression(), node.getCases());
        return null;
    }

    private static /* synthetic */ boolean lambda$splitModifiers$6(RangeSet annotationRanges, Input.Tok t) {
        return !annotationRanges.contains((Comparable)Integer.valueOf(t.getPosition()));
    }

    private static /* synthetic */ boolean lambda$splitModifiers$5(RangeSet annotationRanges, Input.Tok tok) {
        return annotationRanges.contains((Comparable)Integer.valueOf(tok.getPosition())) || JavaInputAstVisitor.isModifier(tok.getText());
    }

    protected static enum BracesOrNot {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    protected static enum FirstDeclarationsOrNot {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    protected static enum CollapseEmptyOrNot {
        YES,
        NO;


        static CollapseEmptyOrNot valueOf(boolean b) {
            return b ? YES : NO;
        }

        boolean isYes() {
            return this == YES;
        }
    }

    protected static enum AllowLeadingBlankLine {
        YES,
        NO;


        static AllowLeadingBlankLine valueOf(boolean b) {
            return b ? YES : NO;
        }
    }

    protected static enum AllowTrailingBlankLine {
        YES,
        NO;


        static AllowTrailingBlankLine valueOf(boolean b) {
            return b ? YES : NO;
        }
    }

    protected static enum Direction {
        VERTICAL,
        HORIZONTAL;


        boolean isVertical() {
            return this == VERTICAL;
        }
    }

    protected static enum BreakOrNot {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    protected static enum DeclarationKind {
        NONE,
        FIELD,
        PARAMETER;

    }

    @AutoValue
    static abstract class DeclarationModifiersAndTypeAnnotations {
        DeclarationModifiersAndTypeAnnotations() {
        }

        abstract ImmutableList<AnnotationOrModifier> declarationModifiers();

        abstract ImmutableList<AnnotationTree> typeAnnotations();

        static DeclarationModifiersAndTypeAnnotations create(ImmutableList<AnnotationOrModifier> declarationModifiers, ImmutableList<AnnotationTree> typeAnnotations) {
            return new AutoValue_JavaInputAstVisitor_DeclarationModifiersAndTypeAnnotations(declarationModifiers, typeAnnotations);
        }

        static DeclarationModifiersAndTypeAnnotations empty() {
            return DeclarationModifiersAndTypeAnnotations.create((ImmutableList<AnnotationOrModifier>)ImmutableList.of(), (ImmutableList<AnnotationTree>)ImmutableList.of());
        }

        boolean hasDeclarationAnnotation() {
            return this.declarationModifiers().stream().anyMatch(AnnotationOrModifier::isAnnotation);
        }
    }

    @AutoOneOf(value=Kind.class)
    static abstract class AnnotationOrModifier
    implements Comparable<AnnotationOrModifier> {
        private static final Comparator<AnnotationOrModifier> COMPARATOR = Comparator.comparingInt(AnnotationOrModifier::position);

        AnnotationOrModifier() {
        }

        abstract Kind getKind();

        abstract AnnotationTree annotation();

        abstract Input.Tok modifier();

        static AnnotationOrModifier ofModifier(Input.Tok m) {
            return AutoOneOf_JavaInputAstVisitor_AnnotationOrModifier.modifier(m);
        }

        static AnnotationOrModifier ofAnnotation(AnnotationTree a) {
            return AutoOneOf_JavaInputAstVisitor_AnnotationOrModifier.annotation(a);
        }

        boolean isModifier() {
            return this.getKind().equals((Object)Kind.MODIFIER);
        }

        boolean isAnnotation() {
            return this.getKind().equals((Object)Kind.ANNOTATION);
        }

        int position() {
            switch (this.getKind().ordinal()) {
                case 0: {
                    return this.modifier().getPosition();
                }
                case 1: {
                    return Trees.getStartPosition(this.annotation());
                }
            }
            throw new AssertionError();
        }

        @Override
        public int compareTo(AnnotationOrModifier o) {
            return COMPARATOR.compare(this, o);
        }

        static enum Kind {
            MODIFIER,
            ANNOTATION;

        }
    }

    static enum ReceiverParameter {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    static enum VarArgsOrNot {
        YES,
        NO;


        static VarArgsOrNot valueOf(boolean b) {
            return b ? YES : NO;
        }

        boolean isYes() {
            return this == YES;
        }

        static VarArgsOrNot fromVariable(VariableTree node) {
            return VarArgsOrNot.valueOf((((JCTree.JCVariableDecl)node).mods.flags & 0x400000000L) == 0x400000000L);
        }
    }

    static enum DimensionsOrNot {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }
}

