/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.model.MLModelConfig;

public class BaseModelConfig
extends MLModelConfig {
    public static final String PARSE_FIELD_NAME = "base";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(BaseModelConfig.class, new ParseField("base", new String[0]), it -> BaseModelConfig.parse(it));
    public static final String ADDITIONAL_CONFIG_FIELD = "additional_config";
    protected Map<String, Object> additionalConfig;

    public BaseModelConfig(String modelType, String allConfig, Map<String, Object> additionalConfig) {
        super(modelType, allConfig);
        this.additionalConfig = additionalConfig;
        this.validateNoDuplicateKeys(allConfig, additionalConfig);
    }

    public static BaseModelConfig parse(XContentParser parser) throws IOException {
        String modelType = null;
        String allConfig = null;
        Map additionalConfig = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_type": {
                    modelType = parser.text();
                    continue block10;
                }
                case "all_config": {
                    allConfig = parser.text();
                    continue block10;
                }
                case "additional_config": {
                    additionalConfig = parser.map();
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        return new BaseModelConfig(modelType, allConfig, additionalConfig);
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public BaseModelConfig(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().onOrAfter(CommonValue.VERSION_3_1_0)) {
            this.additionalConfig = in.readMap();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(CommonValue.VERSION_3_1_0)) {
            out.writeMap(this.additionalConfig);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelType != null) {
            builder.field("model_type", this.modelType);
        }
        if (this.allConfig != null) {
            builder.field("all_config", this.allConfig);
        }
        if (this.additionalConfig != null) {
            builder.field(ADDITIONAL_CONFIG_FIELD, this.additionalConfig);
        }
        builder.endObject();
        return builder;
    }

    protected void validateNoDuplicateKeys(String allConfig, Map<String, Object> additionalConfig) {
        if (allConfig == null || additionalConfig == null || additionalConfig.isEmpty()) {
            return;
        }
        Map allConfigMap = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (String)allConfig, (boolean)false);
        Set duplicateKeys = allConfigMap.keySet().stream().filter(additionalConfig::containsKey).collect(Collectors.toSet());
        if (!duplicateKeys.isEmpty()) {
            throw new IllegalArgumentException("Duplicate keys found in both all_config and additional_config: " + String.join((CharSequence)", ", duplicateKeys));
        }
    }

    public Map<String, Object> getAdditionalConfig() {
        return this.additionalConfig;
    }

    @Generated
    public static BaseModelConfigBuilder baseModelConfigBuilder() {
        return new BaseModelConfigBuilder();
    }

    @Generated
    public void setAdditionalConfig(Map<String, Object> additionalConfig) {
        this.additionalConfig = additionalConfig;
    }

    @Generated
    public static class BaseModelConfigBuilder {
        @Generated
        private String modelType;
        @Generated
        private String allConfig;
        @Generated
        private Map<String, Object> additionalConfig;

        @Generated
        BaseModelConfigBuilder() {
        }

        @Generated
        public BaseModelConfigBuilder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Generated
        public BaseModelConfigBuilder allConfig(String allConfig) {
            this.allConfig = allConfig;
            return this;
        }

        @Generated
        public BaseModelConfigBuilder additionalConfig(Map<String, Object> additionalConfig) {
            this.additionalConfig = additionalConfig;
            return this;
        }

        @Generated
        public BaseModelConfig build() {
            return new BaseModelConfig(this.modelType, this.allConfig, this.additionalConfig);
        }

        @Generated
        public String toString() {
            return "BaseModelConfig.BaseModelConfigBuilder(modelType=" + this.modelType + ", allConfig=" + this.allConfig + ", additionalConfig=" + String.valueOf(this.additionalConfig) + ")";
        }
    }
}

