/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockLineBefore;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public abstract class BodyEnhancedAbstract
extends AbstractTextBlock
implements TextBlock {
    protected final HorizontalAlignment align;
    protected final FontConfiguration titleConfig;
    protected TextBlock area;
    private final Style style;

    BodyEnhancedAbstract(HorizontalAlignment align, FontConfiguration titleConfig, Style style) {
        this.align = align;
        this.titleConfig = titleConfig;
        this.style = style;
    }

    public static boolean isBlockSeparator(CharSequence cs) {
        String s2 = cs.toString();
        if (s2.startsWith("--") && s2.endsWith("--")) {
            return true;
        }
        if (s2.startsWith("==") && s2.endsWith("==")) {
            return true;
        }
        if (s2.startsWith("..") && s2.endsWith("..") && !s2.equals("...")) {
            return true;
        }
        return s2.startsWith("__") && s2.endsWith("__");
    }

    @Override
    public final XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.getArea(stringBounder).calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        this.getArea(ug.getStringBounder()).drawU(ug);
    }

    protected final TextBlock getTitle(String s2, ISkinSimple spriteContainer) {
        if (s2.length() <= 4) {
            return null;
        }
        s2 = StringUtils.trin(s2.substring(2, s2.length() - 2));
        return Display.getWithNewlines(spriteContainer.getPragma(), s2).create(this.titleConfig, HorizontalAlignment.LEFT, spriteContainer);
    }

    protected abstract TextBlock getArea(StringBounder var1);

    protected abstract double getMarginX();

    protected final TextBlock decorate(TextBlock block, char separator, TextBlock title, StringBounder stringBounder) {
        double marginX = this.getMarginX();
        if (separator == '\u0000') {
            return TextBlockUtils.withMargin(block, marginX, 0.0);
        }
        if (title == null) {
            return new TextBlockLineBefore(this.getDefaultThickness(), TextBlockUtils.withMargin(block, marginX, 4.0), separator);
        }
        XDimension2D dimTitle = title.calculateDimension(stringBounder);
        TextBlockLineBefore raw = new TextBlockLineBefore(this.getDefaultThickness(), TextBlockUtils.withMargin(block, marginX, 6.0, dimTitle.getHeight() / 2.0, 4.0), separator, title);
        return TextBlockUtils.withMargin(raw, 0.0, 0.0, dimTitle.getHeight() / 2.0, 0.0);
    }

    protected final double getDefaultThickness() {
        return this.style.value(PName.LineThickness).asDouble();
    }

    public final Style getStyle() {
        return this.style;
    }
}

