/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.transport.ConnectionImpl;
import com.sun.corba.ee.impl.transport.TemporarySelector;
import com.sun.corba.ee.spi.transport.TcpTimeouts;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class NioBufferWriter {
    protected TemporarySelector tmpWriteSelector;
    protected final Object tmpWriteSelectorLock = new Object();
    private SocketChannel socketChannel;
    private TcpTimeouts tcpTimeouts;

    public NioBufferWriter(SocketChannel socketChannel, TcpTimeouts tcpTimeouts) {
        this.socketChannel = socketChannel;
        this.tcpTimeouts = tcpTimeouts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void write(ByteBuffer byteBuffer) throws IOException {
        int nbytes = this.socketChannel.write(byteBuffer);
        if (byteBuffer.hasRemaining()) {
            TcpTimeouts.Waiter waiter;
            block10: {
                waiter = this.tcpTimeouts.waiter();
                SelectionKey sk = null;
                TemporarySelector tmpSelector = null;
                try {
                    tmpSelector = this.getTemporaryWriteSelector(this.socketChannel);
                    sk = tmpSelector.registerChannel(this.socketChannel, 4);
                    while (byteBuffer.hasRemaining() && !waiter.isExpired()) {
                        int nsel = tmpSelector.select(waiter.getTimeForSleep());
                        if (nsel > 0) {
                            tmpSelector.removeSelectedKey(sk);
                            while ((nbytes = this.socketChannel.write(byteBuffer)) > 0 && byteBuffer.hasRemaining()) {
                            }
                        }
                        if (nsel != 0 && nbytes != 0) continue;
                        waiter.advance();
                    }
                    if (tmpSelector == null) break block10;
                }
                catch (IOException ioe) {
                    try {
                        ioe.printStackTrace();
                        throw ConnectionImpl.wrapper.exceptionWhenWritingWithTemporarySelector(ioe, byteBuffer.position(), byteBuffer.limit(), waiter.timeWaiting(), this.tcpTimeouts.get_max_time_to_wait());
                    }
                    catch (Throwable throwable) {
                        if (tmpSelector != null) {
                            tmpSelector.cancelAndFlushSelector(sk);
                        }
                        throw throwable;
                    }
                }
                tmpSelector.cancelAndFlushSelector(sk);
            }
            if (byteBuffer.hasRemaining() && waiter.isExpired()) {
                throw ConnectionImpl.wrapper.transportWriteTimeoutExceeded(this.tcpTimeouts.get_max_time_to_wait(), waiter.timeWaiting());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeTemporaryWriteSelector() throws IOException {
        Object object = this.tmpWriteSelectorLock;
        synchronized (object) {
            if (this.tmpWriteSelector != null) {
                this.tmpWriteSelector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TemporarySelector getTemporaryWriteSelector(SocketChannel socketChannel1) throws IOException {
        Object object = this.tmpWriteSelectorLock;
        synchronized (object) {
            if (this.tmpWriteSelector == null) {
                this.tmpWriteSelector = new TemporarySelector(socketChannel1);
            }
        }
        return this.tmpWriteSelector;
    }
}

