/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.list;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import org.protege.editor.core.ui.list.MListAddButton;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.list.MListDeleteButton;
import org.protege.editor.core.ui.list.MListEditButton;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.core.ui.list.RendererWithInsets;
import org.protege.editor.core.ui.util.MousePositionCache;
import org.protege.editor.core.ui.util.UIUtil;

public class MList
extends JList {
    private static final Stroke BUTTON_STROKE = new BasicStroke(2.0f, 1, 1);
    private static final int BUTTON_DIMENSION = 16;
    private static final int BUTTON_MARGIN = 2;
    private static final Color FRAME_SECTION_HEADER_FOREGROUND = Color.GRAY;
    private static final Color FRAME_SECTION_HEADER_HIGH_CONTRAST_FOREGROUND = new Color(40, 40, 40);
    private Font sectionHeaderFont = new Font("Lucida Grande", 0, 10);
    private static final Color itemBackgroundColor = Color.WHITE;
    private ActionListener deleteActionListener = e -> this.handleDelete();
    private ActionListener addActionListener = e -> this.handleAdd();
    private ActionListener editActionListener = e -> this.handleEdit();
    private MListDeleteButton deleteButton = new MListDeleteButton(this.deleteActionListener){

        @Override
        public String getName() {
            String name = "<html><body>" + super.getName();
            String rowName = MList.this.getRowName(this.getRowObject());
            if (rowName != null) {
                name = name + " " + rowName.toLowerCase();
            }
            return name + "</body></html>";
        }
    };
    private MListAddButton addButton = new MListAddButton(this.addActionListener);
    private MListEditButton editButton = new MListEditButton(this.editActionListener);
    private MListCellRenderer ren;
    private boolean mouseDown;
    private List<MListButton> editAndDeleteButtonList = Arrays.asList(this.editButton, this.deleteButton);
    private List<MListButton> editButtonList = Arrays.asList(this.editButton);
    private List<MListButton> deleteButtonList = Arrays.asList(this.deleteButton);
    public int lastMousePositionCellIndex = -1;
    private final MousePositionCache mousePositionCache;
    private final DefaultListModel model = new DefaultListModel();

    public MList() {
        ListCellRenderer renderer = this.getCellRenderer();
        this.ren = new MListCellRenderer();
        this.ren.setContentRenderer(renderer);
        super.setCellRenderer(this.ren);
        MouseMotionAdapter mouseMovementListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                MList.this.handleMouseMoved();
            }
        };
        this.mousePositionCache = MousePositionCache.createAndInstall(this, () -> super.getMousePosition());
        this.addMouseMotionListener(mouseMovementListener);
        MouseAdapter mouseButtonListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MList.this.mouseDown = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MList.this.handleMouseClick(e);
                MList.this.mouseDown = false;
            }

            @Override
            public void mouseExited(MouseEvent event) {
                MList.this.repaint();
            }
        };
        this.addMouseListener(mouseButtonListener);
        this.addListSelectionListener(e -> this.model.set(e.getFirstIndex(), this.model.getElementAt(e.getFirstIndex())));
        this.attachedListenersForCacheResetting();
    }

    private void attachedListenersForCacheResetting() {
        this.addHierarchyListener(new HierarchyListener(){
            private boolean showing;
            {
                this.showing = MList.this.isShowing();
            }

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (MList.this.isShowing() != this.showing) {
                    this.showing = MList.this.isShowing();
                    MList.this.clearCellHeightCache();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MList.this.clearCellHeightCache();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                MList.this.clearCellHeightCache();
            }
        });
    }

    public void setListData(Object[] listData) {
        this.setModel(new DefaultListModel());
        this.model.clear();
        Stream.of(listData).forEach(o -> this.model.add(this.model.size(), o));
        this.setModel(this.model);
    }

    protected void clearCellHeightCache() {
        this.setFixedCellHeight(10);
        this.setFixedCellHeight(-1);
    }

    private void handleMouseMoved() {
        if (this.getModel().getSize() > 0) {
            Point pt;
            Rectangle dirty = this.getCellBounds(this.lastMousePositionCellIndex, this.lastMousePositionCellIndex);
            if (dirty != null) {
                this.repaint(dirty);
            }
            this.lastMousePositionCellIndex = (pt = this.getMousePosition()) != null ? this.locationToIndex(pt) : -1;
            dirty = this.getCellBounds(this.lastMousePositionCellIndex, this.lastMousePositionCellIndex);
            if (dirty != null) {
                this.repaint(dirty);
            }
        }
    }

    protected String getRowName(Object rowObject) {
        return null;
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        if (this.ren == null) {
            super.setCellRenderer(cellRenderer);
        } else {
            this.ren.setContentRenderer(cellRenderer);
        }
    }

    protected void handleAdd() {
        if (this.getSelectedValue() instanceof MListItem) {
            MListItem item = (MListItem)this.getSelectedValue();
            item.handleEdit();
        }
    }

    protected void handleDelete() {
        if (this.getSelectedValue() instanceof MListItem) {
            MListItem item = (MListItem)this.getSelectedValue();
            item.handleDelete();
        }
    }

    protected void handleEdit() {
        if (this.getSelectedValue() instanceof MListItem) {
            MListItem item = (MListItem)this.getSelectedValue();
            item.handleEdit();
        }
    }

    private void handleMouseClick(MouseEvent e) {
        for (MListButton button : this.getButtons(this.locationToIndex(e.getPoint()))) {
            if (!button.getBounds().contains(e.getPoint())) continue;
            button.getActionListener().actionPerformed(new ActionEvent(button, 1001, button.getName()));
            return;
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    protected List<MListButton> getButtons(Object value) {
        if (value instanceof MListSectionHeader) {
            return this.getSectionButtons((MListSectionHeader)value);
        }
        if (value instanceof MListItem) {
            return this.getListItemButtons((MListItem)value);
        }
        return Collections.emptyList();
    }

    protected List<MListButton> getSectionButtons(MListSectionHeader header) {
        ArrayList<MListButton> buttons = new ArrayList<MListButton>();
        if (header.canAdd()) {
            buttons.add(this.addButton);
        }
        return buttons;
    }

    protected List<MListButton> getListItemButtons(MListItem item) {
        if (item.isDeleteable() && item.isEditable()) {
            return this.editAndDeleteButtonList;
        }
        if (item.isDeleteable()) {
            return this.deleteButtonList;
        }
        if (item.isEditable()) {
            return this.editButtonList;
        }
        return Collections.emptyList();
    }

    protected Color getItemBackgroundColor(MListItem item) {
        return itemBackgroundColor;
    }

    public int getButtonDimension() {
        Font font = this.getFont();
        if (font == null) {
            return 16;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int height = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
        if (height < 20) {
            height = 20;
        }
        return height;
    }

    protected Border createPaddingBorder(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int bottomMargin = 0;
        if (list.getFixedCellHeight() == -1 && this.getModel().getSize() > index + 1) {
            bottomMargin = this.getRowHeightPadding(index);
        }
        return BorderFactory.createMatteBorder(0, 0, bottomMargin, 0, Color.WHITE);
    }

    private int getRowHeightPadding(int index) {
        int bottomMargin = 0;
        if (this.isNextRowHeader(index)) {
            bottomMargin = 20;
        }
        return bottomMargin;
    }

    protected Border createListItemBorder(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Border internalPadding = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        MatteBorder line = BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(240, 240, 240));
        MatteBorder externalBorder = BorderFactory.createMatteBorder(0, 20, 0, 0, list.getBackground());
        return BorderFactory.createCompoundBorder(externalBorder, BorderFactory.createCompoundBorder(line, internalPadding));
    }

    private boolean isNextRowHeader(int index) {
        if (index + 1 < this.getModel().getSize()) {
            return this.getModel().getElementAt(index + 1) instanceof MListSectionHeader;
        }
        return false;
    }

    private List<MListButton> getButtons(int index) {
        List<MListButton> buttons;
        block3: {
            int buttonDimension;
            Rectangle rowBounds;
            Object obj;
            block4: {
                if (index < 0) {
                    return Collections.emptyList();
                }
                obj = this.getModel().getElementAt(index);
                buttons = this.getButtons(obj);
                rowBounds = this.getCellBounds(index, index);
                if (rowBounds == null) break block3;
                buttonDimension = this.getButtonDimension();
                if (!(obj instanceof MListSectionHeader)) break block4;
                MListSectionHeader section = (MListSectionHeader)obj;
                FontMetrics fm = this.getGraphics().getFontMetrics(this.getSectionHeaderFont());
                Rectangle nameBounds = fm.getStringBounds(section.getName(), this.getGraphics()).getBounds();
                int x = 7 + nameBounds.width + 2;
                for (MListButton button : buttons) {
                    button.setLocation(x, rowBounds.y + ((rowBounds.height - this.getRowHeightPadding(index)) / 2 - buttonDimension / 2));
                    button.setSize(buttonDimension);
                    x += buttonDimension;
                    x += 2;
                    button.setRowObject(obj);
                }
                break block3;
            }
            if (!(obj instanceof MListItem)) break block3;
            int x = rowBounds.width - 2;
            for (MListButton button : buttons) {
                x -= buttonDimension;
                button.setLocation(x -= 2, rowBounds.y + 1);
                button.setSize(buttonDimension);
                button.setRowObject(obj);
            }
        }
        return buttons;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point mousePos = this.getMousePosition();
        if (mousePos == null) {
            return null;
        }
        for (MListButton button : this.getButtons(this.locationToIndex(mousePos))) {
            if (!button.getBounds().contains(mousePos)) continue;
            return button.getName();
        }
        int index = this.locationToIndex(event.getPoint());
        if (index == -1) {
            return null;
        }
        Object val = this.getModel().getElementAt(index);
        if (val instanceof MListItem) {
            return ((MListItem)val).getTooltip();
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke oldStroke = g2.getStroke();
        Rectangle clipBound = g.getClipBounds();
        for (int index = 0; index < this.getModel().getSize(); ++index) {
            Rectangle rowBounds = this.getCellBounds(index, index);
            if (rowBounds == null || !rowBounds.intersects(clipBound)) continue;
            this.paintRow(g2, clipBound, index, rowBounds);
        }
        g.setColor(oldColor);
        g2.setStroke(oldStroke);
    }

    private void paintRow(Graphics2D g2, Rectangle clipBound, int index, Rectangle rowBounds) {
        List<MListButton> buttons = this.getButtons(index);
        int endOfButtonRun = -1;
        for (MListButton button : buttons) {
            endOfButtonRun = this.paintButton(g2, clipBound, endOfButtonRun, button);
        }
        if (this.getModel().getElementAt(index) instanceof MListSectionHeader) {
            this.paintSectionHeader(g2, index, rowBounds, endOfButtonRun);
        }
    }

    private void paintSectionHeader(Graphics2D g2, int index, Rectangle rowBounds, int endOfButtonRun) {
        MListSectionHeader header = (MListSectionHeader)this.getModel().getElementAt(index);
        if (this.isSelectedIndex(index)) {
            g2.setColor(this.getSelectionForeground());
        } else {
            g2.setColor(this.getSectionHeaderForeground());
        }
        int baseLine = rowBounds.y + (this.getButtonDimension() + 2 - g2.getFontMetrics().getHeight()) / 2 + g2.getFontMetrics().getAscent();
        Font oldFont = g2.getFont();
        g2.setFont(this.getSectionHeaderFont());
        g2.drawString(header.getName(), 5, baseLine);
        g2.setFont(oldFont);
    }

    private Color getSectionHeaderForeground() {
        if (UIUtil.isHighContrastOn()) {
            return FRAME_SECTION_HEADER_HIGH_CONTRAST_FOREGROUND;
        }
        return FRAME_SECTION_HEADER_FOREGROUND;
    }

    private Font getSectionHeaderFont() {
        Font font = this.getFont();
        if (font != null) {
            int size = (int)((double)font.getSize() * 0.9);
            if (this.sectionHeaderFont.getSize() != size) {
                this.sectionHeaderFont = this.sectionHeaderFont.deriveFont(this.sectionHeaderFont.getStyle(), size);
            }
        }
        return this.sectionHeaderFont;
    }

    private int paintButton(Graphics2D g2, Rectangle clipBound, int endOfButtonRun, MListButton button) {
        Rectangle buttonBounds = button.getBounds();
        if (buttonBounds != null && buttonBounds.intersects(clipBound)) {
            g2.setColor(this.getButtonColor(button));
            g2.fillOval(buttonBounds.x, buttonBounds.y, buttonBounds.width, buttonBounds.height);
            g2.setColor(Color.WHITE);
            Stroke curStroke = g2.getStroke();
            g2.setStroke(BUTTON_STROKE);
            button.paintButtonContent(g2);
            g2.setStroke(curStroke);
            endOfButtonRun = buttonBounds.x + buttonBounds.width + 2;
        }
        return endOfButtonRun;
    }

    private Color getButtonColor(MListButton button) {
        Point pt = this.getMousePosition();
        if (pt == null) {
            return button.getBackground();
        }
        if (button.getBounds().contains(pt)) {
            if (this.mouseDown) {
                return Color.DARK_GRAY;
            }
            return button.getRollOverColor();
        }
        return button.getBackground();
    }

    @Override
    public Point getMousePosition() throws HeadlessException {
        return this.mousePositionCache.getMousePosition();
    }

    public class MListCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer contentRenderer;
        private DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof MListSectionHeader) {
                JLabel label = (JLabel)this.defaultListCellRenderer.getListCellRendererComponent((JList<?>)list, " ", index, isSelected, cellHasFocus);
                label.setBorder(BorderFactory.createCompoundBorder(MList.this.createPaddingBorder(list, " ", index, isSelected, cellHasFocus), BorderFactory.createEmptyBorder(3, 3, 2, 2)));
                label.setVerticalTextPosition(1);
                return label;
            }
            JComponent component = (JComponent)this.contentRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Dimension prefSize = component.getPreferredSize();
            component.setOpaque(true);
            if (value instanceof MListItem) {
                Border paddingBorder = MList.this.createPaddingBorder(list, value, index, isSelected, cellHasFocus);
                Border itemBorder = MList.this.createListItemBorder(list, value, index, isSelected, cellHasFocus);
                CompoundBorder border = BorderFactory.createCompoundBorder(paddingBorder, itemBorder);
                int buttonSpan = MList.this.getButtons(value).size() * (MList.this.getButtonDimension() + 2) + 4;
                border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(1, 1, 1, buttonSpan));
                component.setBorder(border);
                if (!isSelected) {
                    component.setBackground(MList.this.getItemBackgroundColor((MListItem)value));
                }
                if (component instanceof RendererWithInsets) {
                    Insets insets = component.getInsets();
                    prefSize.height = prefSize.height + insets.top + insets.bottom;
                    component.setPreferredSize(prefSize);
                }
            }
            if (isSelected) {
                component.setBackground(list.getSelectionBackground());
            }
            return component;
        }

        public void setContentRenderer(ListCellRenderer renderer) {
            this.contentRenderer = renderer;
        }
    }
}

