/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.effects;

import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.RenderedText;
import com.watabou.noosa.TextureFilm;
import com.watabou.utils.Callback;
import com.watabou.utils.SparseArray;
import java.util.ArrayList;

public class FloatingText
extends RenderedTextBlock {
    private static final float LIFESPAN = 1.0f;
    private static final float DISTANCE = 16.0f;
    public static final int ICON_SIZE = 7;
    public static TextureFilm iconFilm = new TextureFilm("effects/text_icons.png", 7, 7);
    public static int NO_ICON = -1;
    public static int PHYS_DMG = 0;
    public static int PHYS_DMG_NO_BLOCK = 1;
    public static int MAGIC_DMG = 2;
    public static int PICK_DMG = 3;
    public static int HUNGER = 5;
    public static int BURNING = 6;
    public static int SHOCKING = 7;
    public static int FROST = 8;
    public static int WATER = 9;
    public static int BLEEDING = 10;
    public static int TOXIC = 11;
    public static int CORROSION = 12;
    public static int POISON = 13;
    public static int OOZE = 14;
    public static int DEFERRED = 15;
    public static int CORRUPTION = 16;
    public static int AMULET = 17;
    public static int HEALING = 18;
    public static int SHIELDING = 19;
    public static int EXPERIENCE = 20;
    public static int STRENGTH = 21;
    public static int GOLD = 23;
    public static int ENERGY = 24;
    private Image icon;
    private boolean iconLeft;
    private float timeLeft;
    private int key = -1;
    private static final SparseArray<ArrayList<FloatingText>> stacks = new SparseArray();

    public FloatingText() {
        super(9 * PixelScene.defaultZoom);
        this.setHightlighting(false);
    }

    @Override
    public void update() {
        super.update();
        if (this.timeLeft >= 0.0f) {
            float f;
            this.timeLeft -= Game.elapsed;
            if (f <= 0.0f) {
                this.kill();
            } else {
                float p = this.timeLeft / 1.0f;
                this.alpha(p > 0.5f ? 1.0f : p * 2.0f);
                float yMove = 16.0f * Game.elapsed;
                this.y -= yMove;
                for (RenderedText t : this.words) {
                    t.y -= yMove;
                }
                if (this.icon != null) {
                    this.icon.alpha(p > 0.5f ? 1.0f : p * 2.0f);
                    this.icon.y -= yMove;
                }
            }
        }
    }

    @Override
    protected synchronized void layout() {
        super.layout();
        if (this.icon != null) {
            this.icon.x = this.iconLeft ? this.left() : this.left() + this.width() - this.icon.width();
            this.icon.y = this.top();
            PixelScene.align(this.icon);
        }
    }

    @Override
    public float width() {
        float width = super.width();
        if (this.icon != null) {
            width += this.icon.width() - 0.5f;
        }
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() {
        if (this.key != -1) {
            SparseArray<ArrayList<FloatingText>> sparseArray = stacks;
            synchronized (sparseArray) {
                ((ArrayList)stacks.get(this.key)).remove(this);
            }
            this.key = -1;
        }
        super.kill();
    }

    @Override
    public void destroy() {
        this.kill();
        super.destroy();
    }

    public void reset(float x, float y, String text, int color, int iconIdx, boolean left) {
        this.revive();
        this.zoom(1.0f / (float)PixelScene.defaultZoom);
        this.text(text);
        this.hardlight(color);
        if (iconIdx != NO_ICON) {
            this.icon = new Image("effects/text_icons.png");
            this.icon.frame(iconFilm.get(iconIdx));
            this.add(this.icon);
            this.iconLeft = left;
            if (this.iconLeft) {
                this.align(3);
            }
        } else {
            this.icon = null;
        }
        this.setPos(PixelScene.align(Camera.main, x - this.width() / 2.0f), PixelScene.align(Camera.main, y - this.height()));
        this.timeLeft = 1.0f;
    }

    public static void show(float x, float y, String text, int color) {
        FloatingText.show(x, y, -1, text, color, -1, false);
    }

    public static void show(float x, float y, int key, String text, int color) {
        FloatingText.show(x, y, key, text, color, -1, false);
    }

    public static void show(final float x, final float y, final int key, final String text, final int color, final int iconIdx, final boolean left) {
        Game.runOnRenderThread(new Callback(){

            @Override
            public void call() {
                FloatingText txt = GameScene.status();
                if (txt != null) {
                    txt.reset(x, y, text, color, iconIdx, left);
                    if (key != -1) {
                        FloatingText.push(txt, key);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void push(FloatingText txt, int key) {
        SparseArray<ArrayList<FloatingText>> sparseArray = stacks;
        synchronized (sparseArray) {
            txt.key = key;
            ArrayList<FloatingText> stack = (ArrayList<FloatingText>)stacks.get(key);
            if (stack == null) {
                stack = new ArrayList<FloatingText>();
                stacks.put(key, stack);
            }
            if (stack.size() > 0) {
                FloatingText below = txt;
                int numBelow = 0;
                for (int aboveIndex = stack.size() - 1; aboveIndex >= 0; --aboveIndex) {
                    ++numBelow;
                    FloatingText above = (FloatingText)stack.get(aboveIndex);
                    if (!(above.bottom() + 4.0f > below.top())) break;
                    above.setPos(above.left(), below.top() - above.height() - 4.0f);
                    above.timeLeft = Math.min(above.timeLeft, 1.0f - (float)numBelow / 5.0f);
                    above.timeLeft = Math.max(above.timeLeft, 0.0f);
                    below = above;
                }
            }
            stack.add(txt);
        }
    }
}

