﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2Request.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace PinpointSMSVoiceV2 {
namespace Model {

/**
 */
class DeleteRegistrationAttachmentRequest : public PinpointSMSVoiceV2Request {
 public:
  AWS_PINPOINTSMSVOICEV2_API DeleteRegistrationAttachmentRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteRegistrationAttachment"; }

  AWS_PINPOINTSMSVOICEV2_API Aws::String SerializePayload() const override;

  AWS_PINPOINTSMSVOICEV2_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The unique identifier for the registration attachment.</p>
   */
  inline const Aws::String& GetRegistrationAttachmentId() const { return m_registrationAttachmentId; }
  inline bool RegistrationAttachmentIdHasBeenSet() const { return m_registrationAttachmentIdHasBeenSet; }
  template <typename RegistrationAttachmentIdT = Aws::String>
  void SetRegistrationAttachmentId(RegistrationAttachmentIdT&& value) {
    m_registrationAttachmentIdHasBeenSet = true;
    m_registrationAttachmentId = std::forward<RegistrationAttachmentIdT>(value);
  }
  template <typename RegistrationAttachmentIdT = Aws::String>
  DeleteRegistrationAttachmentRequest& WithRegistrationAttachmentId(RegistrationAttachmentIdT&& value) {
    SetRegistrationAttachmentId(std::forward<RegistrationAttachmentIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_registrationAttachmentId;
  bool m_registrationAttachmentIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
