﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/resiliencehub/ResilienceHub_EXPORTS.h>
#include <aws/resiliencehub/model/AppComponent.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ResilienceHub {
namespace Model {
class ListAppVersionAppComponentsResult {
 public:
  AWS_RESILIENCEHUB_API ListAppVersionAppComponentsResult() = default;
  AWS_RESILIENCEHUB_API ListAppVersionAppComponentsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_RESILIENCEHUB_API ListAppVersionAppComponentsResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for
   * this ARN is:
   * arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
   * For more information about ARNs, see <a
   * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
   * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General
   * Reference</i> guide.</p>
   */
  inline const Aws::String& GetAppArn() const { return m_appArn; }
  template <typename AppArnT = Aws::String>
  void SetAppArn(AppArnT&& value) {
    m_appArnHasBeenSet = true;
    m_appArn = std::forward<AppArnT>(value);
  }
  template <typename AppArnT = Aws::String>
  ListAppVersionAppComponentsResult& WithAppArn(AppArnT&& value) {
    SetAppArn(std::forward<AppArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Defines an Application Component.</p>
   */
  inline const Aws::Vector<AppComponent>& GetAppComponents() const { return m_appComponents; }
  template <typename AppComponentsT = Aws::Vector<AppComponent>>
  void SetAppComponents(AppComponentsT&& value) {
    m_appComponentsHasBeenSet = true;
    m_appComponents = std::forward<AppComponentsT>(value);
  }
  template <typename AppComponentsT = Aws::Vector<AppComponent>>
  ListAppVersionAppComponentsResult& WithAppComponents(AppComponentsT&& value) {
    SetAppComponents(std::forward<AppComponentsT>(value));
    return *this;
  }
  template <typename AppComponentsT = AppComponent>
  ListAppVersionAppComponentsResult& AddAppComponents(AppComponentsT&& value) {
    m_appComponentsHasBeenSet = true;
    m_appComponents.emplace_back(std::forward<AppComponentsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Resilience Hub application version.</p>
   */
  inline const Aws::String& GetAppVersion() const { return m_appVersion; }
  template <typename AppVersionT = Aws::String>
  void SetAppVersion(AppVersionT&& value) {
    m_appVersionHasBeenSet = true;
    m_appVersion = std::forward<AppVersionT>(value);
  }
  template <typename AppVersionT = Aws::String>
  ListAppVersionAppComponentsResult& WithAppVersion(AppVersionT&& value) {
    SetAppVersion(std::forward<AppVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Token for the next set of results, or null if there are no more results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAppVersionAppComponentsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListAppVersionAppComponentsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_appArn;
  bool m_appArnHasBeenSet = false;

  Aws::Vector<AppComponent> m_appComponents;
  bool m_appComponentsHasBeenSet = false;

  Aws::String m_appVersion;
  bool m_appVersionHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ResilienceHub
}  // namespace Aws
