﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/redshift/Redshift_EXPORTS.h>

namespace Aws {
namespace Redshift {
namespace Model {
enum class AquaConfigurationStatus { NOT_SET, enabled, disabled, auto_ };

namespace AquaConfigurationStatusMapper {
AWS_REDSHIFT_API AquaConfigurationStatus GetAquaConfigurationStatusForName(const Aws::String& name);

AWS_REDSHIFT_API Aws::String GetNameForAquaConfigurationStatus(AquaConfigurationStatus value);
}  // namespace AquaConfigurationStatusMapper
}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
