/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.transport.cipher;

import com.hierynomus.sshj.transport.cipher.ChachaPolyCipher;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.transport.cipher.Cipher;

public class ChachaPolyCiphers {
    public static Factory CHACHA_POLY_OPENSSH() {
        return new Factory(16, 512, "chacha20-poly1305@openssh.com", "ChaCha20");
    }

    public static class Factory
    implements Factory.Named<Cipher> {
        private final int authSize;
        private final int keySize;
        private final String name;
        private final String cipher;

        public Factory(int authSize, int keySize, String name, String cipher) {
            this.authSize = authSize;
            this.keySize = keySize;
            this.name = name;
            this.cipher = cipher;
        }

        @Override
        public Cipher create() {
            return new ChachaPolyCipher(this.authSize, this.keySize / 8, this.cipher);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

