/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.List;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleAction;
import org.gradle.model.internal.inspect.ModelRuleInvoker;

public abstract class AbstractMethodRuleAction<T>
implements MethodRuleAction {
    private final ModelReference<T> subject;
    private final ModelRuleDescriptor descriptor;

    public AbstractMethodRuleAction(ModelReference<T> subject, ModelRuleDescriptor descriptor) {
        this.subject = subject;
        this.descriptor = descriptor;
    }

    public ModelReference<T> getSubject() {
        return this.subject;
    }

    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ModelRuleInvoker<?> invoker, MutableModelNode modelNode, List<ModelView<?>> inputs) {
        try (ModelView<T> subjectView = modelNode.asMutable(this.getSubject().getType(), this.descriptor);){
            this.execute(invoker, subjectView.getInstance(), inputs);
        }
    }

    protected abstract void execute(ModelRuleInvoker<?> var1, T var2, List<ModelView<?>> var3);
}

