/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VariantResolvingArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple.DefaultExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class VariantArtifactSetCache {
    private static final ExcludeSpec EXCLUDE_NOTHING = new DefaultExcludeFactory().nothing();
    private final Map<Long, ArtifactSet> cache = new ConcurrentHashMap<Long, ArtifactSet>();

    public ArtifactSet getImplicitVariant(ComponentGraphResolveState component, VariantGraphResolveState variant) {
        if (!(component instanceof LocalComponentGraphResolveState)) {
            return VariantArtifactSetCache.createImplicitVariant(component, variant);
        }
        Long key = variant.getInstanceId();
        ArtifactSet result = this.cache.get(key);
        if (result != null) {
            return result;
        }
        return this.cache.computeIfAbsent(key, id -> VariantArtifactSetCache.createImplicitVariant(component, variant));
    }

    private static VariantResolvingArtifactSet createImplicitVariant(ComponentGraphResolveState component, VariantGraphResolveState variant) {
        return new VariantResolvingArtifactSet(component, variant, ImmutableAttributes.EMPTY, Collections.emptyList(), EXCLUDE_NOTHING, Collections.emptySet());
    }
}

