#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hslua
version:              2.3.0
visibility:           public
id:                   hslua-2.3.0-7PyAyX5yUlRJTlLi4npKnX
key:                  hslua-2.3.0-7PyAyX5yUlRJTlLi4npKnX
license:              MIT
copyright:
    © 2007–2012 Gracjan Polak;
    © 2012–2016 Ömer Sinan Ağacan;
    © 2017-2023 Albert Krewinkel

maintainer:           tarleb@hslua.org
author:               Albert Krewinkel, Gracjan Polak, Ömer Sinan Ağacan
homepage:             https://hslua.org/
synopsis:             Bindings to Lua, an embeddable scripting language
description:
    HsLua provides wrappers and helpers
    to bridge Haskell and <https://www.lua.org/ Lua>.

    It builds upon the /lua/ package, which allows to bundle
    a Lua interpreter with a Haskell program.

    Example programs are can be found in the @hslua-examples@
    subdir of the project
    <https://github.com/hslua/hslua repository>.

category:             Foreign
abi:                  ffaaac3599eb00c52740934285bd0188
exposed:              True
exposed-modules:
    HsLua,
    HsLua.Aeson from hslua-aeson-2.3.1.1-IvVeENmFDyX5didLIBk16O:HsLua.Aeson,
    HsLua.Class.Exposable from hslua-classes-2.3.1-6aXcQ65HESk1rKaYOKDuGG:HsLua.Class.Exposable,
    HsLua.Class.Invokable from hslua-classes-2.3.1-6aXcQ65HESk1rKaYOKDuGG:HsLua.Class.Invokable,
    HsLua.Class.Peekable from hslua-classes-2.3.1-6aXcQ65HESk1rKaYOKDuGG:HsLua.Class.Peekable,
    HsLua.Class.Pushable from hslua-classes-2.3.1-6aXcQ65HESk1rKaYOKDuGG:HsLua.Class.Pushable,
    HsLua.Class.Util from hslua-classes-2.3.1-6aXcQ65HESk1rKaYOKDuGG:HsLua.Class.Util,
    HsLua.Core from hslua-core-2.3.2-Hc8nxVcTqJzLmWAcyWEOJJ:HsLua.Core,
    HsLua.Core.Error from hslua-core-2.3.2-Hc8nxVcTqJzLmWAcyWEOJJ:HsLua.Core.Error,
    HsLua.Core.Types from hslua-core-2.3.2-Hc8nxVcTqJzLmWAcyWEOJJ:HsLua.Core.Types,
    HsLua.Core.Utf8 from hslua-core-2.3.2-Hc8nxVcTqJzLmWAcyWEOJJ:HsLua.Core.Utf8,
    HsLua.Marshalling from hslua-marshalling-2.3.1-3ZdvDEhVNYE2vGQkfpjKaT:HsLua.Marshalling,
    HsLua.ObjectOrientation from hslua-objectorientation-2.3.1-6ewbINQ5HTH11kNUGQtnkR:HsLua.ObjectOrientation,
    HsLua.Packaging from hslua-packaging-2.3.1-AEmT0i87LmPJHjpnHNTU4y:HsLua.Packaging,
    HsLua.Packaging.Function from hslua-packaging-2.3.1-AEmT0i87LmPJHjpnHNTU4y:HsLua.Packaging.Function,
    HsLua.Packaging.Module from hslua-packaging-2.3.1-AEmT0i87LmPJHjpnHNTU4y:HsLua.Packaging.Module,
    HsLua.Packaging.Rendering from hslua-packaging-2.3.1-AEmT0i87LmPJHjpnHNTU4y:HsLua.Packaging.Rendering,
    HsLua.Typing from hslua-typing-0.1.1-JzMWCeOOsUBKlBWh0spNg8:HsLua.Typing,
    HsLua.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hslua-2.3.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hslua-2.3.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hslua-2.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hslua
hs-libraries:         HShslua-2.3.0-7PyAyX5yUlRJTlLi4npKnX
depends:
    base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7
    exceptions-0.10.5 hslua-aeson-2.3.1.1-IvVeENmFDyX5didLIBk16O
    hslua-classes-2.3.1-6aXcQ65HESk1rKaYOKDuGG
    hslua-core-2.3.2-Hc8nxVcTqJzLmWAcyWEOJJ
    hslua-marshalling-2.3.1-3ZdvDEhVNYE2vGQkfpjKaT
    hslua-objectorientation-2.3.1-6ewbINQ5HTH11kNUGQtnkR
    hslua-packaging-2.3.1-AEmT0i87LmPJHjpnHNTU4y
    hslua-typing-0.1.1-JzMWCeOOsUBKlBWh0spNg8 mtl-2.2.2 text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-hslua/html/hslua.haddock
haddock-html:         /usr/share/doc/haskell-hslua/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

