/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.Tools;

public class PunctuationMarkAtParagraphEnd2
extends TextLevelRule {
    private static final int TOKEN_THRESHOLD = 10;
    private final Language lang;

    public PunctuationMarkAtParagraphEnd2(ResourceBundle messages, Language lang) {
        super(messages);
        this.lang = Objects.requireNonNull(lang);
        super.setCategory(Categories.PUNCTUATION.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
        this.setDefaultOff();
    }

    @Override
    public String getId() {
        return "PUNCTUATION_PARAGRAPH_END2";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("punctuation_mark_paragraph_end_desc");
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        int sentPos = 0;
        int tokenCount = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens;
            for (AnalyzedTokenReadings token : tokens = sentence.getTokens()) {
                if (token.isNonWord() || token.isWhitespace()) continue;
                ++tokenCount;
            }
            AnalyzedTokenReadings lastNonSpaceToken = this.getLastNonSpaceToken(tokens);
            boolean isParaEnd = Tools.isParagraphEnd(sentences, sentPos, this.lang);
            if (isParaEnd && tokenCount > 10 && lastNonSpaceToken != null && !lastNonSpaceToken.getToken().matches("[:.?!\u2026]") && !lastNonSpaceToken.isNonWord()) {
                RuleMatch ruleMatch = new RuleMatch(this, sentence, pos + lastNonSpaceToken.getStartPos(), pos + lastNonSpaceToken.getEndPos(), this.messages.getString("punctuation_mark_paragraph_end_msg"));
                ruleMatch.setSuggestedReplacement(lastNonSpaceToken.getToken() + ".");
                ruleMatches.add(ruleMatch);
            }
            if (isParaEnd) {
                tokenCount = 0;
            }
            ++sentPos;
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private AnalyzedTokenReadings getLastNonSpaceToken(AnalyzedTokenReadings[] tokens) {
        for (int i = tokens.length - 1; i >= 0; --i) {
            if (tokens[i].isWhitespace()) continue;
            return tokens[i];
        }
        return null;
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

