/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.unwrap.GroovyUnwrapper;

public class GroovyCatchRemover
extends GroovyUnwrapper {
    public GroovyCatchRemover() {
        super(CodeInsightBundle.message((String)"remove.catch", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        if (e == null) {
            GroovyCatchRemover.$$$reportNull$$$0(0);
        }
        return e instanceof GrCatchClause && GroovyCatchRemover.tryHasSeveralCatches(e);
    }

    private static boolean tryHasSeveralCatches(PsiElement el) {
        return ((GrTryCatchStatement)el.getParent()).getCatchClauses().length > 1;
    }

    protected void doUnwrap(PsiElement element, GroovyUnwrapper.Context context) throws IncorrectOperationException {
        context.delete(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/unwrap/GroovyCatchRemover", "isApplicableTo"));
    }
}

