/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.ui.presentation;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.impl.ToolbarUtils;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.tables.ColumnSelectionKt;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.actions.TableActionKeys;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.GraphicsUtils;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.PresentationWithCustomCursor;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.TableInlayProperties;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 O2\u00020\u0001:\u0002NOB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020\u001bH\u0016J\u0010\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020+H\u0002J\u0017\u0010/\u001a\u00020\u001b2\b\u00100\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u00101J\u001e\u00102\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020+H\u0002J&\u00103\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0002J(\u00106\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t070\u000e2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\u0017\u00109\u001a\u0004\u0018\u00010\t2\u0006\u0010:\u001a\u00020&H\u0002\u00a2\u0006\u0002\u0010;J\u0018\u0010<\u001a\u00020&2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\tH\u0002J\u0010\u0010?\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\tH\u0002J\u0018\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020B2\u0006\u0010>\u001a\u00020\tH\u0002J\u0018\u0010C\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010D\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J(\u0010E\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020\u00132\u0006\u0010H\u001a\u00020\u0013H\u0002J\u0010\u0010I\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J@\u0010J\u001a\u00020\u001b2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0015\u001a\u00020\t2\u001e\u0010L\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001b0MH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006P"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/HorizontalBarPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;)V", "lastSelectedIndex", "", "Ljava/lang/Integer;", "boundsState", "Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/HorizontalBarPresentation$BoundsState;", "barsModel", "", "Ljava/awt/Rectangle;", "getBarsModel", "()Ljava/util/List;", "isInvalid", "", "()Z", "width", "getWidth", "()I", "height", "getHeight", "paint", "", "graphics", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "", "mouseClicked", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "mouseMoved", "mouseExited", "calculateCurrentBoundsState", "document", "Lcom/intellij/openapi/editor/Document;", "calculateRowWidth", "fontMetrics", "Ljava/awt/FontMetrics;", "updateSelectedIndexIfNeeded", "index", "(Ljava/lang/Integer;)V", "buildBarsModel", "calculatePositions", "header", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;", "buildSectors", "Lkotlin/Pair;", "positions", "determineColumnIndex", "point", "(Ljava/awt/Point;)Ljava/lang/Integer;", "calculateToolbarPosition", "componentHeight", "columnIndex", "showToolbar", "createAndShowHint", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "handleMouseLeftDoubleClick", "handleMouseLeftClick", "actuallyPaintBars", "rect", "hover", "accent", "paintBars", "paintCircles", "rects", "block", "Lkotlin/Function3;", "BoundsState", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nHorizontalBarPresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HorizontalBarPresentation.kt\norg/intellij/plugins/markdown/editor/tables/ui/presentation/HorizontalBarPresentation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,299:1\n1563#2:300\n1634#2,3:301\n1563#2:305\n1634#2,3:306\n360#2,7:309\n1#3:304\n7#4,6:316\n*S KotlinDebug\n*F\n+ 1 HorizontalBarPresentation.kt\norg/intellij/plugins/markdown/editor/tables/ui/presentation/HorizontalBarPresentation\n*L\n140#1:300\n140#1:301,3\n164#1:305\n164#1:306,3\n168#1:309,7\n212#1:316,6\n*E\n"})
public final class HorizontalBarPresentation
extends BasePresentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final MarkdownTable table;
    @Nullable
    private Integer lastSelectedIndex;
    @NotNull
    private BoundsState boundsState;
    @NotNull
    private static final BoundsState emptyBoundsState = new BoundsState(0, 0, CollectionsKt.emptyList());
    public static final int barHeight = 6;
    public static final int leftPadding = 10;

    public HorizontalBarPresentation(@NotNull Editor editor2, @NotNull MarkdownTable table) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.editor = editor2;
        this.table = table;
        this.boundsState = emptyBoundsState;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)this.table.getProject()).performForCommittedDocument(document2, () -> HorizontalBarPresentation._init_$lambda$1(this, document2));
    }

    private final List<Rectangle> getBarsModel() {
        return this.boundsState.getBarsModel();
    }

    private final boolean isInvalid() {
        return !this.table.isValid() || this.editor.isDisposed();
    }

    public int getWidth() {
        return this.boundsState.getWidth();
    }

    public int getHeight() {
        return this.boundsState.getHeight();
    }

    public void paint(@NotNull Graphics2D graphics, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (this.isInvalid()) {
            return;
        }
        GraphicsUtils.INSTANCE.useCopy(graphics, arg_0 -> HorizontalBarPresentation.paint$lambda$2(this, arg_0));
    }

    @NotNull
    public String toString() {
        return "HorizontalBarPresentation";
    }

    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        int n;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (SwingUtilities.isLeftMouseButton(event) && (n3 = (n2 = event.getClickCount()) % (n = 2)) + (n & ((n3 ^ n) & (n3 | -n3)) >> 31) == 0) {
            this.handleMouseLeftDoubleClick(event, translated);
        } else if (SwingUtilities.isLeftMouseButton(event)) {
            this.handleMouseLeftClick(event, translated);
        }
    }

    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        Integer index = this.determineColumnIndex(translated);
        this.updateSelectedIndexIfNeeded(index);
    }

    public void mouseExited() {
        this.updateSelectedIndexIfNeeded(null);
    }

    private final BoundsState calculateCurrentBoundsState(Document document) {
        if (this.isInvalid()) {
            return emptyBoundsState;
        }
        FontMetrics fontsMetrics = HorizontalBarPresentation.Companion.obtainFontMetrics(this.editor);
        int width = this.calculateRowWidth(fontsMetrics, document);
        List<Rectangle> barsModel = this.buildBarsModel(fontsMetrics, document);
        return new BoundsState(width, 6, barsModel);
    }

    private final int calculateRowWidth(FontMetrics fontMetrics, Document document) {
        if (this.isInvalid()) {
            return 0;
        }
        MarkdownTableRow markdownTableRow = this.table.getHeaderRow();
        if (markdownTableRow == null) {
            return 0;
        }
        MarkdownTableRow header = markdownTableRow;
        return fontMetrics.stringWidth(document.getText(header.getTextRange()));
    }

    private final void updateSelectedIndexIfNeeded(Integer index) {
        if (!Intrinsics.areEqual((Object)this.lastSelectedIndex, (Object)index)) {
            this.lastSelectedIndex = index;
            InlayHintsUtilsKt.fireUpdateEvent((InlayPresentation)((InlayPresentation)this), (Dimension)new Dimension(0, 0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Rectangle> buildBarsModel(FontMetrics fontMetrics, Document document) {
        void $this$mapTo$iv$iv;
        MarkdownTableRow markdownTableRow = this.table.getHeaderRow();
        if (markdownTableRow == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        MarkdownTableRow header = markdownTableRow;
        List<Integer> positions = this.calculatePositions(header, document, fontMetrics);
        List<Pair<Integer, Integer>> sectors = this.buildSectors(positions);
        Iterable $this$map$iv = sectors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int offset = ((Number)pair.component1()).intValue();
            int width = ((Number)pair.component2()).intValue();
            collection.add(new Rectangle(offset - 3, 0, width + 6, 6));
        }
        return (List)destination$iv$iv;
    }

    private final List<Integer> calculatePositions(MarkdownTableRow header, Document document, FontMetrics fontMetrics) {
        PsiElement psiElement = header.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        Sequence separators = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true), HorizontalBarPresentation::calculatePositions$lambda$5), HorizontalBarPresentation::calculatePositions$lambda$6);
        int separatorWidth = fontMetrics.charWidth('|');
        Integer n = (Integer)SequencesKt.firstOrNull((Sequence)separators);
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int firstOffset = n;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int position = this.editor.offsetToXY((int)firstOffset).x + separatorWidth / 2;
        int lastOffset = firstOffset;
        result.add(position);
        Iterator iterator = SequencesKt.drop((Sequence)separators, (int)1).iterator();
        while (iterator.hasNext()) {
            int offset = ((Number)iterator.next()).intValue();
            int length = fontMetrics.stringWidth(document.getText(new TextRange(lastOffset, offset)));
            result.add(position += length);
            lastOffset = offset;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Integer, Integer>> buildSectors(List<Integer> positions) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.windowed$default((Iterable)positions, (int)2, (int)0, (boolean)false, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int left = ((Number)list2.get(0)).intValue();
            int right = ((Number)list2.get(1)).intValue();
            collection.add(TuplesKt.to((Object)left, (Object)(right - left)));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final Integer determineColumnIndex(Point point) {
        int n;
        block2: {
            List<Rectangle> $this$indexOfFirst$iv = this.getBarsModel();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Rectangle> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Rectangle item$iv;
                Rectangle it = item$iv = iterator.next();
                boolean bl = false;
                if (it.contains(point)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        Integer n2 = n;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        return !(it < 0) ? n2 : null;
    }

    private final Point calculateToolbarPosition(int componentHeight, int columnIndex) {
        Point point = this.editor.offsetToXY(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)this.table)));
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Point position = point;
        Point editorParent = this.editor.getContentComponent().getTopLevelAncestor().getLocationOnScreen();
        Point editorPosition = this.editor.getContentComponent().getLocationOnScreen();
        position.translate(editorPosition.x - editorParent.x, editorPosition.y - editorParent.y);
        position.translate(10, -this.editor.getLineHeight());
        position.translate(0, -componentHeight);
        Rectangle rect = this.getBarsModel().get(columnIndex);
        int bottomPadding = 2;
        position.translate(rect.x, -rect.y - 12 - bottomPadding);
        return position;
    }

    private final void showToolbar(int columnIndex) {
        JComponent targetComponent = ToolbarUtils.INSTANCE.createTargetComponent(this.editor, arg_0 -> HorizontalBarPresentation.showToolbar$lambda$10(this, columnIndex, arg_0));
        ToolbarUtils.INSTANCE.createImmediatelyUpdatedToolbar(HorizontalBarPresentation.Companion.getColumnActionGroup(), "MarkdownTableInlayToolbar", targetComponent, true, arg_0 -> HorizontalBarPresentation.showToolbar$lambda$11(this, columnIndex, arg_0));
    }

    private final void createAndShowHint(ActionToolbar toolbar2, int columnIndex) {
        LightweightHint hint = new LightweightHint(toolbar2.getComponent());
        hint.setForceShowAsPopup(true);
        Point targetPoint = this.calculateToolbarPosition(hint.getComponent().getPreferredSize().height, columnIndex);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        hintManager.hideAllHints();
        int flags = 1066;
        hintManager.showEditorHint(hint, this.editor, targetPoint, flags, 0, false);
    }

    private final void handleMouseLeftDoubleClick(MouseEvent event, Point translated) {
        Integer n = this.determineColumnIndex(translated);
        if (n == null) {
            return;
        }
        int columnIndex = n;
        ActionsKt.invokeLater$default(null, () -> HorizontalBarPresentation.handleMouseLeftDoubleClick$lambda$13(this, columnIndex), (int)1, null);
    }

    private final void handleMouseLeftClick(MouseEvent event, Point translated) {
        Integer n = this.determineColumnIndex(translated);
        if (n == null) {
            return;
        }
        int columnIndex = n;
        this.showToolbar(columnIndex);
    }

    private final void actuallyPaintBars(Graphics2D graphics, Rectangle rect, boolean hover, boolean accent) {
        int paintCount = accent ? 2 : 1;
        for (int i = 0; i < paintCount; ++i) {
            int it = i;
            boolean bl = false;
            graphics.setColor(hover ? TableInlayProperties.INSTANCE.getBarHoverColor() : TableInlayProperties.INSTANCE.getBarColor());
            graphics.fillRoundRect(rect.x, 0, rect.width, 6, 6, 6);
            GraphicsUtils.INSTANCE.clearOvalOverEditor(graphics, rect.x, 0, 6, 6);
            GraphicsUtils.INSTANCE.clearOvalOverEditor(graphics, rect.x + rect.width - 6, 0, 6, 6);
        }
    }

    private final void paintBars(Graphics2D graphics) {
        List<Rectangle> currentBarsModel = this.getBarsModel();
        Iterator iterator = ((Iterable)currentBarsModel).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Rectangle rect = (Rectangle)iterator.next();
            Integer n2 = this.lastSelectedIndex;
            int n3 = index;
            boolean mouseIsOver = n2 != null && n2 == n3;
            this.actuallyPaintBars(graphics, rect, mouseIsOver, false);
        }
        int n4 = 2;
        n = 0;
        while (n < n4) {
            int it = n++;
            boolean bl = false;
            HorizontalBarPresentation.paintCircles$default(this, currentBarsModel, 0, (arg_0, arg_1, arg_2) -> HorizontalBarPresentation.paintBars$lambda$16$lambda$15(graphics, arg_0, arg_1, arg_2), 2, null);
        }
    }

    private final void paintCircles(List<? extends Rectangle> rects, int width, Function3<? super Integer, ? super Rectangle, ? super Integer, Unit> block) {
        if (!((Collection)rects).isEmpty()) {
            Iterator iterator = ((Iterable)rects).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                Rectangle rect = (Rectangle)iterator.next();
                block.invoke((Object)rect.x, (Object)rect, (Object)index);
            }
            Rectangle it = (Rectangle)CollectionsKt.last(rects);
            boolean bl = false;
            block.invoke((Object)(it.x + it.width - width), (Object)it, (Object)-1);
        }
    }

    static /* synthetic */ void paintCircles$default(HorizontalBarPresentation horizontalBarPresentation, List list2, int n, Function3 function3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 6;
        }
        horizontalBarPresentation.paintCircles(list2, n, (Function3<? super Integer, ? super Rectangle, ? super Integer, Unit>)function3);
    }

    private static final Unit lambda$1$lambda$0(HorizontalBarPresentation this$0, Document $document) {
        if (!this$0.isInvalid() && !TableFormattingUtils.INSTANCE.isSoftWrapping(this$0.table, this$0.editor)) {
            BoundsState calculated;
            this$0.boundsState = calculated = this$0.calculateCurrentBoundsState($document);
            this$0.fireSizeChanged(new Dimension(0, 0), new Dimension(calculated.getWidth(), calculated.getHeight()));
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(HorizontalBarPresentation this$0, Document $document) {
        ActionsKt.invokeLater((ModalityState)ModalityState.stateForComponent((Component)this$0.editor.getContentComponent()), () -> HorizontalBarPresentation.lambda$1$lambda$0(this$0, $document));
    }

    private static final Unit paint$lambda$2(HorizontalBarPresentation this$0, Graphics2D local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        GraphicsUtil.setupAntialiasing((Graphics)local);
        GraphicsUtil.setupRoundedBorderAntialiasing((Graphics)local);
        this$0.paintBars(local);
        return Unit.INSTANCE;
    }

    private static final boolean calculatePositions$lambda$5(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TABLE_SEPARATOR");
        return PsiUtilsKt.hasType(it, iElementType) && !(it instanceof MarkdownTableSeparatorRow);
    }

    private static final int calculatePositions$lambda$6(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PsiTreeUtilKt.getStartOffset((PsiElement)it);
    }

    private static final void showToolbar$lambda$10(HorizontalBarPresentation this$0, int $columnIndex, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        HorizontalBarPresentation.Companion.uiDataSnapshot(sink, this$0.table, $columnIndex);
    }

    private static final Unit showToolbar$lambda$11(HorizontalBarPresentation this$0, int $columnIndex, ActionToolbar it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.createAndShowHint(it, $columnIndex);
        return Unit.INSTANCE;
    }

    private static final Unit handleMouseLeftDoubleClick$lambda$13(HorizontalBarPresentation this$0, int $columnIndex) {
        Project project$iv = null;
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this$0, $columnIndex){
            final /* synthetic */ HorizontalBarPresentation this$0;
            final /* synthetic */ int $columnIndex$inlined;
            {
                this.this$0 = horizontalBarPresentation;
                this.$columnIndex$inlined = n;
            }

            public final void run() {
                boolean bl = false;
                ColumnSelectionKt.selectColumn(HorizontalBarPresentation.access$getTable$p(this.this$0), HorizontalBarPresentation.access$getEditor$p(this.this$0), this.$columnIndex$inlined, true, true, true);
            }
        }, name$iv, groupId$iv);
        return Unit.INSTANCE;
    }

    private static final Unit paintBars$lambda$16$lambda$15(Graphics2D $graphics, int x, Rectangle rectangle, int n) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"<unused var>");
        $graphics.setColor(TableInlayProperties.INSTANCE.getBarColor());
        $graphics.fillOval(x, 0, 6, 6);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MarkdownTable access$getTable$p(HorizontalBarPresentation $this) {
        return $this.table;
    }

    public static final /* synthetic */ Editor access$getEditor$p(HorizontalBarPresentation $this) {
        return $this.editor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/HorizontalBarPresentation$BoundsState;", "", "width", "", "height", "barsModel", "", "Ljava/awt/Rectangle;", "<init>", "(IILjava/util/List;)V", "getWidth", "()I", "getHeight", "getBarsModel", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.markdown"})
    private static final class BoundsState {
        private final int width;
        private final int height;
        @NotNull
        private final List<Rectangle> barsModel;

        public BoundsState(int width, int height, @NotNull List<? extends Rectangle> barsModel) {
            Intrinsics.checkNotNullParameter(barsModel, (String)"barsModel");
            this.width = width;
            this.height = height;
            this.barsModel = barsModel;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final List<Rectangle> getBarsModel() {
            return this.barsModel;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        @NotNull
        public final List<Rectangle> component3() {
            return this.barsModel;
        }

        @NotNull
        public final BoundsState copy(int width, int height, @NotNull List<? extends Rectangle> barsModel) {
            Intrinsics.checkNotNullParameter(barsModel, (String)"barsModel");
            return new BoundsState(width, height, barsModel);
        }

        public static /* synthetic */ BoundsState copy$default(BoundsState boundsState, int n, int n2, List list2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = boundsState.width;
            }
            if ((n3 & 2) != 0) {
                n2 = boundsState.height;
            }
            if ((n3 & 4) != 0) {
                list2 = boundsState.barsModel;
            }
            return boundsState.copy(n, n2, list2);
        }

        @NotNull
        public String toString() {
            return "BoundsState(width=" + this.width + ", height=" + this.height + ", barsModel=" + this.barsModel + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            result = result * 31 + ((Object)this.barsModel).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BoundsState)) {
                return false;
            }
            BoundsState boundsState = (BoundsState)other;
            if (this.width != boundsState.width) {
                return false;
            }
            if (this.height != boundsState.height) {
                return false;
            }
            return Intrinsics.areEqual(this.barsModel, boundsState.barsModel);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u001e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/HorizontalBarPresentation$Companion;", "", "<init>", "()V", "columnActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getColumnActionGroup", "()Lcom/intellij/openapi/actionSystem/ActionGroup;", "emptyBoundsState", "Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/HorizontalBarPresentation$BoundsState;", "barHeight", "", "leftPadding", "wrapPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "factory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "editor", "Lcom/intellij/openapi/editor/Editor;", "presentation", "create", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "obtainFontMetrics", "Ljava/awt/FontMetrics;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "columnIndex", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        private final ActionGroup getColumnActionGroup() {
            AnAction anAction = ActionManager.getInstance().getAction("Markdown.TableColumnActions");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            return (ActionGroup)anAction;
        }

        private final InlayPresentation wrapPresentation(PresentationFactory factory, Editor editor2, InlayPresentation presentation) {
            return (InlayPresentation)PresentationFactory.inset$default((PresentationFactory)factory, (InlayPresentation)((InlayPresentation)new PresentationWithCustomCursor(editor2, presentation)), (int)10, (int)0, (int)2, (int)2, (int)4, null);
        }

        @NotNull
        public final InlayPresentation create(@NotNull PresentationFactory factory, @NotNull Editor editor2, @NotNull MarkdownTable table) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            return this.wrapPresentation(factory, editor2, (InlayPresentation)new HorizontalBarPresentation(editor2, table));
        }

        private final FontMetrics obtainFontMetrics(Editor editor2) {
            Font font = editor2.getColorsScheme().getFont(EditorFontType.PLAIN);
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            Font font2 = font;
            FontMetrics fontMetrics = editor2.getContentComponent().getFontMetrics(font2);
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
            return fontMetrics;
        }

        private final void uiDataSnapshot(DataSink sink, MarkdownTable table, int columnIndex) {
            WeakReference<MarkdownTable> tableReference = new WeakReference<MarkdownTable>(table);
            sink.lazy(TableActionKeys.INSTANCE.getCOLUMN_INDEX(), () -> Companion.uiDataSnapshot$lambda$0(columnIndex));
            sink.lazy(TableActionKeys.INSTANCE.getELEMENT(), () -> Companion.uiDataSnapshot$lambda$1(tableReference));
        }

        private static final Integer uiDataSnapshot$lambda$0(int $columnIndex) {
            return $columnIndex;
        }

        private static final WeakReference uiDataSnapshot$lambda$1(WeakReference $tableReference) {
            return $tableReference;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

