/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.starters;

import com.intellij.ide.starters.StarterModuleImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/starters/GradleStarterModuleImporter;", "Lcom/intellij/ide/starters/StarterModuleImporter;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "title", "getTitle", "runAfterSetup", "", "module", "Lcom/intellij/openapi/module/Module;", "findGradleFile", "Ljava/io/File;", "fixGradlewExecutableFlag", "", "containingDir", "intellij.gradle.java"})
public final class GradleStarterModuleImporter
implements StarterModuleImporter {
    @NotNull
    private final String id;
    @NotNull
    private final String title;

    public GradleStarterModuleImporter() {
        this.id = "gradle";
        this.title = "Gradle";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    public boolean runAfterSetup(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        File file = this.findGradleFile(module);
        if (file == null) {
            return true;
        }
        File gradleFile = file;
        String rootDirectory = gradleFile.getParent();
        File file2 = gradleFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
        this.fixGradlewExecutableFlag(file2);
        Intrinsics.checkNotNull((Object)rootDirectory);
        if (!GradleProjectImportUtil.canLinkAndRefreshGradleProject$default((String)rootDirectory, (Project)project2, (boolean)false, (int)4, null)) {
            return false;
        }
        GradleProjectImportUtil.linkAndRefreshGradleProject((String)rootDirectory, (Project)project2);
        return false;
    }

    private final File findGradleFile(Module module) {
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            File baseDir;
            Intrinsics.checkNotNullExpressionValue((Object)VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot), (String)"virtualToIoFile(...)");
            File file = new File(baseDir, "build.gradle");
            if (file.exists()) {
                return file;
            }
            file = new File(baseDir, "build.gradle.kts");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private final void fixGradlewExecutableFlag(File containingDir) {
        File toFix = new File(containingDir, "gradlew");
        if (toFix.exists()) {
            toFix.setExecutable(true, false);
        }
    }
}

