/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.DelegateKeyStore;
import com.intellij.execution.rmi.ssl.SslUtil;
import com.intellij.openapi.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class SslTrustStore
extends DelegateKeyStore {
    private static final Logger LOG = Logger.getLogger(SslTrustStore.class.getCanonicalName());
    private static final String NAME = "idea-trust-store";
    private static final List<Pair<String, ? extends Certificate>> ourAdded;
    private int myAdded;

    public SslTrustStore() {
        super(KeyStore.getDefaultType());
    }

    public static String getType() {
        return NAME;
    }

    public static void setDefault() {
        System.setProperty("javax.net.ssl.trustStoreType", NAME);
        if (System.getProperty("javax.net.ssl.trustStore") == null) {
            System.setProperty("javax.net.ssl.trustStore", SslTrustStore.getDefaultKeyStorePath());
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        super.engineLoad(null, null);
    }

    @Override
    protected void validate(KeyStore keyStore) {
        super.validate(keyStore);
        int sz = ourAdded.size();
        for (int i = this.myAdded; i < sz; ++i) {
            Pair<String, ? extends Certificate> cert = ourAdded.get(i);
            try {
                keyStore.setCertificateEntry((String)cert.first, (Certificate)cert.second);
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException(e);
            }
            this.myAdded = i + 1;
        }
    }

    public static int appendUserCert(@NotNull String alias, @NotNull String path) {
        if (alias == null) {
            SslTrustStore.$$$reportNull$$$0(0);
        }
        if (path == null) {
            SslTrustStore.$$$reportNull$$$0(1);
        }
        try {
            List<X509Certificate> certs = SslUtil.loadCertificates(path);
            SslTrustStore.appendCertificates(alias, certs);
            return certs.size();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void appendCertificates(@NotNull String alias, @NotNull Collection<? extends Certificate> certificates) {
        if (alias == null) {
            SslTrustStore.$$$reportNull$$$0(2);
        }
        if (certificates == null) {
            SslTrustStore.$$$reportNull$$$0(3);
        }
        int i = 0;
        for (Certificate certificate : certificates) {
            SslTrustStore.appendCertificate(i == 0 ? alias : alias + "-" + i, certificate);
            ++i;
        }
    }

    public static void appendCertificate(@NotNull String alias, @NotNull Certificate certificate) {
        if (alias == null) {
            SslTrustStore.$$$reportNull$$$0(4);
        }
        if (certificate == null) {
            SslTrustStore.$$$reportNull$$$0(5);
        }
        ourAdded.add(Pair.create(alias, certificate));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Added certificate: " + alias + "\n" + certificate);
        }
    }

    public static int appendUserTrustStore(@NotNull String path, char[] password) {
        if (path == null) {
            SslTrustStore.$$$reportNull$$$0(6);
        }
        try {
            KeyStore tmpStore = SslTrustStore.loadKeyStore(path, password);
            if (tmpStore == null) {
                return 0;
            }
            int cnt = 0;
            Enumeration<String> aliases = tmpStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate certificate = tmpStore.getCertificate(alias);
                if (certificate == null) continue;
                ourAdded.add(Pair.create(alias, certificate));
                ++cnt;
            }
            return cnt;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        ourProvider.setProperty("KeyStore.idea-trust-store", SslTrustStore.class.getName());
        ourAdded = new ArrayList<Pair<String, ? extends Certificate>>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/rmi/ssl/SslTrustStore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "appendUserCert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendCertificates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendCertificate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "appendUserTrustStore";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

