/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/DoWhileGuardElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "guardLabels", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "hasChanges", "", "loopGuardMap", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsDoWhile;", "Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "guardToLoopLabel", "apply", "analyze", "", "findBreakInNestedLoop", "statement", "name", "perform", "js.translator"})
public final class DoWhileGuardElimination {
    @NotNull
    private final JsStatement root;
    @NotNull
    private final Set<JsName> guardLabels;
    private boolean hasChanges;
    @NotNull
    private final Map<JsDoWhile, JsLabel> loopGuardMap;
    @NotNull
    private final Map<JsName, JsName> guardToLoopLabel;

    public DoWhileGuardElimination(@NotNull JsStatement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        this.guardLabels = new LinkedHashSet();
        this.loopGuardMap = new LinkedHashMap();
        this.guardToLoopLabel = new LinkedHashMap();
    }

    public final boolean apply() {
        this.analyze();
        this.perform();
        return this.hasChanges;
    }

    private final void analyze() {
        new RecursiveJsVisitor(this){
            final /* synthetic */ DoWhileGuardElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitLabel(JsLabel x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement statement = x.getStatement();
                if (statement instanceof JsDoWhile) {
                    this.processDoWhile((JsDoWhile)statement, x.getName());
                } else {
                    super.visitLabel(x);
                }
            }

            public void visitDoWhile(JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.processDoWhile(x, null);
            }

            private final void processDoWhile(JsDoWhile x, JsName label) {
                JsStatement body;
                block5: {
                    JsLabel guard;
                    block6: {
                        JsLabel jsLabel;
                        body = x.getBody();
                        JsStatement jsStatement = body;
                        if (jsStatement instanceof JsBlock) {
                            List<JsStatement> list = ((JsBlock)body).getStatements();
                            Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                            JsStatement firstStatement = (JsStatement)CollectionsKt.firstOrNull(list);
                            jsLabel = firstStatement instanceof JsLabel && ((JsBlock)body).getStatements().size() == 1 ? (JsLabel)firstStatement : null;
                        } else {
                            jsLabel = guard = jsStatement instanceof JsLabel ? (JsLabel)body : null;
                        }
                        if (guard == null || guard.getStatement() instanceof JsLoop) break block5;
                        if (label != null) break block6;
                        JsStatement jsStatement2 = guard;
                        JsName jsName = guard.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
                        if (DoWhileGuardElimination.access$findBreakInNestedLoop(this.this$0, jsStatement2, jsName)) break block5;
                    }
                    ((Collection)DoWhileGuardElimination.access$getGuardLabels$p(this.this$0)).add(guard.getName());
                    DoWhileGuardElimination.access$getLoopGuardMap$p(this.this$0).put(x, guard);
                    DoWhileGuardElimination.access$getGuardToLoopLabel$p(this.this$0).put(guard.getName(), label);
                }
                body.accept(this);
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }
        }.accept((JsNode)this.root);
    }

    private final boolean findBreakInNestedLoop(JsStatement statement, JsName name) {
        Ref.BooleanRef result = new Ref.BooleanRef();
        statement.accept(new RecursiveJsVisitor(name, result){
            private int loopLevel;
            final /* synthetic */ JsName $name;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$name = $name;
                this.$result = $result;
            }

            public void visitBreak(JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                HasMetadata hasMetadata = x.getLabel();
                if (hasMetadata == null || (hasMetadata = hasMetadata.getName()) == null) {
                    return;
                }
                HasMetadata guardLabel = hasMetadata;
                if (Intrinsics.areEqual((Object)guardLabel, (Object)this.$name) && this.isInLoop()) {
                    this.$result.element = true;
                }
            }

            private final boolean isInLoop() {
                return this.loopLevel > 0;
            }

            public void visitLoop(JsLoop x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                int n = this.loopLevel;
                this.loopLevel = n + 1;
                super.visitLoop(x);
                n = this.loopLevel;
                this.loopLevel = n + -1;
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            protected void visitElement(JsNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!this.$result.element) {
                    super.visitElement(node);
                }
            }
        });
        return result.element;
    }

    private final void perform() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ DoWhileGuardElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean visit(JsDoWhile x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsLabel jsLabel = (JsLabel)DoWhileGuardElimination.access$getLoopGuardMap$p(this.this$0).get(x);
                if (jsLabel != null) {
                    JsLabel jsLabel2 = jsLabel;
                    DoWhileGuardElimination doWhileGuardElimination = this.this$0;
                    JsLabel guard = jsLabel2;
                    boolean bl = false;
                    if (DoWhileGuardElimination.access$getGuardLabels$p(doWhileGuardElimination).contains(guard.getName())) {
                        x.setBody((JsStatement)this.accept((JsNode)guard.getStatement()));
                        DoWhileGuardElimination.access$setHasChanges$p(doWhileGuardElimination, true);
                        return false;
                    }
                }
                return super.visit(x, ctx);
            }

            public boolean visit(JsBreak x, JsContext<JsNode> ctx) {
                JsName name;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsNameRef jsNameRef = x.getLabel();
                JsName jsName = name = jsNameRef != null ? jsNameRef.getName() : null;
                if (CollectionsKt.contains((Iterable)DoWhileGuardElimination.access$getGuardLabels$p(this.this$0), (Object)name)) {
                    JsName target;
                    JsName jsName2 = target = (JsName)DoWhileGuardElimination.access$getGuardToLoopLabel$p(this.this$0).get(name);
                    ctx.replaceMe((JsNode)new JsContinue(jsName2 != null ? jsName2.makeRef() : null));
                    DoWhileGuardElimination.access$setHasChanges$p(this.this$0, true);
                }
                return false;
            }
        }.accept((JsNode)this.root);
    }

    public static final /* synthetic */ boolean access$findBreakInNestedLoop(DoWhileGuardElimination $this, JsStatement statement, JsName name) {
        return $this.findBreakInNestedLoop(statement, name);
    }

    public static final /* synthetic */ Set access$getGuardLabels$p(DoWhileGuardElimination $this) {
        return $this.guardLabels;
    }

    public static final /* synthetic */ Map access$getLoopGuardMap$p(DoWhileGuardElimination $this) {
        return $this.loopGuardMap;
    }

    public static final /* synthetic */ Map access$getGuardToLoopLabel$p(DoWhileGuardElimination $this) {
        return $this.guardToLoopLabel;
    }

    public static final /* synthetic */ void access$setHasChanges$p(DoWhileGuardElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

