/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\r\u0010\u0013\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0014J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0010H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/highlighter/GroovyHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "psiFile", "Lcom/intellij/psi/PsiFile;", "myGroovyBaseFile", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/psi/PsiFile;Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;Lcom/intellij/openapi/editor/Document;)V", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "getMyGroovyBaseFile", "()Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "myInfos", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "doApplyInformationToEditor", "", "applyInformationInBackground", "applyInformationInBackground$intellij_groovy_psi", "addInfo", "element", "Lcom/intellij/psi/PsiElement;", "attribute", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "info", "intellij.groovy.psi"})
public abstract class GroovyHighlightingPass
extends TextEditorHighlightingPass {
    @NotNull
    private final PsiFile psiFile;
    @NotNull
    private final GroovyFileBase myGroovyBaseFile;
    @NotNull
    private final List<HighlightInfo> myInfos;

    public GroovyHighlightingPass(@NotNull PsiFile psiFile, @NotNull GroovyFileBase myGroovyBaseFile, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)myGroovyBaseFile, (String)"myGroovyBaseFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super(myGroovyBaseFile.getProject(), document);
        this.psiFile = psiFile;
        this.myGroovyBaseFile = myGroovyBaseFile;
        this.myInfos = new ArrayList();
    }

    @NotNull
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    @NotNull
    public final GroovyFileBase getMyGroovyBaseFile() {
        return this.myGroovyBaseFile;
    }

    public void doApplyInformationToEditor() {
    }

    public final void applyInformationInBackground$intellij_groovy_psi() {
        if (this.myInfos.isEmpty()) {
            return;
        }
        BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (PsiFile)this.psiFile, (Document)this.myDocument, (int)0, (int)this.myGroovyBaseFile.getTextLength(), (Collection)this.myInfos, (int)this.getId());
    }

    protected final void addInfo(@NotNull PsiElement element, @NotNull TextAttributesKey attribute) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newHighlightInfo(...)");
            HighlightInfo.Builder builder2 = builder;
            HighlightInfo highlightInfo = builder2.range(element).needsUpdateOnTyping(false).textAttributes(attribute).create();
            if (highlightInfo == null) break block0;
            HighlightInfo it = highlightInfo;
            boolean bl = false;
            this.myInfos.add(it);
        }
    }

    protected final void addInfo(@NotNull HighlightInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.myInfos.add(info);
    }
}

