/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeCopyHandler;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GroovyChangeUtilSupport
implements TreeCopyHandler {
    private static final Key<PsiMember> REFERENCED_MEMBER_KEY = Key.create((String)"REFERENCED_MEMBER_KEY");

    public TreeElement decodeInformation(TreeElement element, Map<Object, Object> decodingState) {
        if (element instanceof CompositeElement && (element.getElementType() == GroovyElementTypes.REFERENCE_ELEMENT || element.getElementType() == GroovyElementTypes.REFERENCE_EXPRESSION)) {
            GrReferenceElement ref2 = (GrReferenceElement)SourceTreeToPsiMap.treeElementToPsi((ASTNode)element);
            PsiMember refMember = (PsiMember)element.getCopyableUserData(REFERENCED_MEMBER_KEY);
            if (refMember != null) {
                element.putCopyableUserData(REFERENCED_MEMBER_KEY, null);
                PsiElement refElement1 = ref2.resolve();
                if (!refMember.getManager().areElementsEquivalent((PsiElement)refMember, refElement1)) {
                    try {
                        if (!(refMember instanceof PsiClass) || ref2.getQualifier() == null) {
                            ref2 = (GrReferenceElement)ref2.bindToElement((PsiElement)refMember);
                        }
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        // empty catch block
                    }
                    return (TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)ref2);
                }
            }
            return element;
        }
        return null;
    }

    public void encodeInformation(TreeElement element, ASTNode original, Map<Object, Object> encodingState) {
        IElementType elementType;
        if (original instanceof CompositeElement && !GroovyChangeUtilSupport.isInsideImport(original) && ((elementType = original.getElementType()) == GroovyElementTypes.REFERENCE_ELEMENT || elementType == GroovyElementTypes.REFERENCE_EXPRESSION)) {
            GroovyResolveResult result2;
            PsiElement target;
            PsiElement psi = original.getPsi();
            Project project = psi.getProject();
            if (!PsiUtil.isThisOrSuperRef(psi) && project.isInitialized() && !DumbService.isDumb((Project)project) && ((target = (result2 = ((GrReferenceElement)psi).advancedResolve()).getElement()) instanceof PsiClass || (target instanceof PsiMethod || target instanceof PsiField) && ((PsiMember)target).hasModifierProperty("static") && result2.getCurrentFileResolveContext() instanceof GrImportStatement)) {
                element.putCopyableUserData(REFERENCED_MEMBER_KEY, (Object)((PsiMember)target));
            }
        }
    }

    private static boolean isInsideImport(ASTNode node) {
        while (node != null && node.getElementType() == GroovyElementTypes.REFERENCE_ELEMENT) {
            node = node.getTreeParent();
        }
        return node != null && node.getElementType() == GroovyStubElementTypes.IMPORT;
    }
}

