/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;

public class VectorBool
extends AbstractList<Boolean>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorBool(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorBool vectorBool) {
        return vectorBool == null ? 0L : vectorBool.swigCPtr;
    }

    protected static long swigRelease(VectorBool vectorBool) {
        long l = 0L;
        if (vectorBool != null) {
            if (!vectorBool.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorBool.swigCPtr;
            vectorBool.swigCMemOwn = false;
            vectorBool.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorBool(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorBool(boolean[] blArray) {
        this();
        this.doReserve(blArray.length);
        for (boolean bl : blArray) {
            this.doAdd(bl);
        }
    }

    public VectorBool(Iterable<Boolean> iterable) {
        this();
        for (boolean bl : iterable) {
            this.doAdd(bl);
        }
    }

    @Override
    public Boolean get(int n) {
        return this.doGet(n);
    }

    @Override
    public Boolean set(int n, Boolean bl) {
        return this.doSet(n, bl);
    }

    @Override
    public boolean add(Boolean bl) {
        ++this.modCount;
        this.doAdd(bl);
        return true;
    }

    @Override
    public void add(int n, Boolean bl) {
        ++this.modCount;
        this.doAdd(n, bl);
    }

    @Override
    public Boolean remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public VectorBool() {
        this(SimpleITKJNI.new_VectorBool__SWIG_0(), true);
    }

    public VectorBool(VectorBool vectorBool) {
        this(SimpleITKJNI.new_VectorBool__SWIG_1(VectorBool.getCPtr(vectorBool), vectorBool), true);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorBool_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorBool_clear(this.swigCPtr, this);
    }

    public VectorBool(int n, boolean bl) {
        this(SimpleITKJNI.new_VectorBool__SWIG_2(n, bl), true);
    }

    private int doCapacity() {
        return SimpleITKJNI.VectorBool_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        SimpleITKJNI.VectorBool_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return SimpleITKJNI.VectorBool_doSize(this.swigCPtr, this);
    }

    private void doAdd(boolean bl) {
        SimpleITKJNI.VectorBool_doAdd__SWIG_0(this.swigCPtr, this, bl);
    }

    private void doAdd(int n, boolean bl) {
        SimpleITKJNI.VectorBool_doAdd__SWIG_1(this.swigCPtr, this, n, bl);
    }

    private boolean doRemove(int n) {
        return SimpleITKJNI.VectorBool_doRemove(this.swigCPtr, this, n);
    }

    private boolean doGet(int n) {
        return SimpleITKJNI.VectorBool_doGet(this.swigCPtr, this, n);
    }

    private boolean doSet(int n, boolean bl) {
        return SimpleITKJNI.VectorBool_doSet(this.swigCPtr, this, n, bl);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorBool_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

