/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Checksum;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PAForUserEnc {
    public final PrincipalName name;
    private final EncryptionKey key;
    public static final String AUTH_PACKAGE = "Kerberos";

    public PAForUserEnc(PrincipalName principalName, EncryptionKey encryptionKey) {
        this.name = principalName;
        this.key = encryptionKey;
    }

    public PAForUserEnc(DerValue derValue, EncryptionKey encryptionKey) throws Asn1Exception, KrbException, IOException {
        Object object;
        DerValue derValue2 = null;
        this.key = encryptionKey;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        PrincipalName principalName = null;
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) == 0) {
            try {
                principalName = new PrincipalName(derValue2.getData().getDerValue(), new Realm("PLACEHOLDER"));
            }
            catch (RealmException realmException) {}
        } else {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) == 1) {
            try {
                object = new Realm(derValue2.getData().getDerValue());
                this.name = new PrincipalName(principalName.getNameType(), principalName.getNameStrings(), (Realm)object);
            }
            catch (RealmException realmException) {
                throw new IOException(realmException);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 2) {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) == 3) {
            object = new KerberosString(derValue2.getData().getDerValue()).toString();
            if (!((String)object).equalsIgnoreCase(AUTH_PACKAGE)) {
                throw new IOException("Incorrect auth-package");
            }
        } else {
            throw new Asn1Exception(906);
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        Object object;
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), this.name.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), this.name.getRealm().asn1Encode());
        try {
            object = new Checksum(-138, this.getS4UByteArray(), this.key, 17);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), ((Checksum)object).asn1Encode());
        }
        catch (KrbException krbException) {
            throw new IOException(krbException);
        }
        object = new DerOutputStream();
        ((DerOutputStream)object).putDerValue(new KerberosString(AUTH_PACKAGE).toDerValue());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), (DerOutputStream)object);
        object = new DerOutputStream();
        ((DerOutputStream)object).write((byte)48, derOutputStream);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public byte[] getS4UByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(new byte[4]);
            for (String string : this.name.getNameStrings()) {
                byteArrayOutputStream.write(string.getBytes("UTF-8"));
            }
            byteArrayOutputStream.write(this.name.getRealm().toString().getBytes("UTF-8"));
            byteArrayOutputStream.write(AUTH_PACKAGE.getBytes("UTF-8"));
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n = this.name.getNameType();
            byArray[0] = (byte)(n & 0xFF);
            byArray[1] = (byte)(n >> 8 & 0xFF);
            byArray[2] = (byte)(n >> 16 & 0xFF);
            byArray[3] = (byte)(n >> 24 & 0xFF);
            return byArray;
        }
        catch (IOException iOException) {
            throw new AssertionError("Cannot write ByteArrayOutputStream", iOException);
        }
    }

    public PrincipalName getName() {
        return this.name;
    }

    public String toString() {
        return "PA-FOR-USER: " + this.name;
    }
}

