/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms.field;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.field.FieldSyntaxVersion;
import org.apache.kafka.connect.transforms.util.Requirements;

public class SingleFieldPath {
    private static final char BACKTICK = '`';
    private static final char DOT = '.';
    private static final char BACKSLASH = '\\';
    private final FieldSyntaxVersion version;
    private final List<String> steps;

    public SingleFieldPath(String pathText, FieldSyntaxVersion version) {
        this.version = version;
        switch (version) {
            case V1: {
                this.steps = Collections.singletonList(pathText);
                break;
            }
            case V2: {
                this.steps = SingleFieldPath.buildFieldPathV2(pathText);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown syntax version: " + String.valueOf((Object)version));
            }
        }
    }

    private static List<String> buildFieldPathV2(String path) {
        ArrayList<CharSequence> steps = new ArrayList<CharSequence>();
        int idx = 0;
        block0: while (idx < path.length() && idx >= 0) {
            CharSequence field;
            if (path.charAt(idx) != '`') {
                int start = idx;
                idx = path.indexOf(String.valueOf('.'), idx);
                if (idx >= 0) {
                    field = path.substring(start, idx);
                    steps.add(field);
                    ++idx;
                    continue;
                }
                field = path.substring(start);
                steps.add(field);
                continue;
            }
            int backtickAt = idx++;
            field = new StringBuilder();
            int start = idx;
            while (true) {
                boolean escaped;
                if ((idx = path.indexOf(String.valueOf('`'), idx)) == -1) {
                    SingleFieldPath.failWhenIncompleteBacktickPair(path, backtickAt);
                }
                boolean bl = escaped = path.charAt(idx - 1) == '\\';
                if (idx >= path.length() - 1) {
                    if (escaped) {
                        SingleFieldPath.failWhenIncompleteBacktickPair(path, backtickAt);
                    }
                    ((StringBuilder)field).append(path, start, idx);
                    steps.add(((StringBuilder)field).toString());
                    ++idx;
                    continue block0;
                }
                if (path.charAt(idx + 1) != '.') {
                    ++idx;
                    continue;
                }
                if (!escaped) break;
                ((StringBuilder)field).append(path, start, idx - 1).append('`');
                start = ++idx;
            }
            ((StringBuilder)field).append(path, start, idx);
            steps.add(((StringBuilder)field).toString());
            idx += 2;
        }
        if (!path.isEmpty() && path.charAt(path.length() - 1) == '.') {
            steps.add("");
        }
        return Collections.unmodifiableList(steps);
    }

    private static void failWhenIncompleteBacktickPair(String path, int backtickAt) {
        throw new ConfigException("Incomplete backtick pair in path: [" + path + "], consider adding a backslash before backtick at position " + backtickAt + " to escape it");
    }

    public Field fieldFrom(Schema schema) {
        if (schema == null) {
            return null;
        }
        Schema current = schema;
        for (String pathSegment : this.stepsWithoutLast()) {
            Field field = current.field(pathSegment);
            if (field != null) {
                current = field.schema();
                continue;
            }
            return null;
        }
        return current.field(this.lastStep());
    }

    public Object valueFrom(Struct struct) {
        return this.valueFrom(struct, true);
    }

    public Object valueFrom(Struct struct, boolean withDefault) {
        if (struct == null) {
            return null;
        }
        Struct current = struct;
        for (String pathSegment : this.stepsWithoutLast()) {
            if (current.schema().field(pathSegment) == null) {
                return null;
            }
            Object subValue = current.get(pathSegment);
            if ((current = Requirements.requireStructOrNull(subValue, "nested field access")) != null) continue;
            return null;
        }
        String lastStep = this.lastStep();
        if (current.schema().field(lastStep) != null) {
            return withDefault ? current.get(lastStep) : current.getWithoutDefault(lastStep);
        }
        return null;
    }

    public Object valueFrom(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Map<String, Object> current = map;
        for (String step : this.stepsWithoutLast()) {
            if ((current = Requirements.requireMapOrNull(current.get(step), "nested field access")) != null) continue;
            return null;
        }
        return current.get(this.lastStep());
    }

    String[] path() {
        return this.steps.toArray(new String[0]);
    }

    private String lastStep() {
        return this.steps.get(this.lastStepIndex());
    }

    private int lastStepIndex() {
        return this.steps.size() - 1;
    }

    private List<String> stepsWithoutLast() {
        return this.steps.subList(0, this.lastStepIndex());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleFieldPath that = (SingleFieldPath)o;
        return Objects.equals(this.steps, that.steps);
    }

    public int hashCode() {
        return Objects.hash(this.steps);
    }

    public String toString() {
        return "SingleFieldPath{version=" + String.valueOf((Object)this.version) + ", path=" + String.join((CharSequence)".", this.steps) + "}";
    }
}

