/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.temperature;

import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.Windows;

public class TemperatureDemo {
    private static final int TEMPERATURE_THRESHOLD = 20;
    private static final int TEMPERATURE_WINDOW_SIZE = 5;

    public static void main(String[] args) {
        Properties props = new Properties();
        props.put("application.id", "streams-temperature");
        props.put("bootstrap.servers", "localhost:9092");
        props.put("default.key.serde", Serdes.StringSerde.class);
        props.put("default.value.serde", Serdes.StringSerde.class);
        props.put("auto.offset.reset", "earliest");
        props.put("statestore.cache.max.bytes", (Object)0);
        Duration duration24Hours = Duration.ofHours(24L);
        StreamsBuilder builder = new StreamsBuilder();
        KStream source = builder.stream("iot-temperature");
        KStream max = source.selectKey((key, value) -> "temp").groupByKey().windowedBy((Windows)TimeWindows.ofSizeAndGrace((Duration)Duration.ofSeconds(5L), (Duration)duration24Hours)).reduce((value1, value2) -> {
            if (Integer.parseInt(value1) > Integer.parseInt(value2)) {
                return value1;
            }
            return value2;
        }).toStream().filter((key, value) -> Integer.parseInt(value) > 20);
        Serde windowedSerde = WindowedSerdes.timeWindowedSerdeFrom(String.class, (long)5L);
        max.to("iot-temperature-max", Produced.with((Serde)windowedSerde, (Serde)Serdes.String()));
        final KafkaStreams streams = new KafkaStreams(builder.build(), props);
        final CountDownLatch latch = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread("streams-temperature-shutdown-hook"){

            @Override
            public void run() {
                streams.close();
                latch.countDown();
            }
        });
        try {
            streams.start();
            latch.await();
        }
        catch (Throwable e) {
            System.exit(1);
        }
        System.exit(0);
    }
}

