/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.dom.saml.v2.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.keycloak.dom.saml.v2.metadata.AdditionalMetadataLocationType;
import org.keycloak.dom.saml.v2.metadata.AffiliationDescriptorType;
import org.keycloak.dom.saml.v2.metadata.AttributeAuthorityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.AuthnAuthorityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.ContactType;
import org.keycloak.dom.saml.v2.metadata.ExtensionsType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.OrganizationType;
import org.keycloak.dom.saml.v2.metadata.PDPDescriptorType;
import org.keycloak.dom.saml.v2.metadata.RoleDescriptorType;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.SSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.TypeWithOtherAttributes;
import org.w3c.dom.Element;

public class EntityDescriptorType
extends TypeWithOtherAttributes {
    protected Element signature;
    protected ExtensionsType extensions;
    protected List<EDTChoiceType> choiceType = new ArrayList<EDTChoiceType>();
    protected OrganizationType organization;
    protected List<ContactType> contactPerson = new ArrayList<ContactType>();
    protected List<AdditionalMetadataLocationType> additionalMetadataLocation = new ArrayList<AdditionalMetadataLocationType>();
    protected String entityID;
    protected XMLGregorianCalendar validUntil;
    protected Duration cacheDuration;
    protected String id;

    public EntityDescriptorType(String entityID) {
        this.entityID = entityID;
    }

    public Element getSignature() {
        return this.signature;
    }

    public void setSignature(Element value) {
        this.signature = value;
    }

    public ExtensionsType getExtensions() {
        return this.extensions;
    }

    public void setExtensions(ExtensionsType value) {
        this.extensions = value;
    }

    public List<EDTChoiceType> getChoiceType() {
        return Collections.unmodifiableList(this.choiceType);
    }

    public void addChoiceType(EDTChoiceType choiceType) {
        this.choiceType.add(choiceType);
    }

    public void removeChoiceType(EDTChoiceType choiceType) {
        this.choiceType.remove(choiceType);
    }

    public OrganizationType getOrganization() {
        return this.organization;
    }

    public void setOrganization(OrganizationType value) {
        this.organization = value;
    }

    public void addContactPerson(ContactType ct) {
        this.contactPerson.add(ct);
    }

    public void removeContactPerson(ContactType ct) {
        this.contactPerson.remove(ct);
    }

    public List<ContactType> getContactPerson() {
        return Collections.unmodifiableList(this.contactPerson);
    }

    public void addAdditionalMetadataLocationType(AdditionalMetadataLocationType amld) {
        this.additionalMetadataLocation.add(amld);
    }

    public void removeAdditionalMetadataLocationType(AdditionalMetadataLocationType amld) {
        this.additionalMetadataLocation.remove(amld);
    }

    public List<AdditionalMetadataLocationType> getAdditionalMetadataLocation() {
        return Collections.unmodifiableList(this.additionalMetadataLocation);
    }

    public String getEntityID() {
        return this.entityID;
    }

    public XMLGregorianCalendar getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(XMLGregorianCalendar value) {
        this.validUntil = value;
    }

    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(Duration value) {
        this.cacheDuration = value;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String value) {
        this.id = value;
    }

    public static class EDTDescriptorChoiceType {
        private RoleDescriptorType roleDescriptor;
        private IDPSSODescriptorType idpDescriptor;
        private SPSSODescriptorType spDescriptor;
        private AuthnAuthorityDescriptorType authnDescriptor;
        private AttributeAuthorityDescriptorType attribDescriptor;
        private PDPDescriptorType pdpDescriptor;

        public EDTDescriptorChoiceType(AuthnAuthorityDescriptorType authnDescriptor) {
            this.authnDescriptor = authnDescriptor;
        }

        public EDTDescriptorChoiceType(AttributeAuthorityDescriptorType attribDescriptor) {
            this.attribDescriptor = attribDescriptor;
        }

        public EDTDescriptorChoiceType(PDPDescriptorType pdpDescriptor) {
            this.pdpDescriptor = pdpDescriptor;
        }

        public EDTDescriptorChoiceType(SSODescriptorType sso) {
            if (sso instanceof IDPSSODescriptorType) {
                this.idpDescriptor = (IDPSSODescriptorType)sso;
            } else {
                this.spDescriptor = (SPSSODescriptorType)sso;
            }
        }

        public EDTDescriptorChoiceType(RoleDescriptorType roleDescriptor) {
            this.roleDescriptor = roleDescriptor;
        }

        public RoleDescriptorType getRoleDescriptor() {
            return this.roleDescriptor;
        }

        public IDPSSODescriptorType getIdpDescriptor() {
            return this.idpDescriptor;
        }

        public SPSSODescriptorType getSpDescriptor() {
            return this.spDescriptor;
        }

        public AuthnAuthorityDescriptorType getAuthnDescriptor() {
            return this.authnDescriptor;
        }

        public AttributeAuthorityDescriptorType getAttribDescriptor() {
            return this.attribDescriptor;
        }

        public PDPDescriptorType getPdpDescriptor() {
            return this.pdpDescriptor;
        }
    }

    public static class EDTChoiceType {
        private List<EDTDescriptorChoiceType> descriptors = new ArrayList<EDTDescriptorChoiceType>();
        private AffiliationDescriptorType affiliationDescriptor;

        public EDTChoiceType(List<EDTDescriptorChoiceType> descriptors) {
            this.descriptors = descriptors;
        }

        public EDTChoiceType(AffiliationDescriptorType affiliationDescriptor) {
            this.affiliationDescriptor = affiliationDescriptor;
        }

        public List<EDTDescriptorChoiceType> getDescriptors() {
            return Collections.unmodifiableList(this.descriptors);
        }

        public AffiliationDescriptorType getAffiliationDescriptor() {
            return this.affiliationDescriptor;
        }

        public static EDTChoiceType oneValue(EDTDescriptorChoiceType edt) {
            ArrayList<EDTDescriptorChoiceType> aList = new ArrayList<EDTDescriptorChoiceType>();
            aList.add(edt);
            return new EDTChoiceType(aList);
        }
    }
}

