/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FindOption;
import java.util.Locale;
import org.hibernate.MappingException;

public enum CacheMode implements FindOption
{
    NORMAL(CacheStoreMode.USE, CacheRetrieveMode.USE),
    IGNORE(CacheStoreMode.BYPASS, CacheRetrieveMode.BYPASS),
    GET(CacheStoreMode.BYPASS, CacheRetrieveMode.USE),
    PUT(CacheStoreMode.USE, CacheRetrieveMode.BYPASS),
    REFRESH(CacheStoreMode.REFRESH, CacheRetrieveMode.BYPASS);

    private final CacheStoreMode storeMode;
    private final CacheRetrieveMode retrieveMode;

    private CacheMode(CacheStoreMode storeMode, CacheRetrieveMode retrieveMode) {
        this.storeMode = storeMode;
        this.retrieveMode = retrieveMode;
    }

    public CacheStoreMode getJpaStoreMode() {
        return this.storeMode;
    }

    public CacheRetrieveMode getJpaRetrieveMode() {
        return this.retrieveMode;
    }

    public boolean isGetEnabled() {
        return this.retrieveMode == CacheRetrieveMode.USE;
    }

    public boolean isPutEnabled() {
        return this.storeMode == CacheStoreMode.USE || this.storeMode == CacheStoreMode.REFRESH;
    }

    public static CacheMode interpretExternalSetting(String setting) {
        if (setting == null) {
            return null;
        }
        try {
            return CacheMode.valueOf(setting.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new MappingException("Unknown Cache Mode: " + setting);
        }
    }

    public static CacheMode fromJpaModes(CacheRetrieveMode retrieveMode, CacheStoreMode storeMode) {
        if (retrieveMode == null && storeMode == null) {
            return null;
        }
        if (storeMode == null) {
            storeMode = CacheStoreMode.BYPASS;
        }
        if (retrieveMode == null) {
            retrieveMode = CacheRetrieveMode.BYPASS;
        }
        return switch (storeMode) {
            default -> throw new IncompatibleClassChangeError();
            case CacheStoreMode.USE -> {
                switch (retrieveMode) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case USE: {
                        yield NORMAL;
                    }
                    case BYPASS: 
                }
                yield PUT;
            }
            case CacheStoreMode.BYPASS -> {
                switch (retrieveMode) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case USE: {
                        yield GET;
                    }
                    case BYPASS: 
                }
                yield IGNORE;
            }
            case CacheStoreMode.REFRESH -> REFRESH;
        };
    }
}

