/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.engine.jdbc.connections.internal.ConnectionValidator;
import org.hibernate.engine.jdbc.connections.internal.PooledConnections;
import org.hibernate.internal.log.ConnectionInfoLogger;

class PoolState
implements Runnable {
    private final ReadWriteLock statelock = new ReentrantReadWriteLock();
    private volatile boolean active = false;
    private ScheduledExecutorService executorService;
    private final PooledConnections pool;
    private final long validationInterval;

    PoolState(PooledConnections pool, long validationInterval) {
        this.pool = pool;
        this.validationInterval = validationInterval;
    }

    private void startIfNeeded() {
        if (this.active) {
            return;
        }
        this.statelock.writeLock().lock();
        try {
            if (this.active) {
                return;
            }
            this.executorService = Executors.newSingleThreadScheduledExecutor(runnable -> {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName("Hibernate Connection Pool Validation Thread");
                return thread;
            });
            this.executorService.scheduleWithFixedDelay(this, this.validationInterval, this.validationInterval, TimeUnit.SECONDS);
            this.active = true;
        }
        finally {
            this.statelock.writeLock().unlock();
        }
    }

    @Override
    public void run() {
        if (this.active) {
            this.pool.validate();
        }
    }

    public PooledConnections getPool() {
        return this.pool;
    }

    void stop() {
        this.statelock.writeLock().lock();
        try {
            if (!this.active) {
                return;
            }
            ConnectionInfoLogger.INSTANCE.cleaningUpConnectionPool(this.pool.getUrl());
            this.active = false;
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
            this.executorService = null;
            try {
                this.pool.close();
            }
            catch (SQLException e) {
                ConnectionInfoLogger.INSTANCE.unableToDestroyConnectionPool(e);
            }
        }
        finally {
            this.statelock.writeLock().unlock();
        }
    }

    Connection getConnection() {
        this.startIfNeeded();
        this.statelock.readLock().lock();
        try {
            Connection connection = this.pool.poll();
            return connection;
        }
        finally {
            this.statelock.readLock().unlock();
        }
    }

    void closeConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        this.startIfNeeded();
        this.statelock.readLock().lock();
        try {
            this.pool.add(conn);
        }
        finally {
            this.statelock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateConnections(ConnectionValidator validator) {
        if (!this.active) {
            return;
        }
        this.statelock.writeLock().lock();
        try {
            RuntimeException ex = null;
            for (Connection connection : this.pool.getAllConnections()) {
                SQLException e = null;
                boolean isValid = false;
                try {
                    isValid = validator.isValid(connection);
                }
                catch (SQLException sqlException) {
                    e = sqlException;
                }
                if (isValid) continue;
                this.pool.closeConnection(connection, e);
                if (ex == null) {
                    ex = new RuntimeException(e);
                    continue;
                }
                if (e == null) continue;
                ex.addSuppressed(e);
            }
            if (ex != null) {
                throw ex;
            }
        }
        finally {
            this.statelock.writeLock().unlock();
        }
    }
}

