/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.ttml.parsers;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mediathek.tool.ttml.ITtmlParser;
import mediathek.tool.ttml.StyledString;
import mediathek.tool.ttml.Subtitle;
import mediathek.tool.ttml.TimedTextMarkupLanguageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EbuTimedTextMarkupLanguageParser
extends TimedTextMarkupLanguageParser
implements ITtmlParser {
    private static final Logger logger = LogManager.getLogger();
    private final Map<String, Integer> regionMap = new HashMap<String, Integer>();
    private final Map<String, Integer> alignMap = new HashMap<String, Integer>();
    private final Map<String, List<String>> colorMap = new HashMap<String, List<String>>();

    protected int convertAlignment(@NotNull String text) {
        return switch (text) {
            case "start", "left" -> -1;
            case "right", "end" -> 1;
            default -> 0;
        };
    }

    protected int convertRegion(@NotNull String text) {
        return switch (text) {
            case "before" -> 8;
            case "center" -> 5;
            default -> 2;
        };
    }

    @Override
    public boolean parse(Path ttmlFilePath) {
        boolean ret;
        logger.trace("Parsing TTML file with EBU parser");
        try {
            this.doc = this.getDocumentBuilder().parse(ttmlFilePath.toFile());
            NodeList metaData = this.doc.getElementsByTagName("ebuttm:documentEbuttVersion");
            if (metaData != null) {
                Node versionNode = metaData.item(0);
                if (versionNode == null || !versionNode.getTextContent().equalsIgnoreCase("v1.0")) {
                    logger.warn("EBU version not found or incorrect version.");
                    return false;
                }
            } else {
                logger.warn("EBU document version tag not found.");
                return false;
            }
            this.buildAlignmentMap();
            this.buildColorMap();
            this.buildRegionMap();
            this.buildFilmList();
            ret = true;
        }
        catch (Exception ex) {
            logger.error("File: {}", (Object)ttmlFilePath, (Object)ex);
            ret = false;
        }
        return ret;
    }

    private void buildRegionMap() {
        NodeList styleData = this.doc.getElementsByTagName("tt:region");
        for (int i = 0; i < styleData.getLength(); ++i) {
            Node subnode = styleData.item(i);
            if (!subnode.hasAttributes()) continue;
            NamedNodeMap attrMap = subnode.getAttributes();
            Node idNode = attrMap.getNamedItem("xml:id");
            Node regionNode = attrMap.getNamedItem("tts:displayAlign");
            if (idNode == null || regionNode == null) continue;
            int region = this.convertRegion(regionNode.getNodeValue());
            this.regionMap.put(idNode.getNodeValue(), region);
        }
    }

    private void buildFilmList() throws Exception {
        NodeList subtitleData = this.doc.getElementsByTagName("tt:p");
        for (int i = 0; i < subtitleData.getLength(); ++i) {
            Node styleNode;
            Subtitle subtitle = new Subtitle();
            Node subnode = subtitleData.item(i);
            if (subnode.hasAttributes()) {
                NamedNodeMap attrMap = subnode.getAttributes();
                Node beginNode = attrMap.getNamedItem("begin");
                Node endNode = attrMap.getNamedItem("end");
                if (beginNode != null && endNode != null) {
                    subtitle.setBegin(this.ttmlFormat.parse(beginNode.getNodeValue()));
                    this.checkHours(subtitle.getBegin());
                    subtitle.setEnd(this.ttmlFormat.parse(endNode.getNodeValue()));
                    this.checkHours(subtitle.getEnd());
                }
                Node regionNode = attrMap.getNamedItem("region");
                styleNode = attrMap.getNamedItem("style");
                Integer alignment = styleNode != null && this.alignMap.containsKey(styleNode.getNodeValue()) ? this.alignMap.get(styleNode.getNodeValue()) : 0;
                Integer region = regionNode != null && this.regionMap.containsKey(regionNode.getNodeValue()) ? this.regionMap.get(regionNode.getNodeValue()) : 2;
                subtitle.setRegion(Integer.toString(alignment + region));
            }
            NodeList childNodes = subnode.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                List<String> colors;
                Node node = childNodes.item(j);
                if (!node.getNodeName().equalsIgnoreCase("tt:span")) continue;
                NamedNodeMap attrMap = node.getAttributes();
                styleNode = attrMap.getNamedItem("style");
                StyledString textContent = new StyledString();
                textContent.setText(node.getTextContent());
                List<String> list = colors = styleNode != null && this.colorMap.containsKey(styleNode.getNodeValue()) ? this.colorMap.get(styleNode.getNodeValue()) : null;
                if (colors == null) {
                    textContent.setColor(this.color);
                    textContent.setBackgroundColor("#000000C2");
                } else {
                    textContent.setColor((String)colors.get(0));
                    textContent.setBackgroundColor(colors.get(1));
                }
                subtitle.getListOfStrings().add(textContent);
            }
            this.subtitleList.add(subtitle);
        }
    }

    @Override
    public void close() {
        super.close();
        this.colorMap.clear();
        this.regionMap.clear();
        this.alignMap.clear();
    }

    private void checkHours(@NotNull Date date) {
        int hours = date.getHours();
        if (hours >= 10) {
            date.setHours(hours - 10);
        }
    }

    private void buildColorMap() {
        NodeList styleData = this.doc.getElementsByTagName("tt:style");
        for (int i = 0; i < styleData.getLength(); ++i) {
            Node subnode = styleData.item(i);
            if (!subnode.hasAttributes()) continue;
            NamedNodeMap attrMap = subnode.getAttributes();
            Node idNode = attrMap.getNamedItem("xml:id");
            Node colorNode = attrMap.getNamedItem("tts:color");
            Node colorBackgroundNode = attrMap.getNamedItem("tts:backgroundColor");
            if (idNode == null || colorNode == null) continue;
            ArrayList<String> colorList = new ArrayList<String>();
            colorList.add(colorNode.getNodeValue());
            if (colorBackgroundNode != null) {
                colorList.add(colorBackgroundNode.getNodeValue());
            } else {
                colorList.add("#000000C2");
            }
            this.colorMap.put(idNode.getNodeValue(), colorList);
        }
    }

    private void buildAlignmentMap() {
        NodeList styleData = this.doc.getElementsByTagName("tt:style");
        for (int i = 0; i < styleData.getLength(); ++i) {
            Node subnode = styleData.item(i);
            if (!subnode.hasAttributes()) continue;
            NamedNodeMap attrMap = subnode.getAttributes();
            Node idNode = attrMap.getNamedItem("xml:id");
            Node alignmentNode = attrMap.getNamedItem("tts:textAlign");
            if (idNode == null || alignmentNode == null) continue;
            int alignment = this.convertAlignment(alignmentNode.getNodeValue());
            this.alignMap.put(idNode.getNodeValue(), alignment);
        }
    }
}

