# Contributing

**Parity** is open source software; contributions from the community are encouraged. Please take a moment to read these guidelines before submitting changes.

### Code style

All PHP code must adhere to the [PSR-2](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md) standard.

### Branching and pull requests

As a guideline, please follow this process:

 1. [Fork the repository](https://help.github.com/articles/fork-a-repo).
 2. Create a topic branch for the change:
    * New features should branch from **develop**.
    * Bug fixes to existing versions should branch from **master**.
    * Please ensure the branch is clearly labelled as a feature or fix.
 3. Make the relevant changes.
 4. [Squash](http://git-scm.com/book/en/Git-Tools-Rewriting-History#Changing-Multiple-Commit-Messages) commits if necessary.
 4. Submit a pull request to the **develop** branch.

Please note this is a general guideline only.
For more information on the branching structure please see the [git-flow cheatsheet](http://danielkummer.github.com/git-flow-cheatsheet/).
