/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.crypto.internal.params.DesParameters;

public class DesEdeParameters {
    public static final int DES_EDE_KEY_LENGTH = 24;

    public static boolean isWeakKey(byte[] byArray, int n, int n2) {
        for (int i = n; i < n2; i += 8) {
            if (!DesParameters.isWeakKey(byArray, i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRealEDEKey(byte[] byArray) {
        return byArray.length == 16 ? DesEdeParameters.isReal2Key(byArray) : DesEdeParameters.isReal3Key(byArray);
    }

    public static boolean isReal2Key(byte[] byArray) {
        boolean bl = false;
        for (int i = 0; i != 8; ++i) {
            if (byArray[i] == byArray[i + 8]) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean isReal3Key(byte[] byArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i != 8; ++i) {
            bl |= byArray[i] != byArray[i + 8];
            bl2 |= byArray[i] != byArray[i + 16];
            bl3 |= byArray[i + 8] != byArray[i + 16];
        }
        return bl && bl2 && bl3;
    }

    public static boolean isActuallyDesKey(byte[] byArray) {
        boolean bl = true;
        if (byArray.length == 16) {
            for (int i = 0; i != 8; ++i) {
                if (byArray[i] == byArray[i + 8]) continue;
                bl = false;
            }
        } else {
            for (int i = 0; i != 8; ++i) {
                if (byArray[i] == byArray[i + 8] && byArray[i + 8] == byArray[i + 16]) continue;
                bl = false;
            }
        }
        return bl;
    }
}

