/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import javax.annotation.Nullable;
import lombok.Generated;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.Bin;

public class RangeBin
extends Bin {
    @Nullable
    private final UnresolvedExpression start;
    @Nullable
    private final UnresolvedExpression end;

    public RangeBin(UnresolvedExpression field, @Nullable String alias, @Nullable UnresolvedExpression start, @Nullable UnresolvedExpression end) {
        super(field, alias);
        this.start = start;
        this.end = end;
        this.validate();
    }

    @Override
    public void validate() {
        if (this.start == null && this.end == null) {
            throw new IllegalArgumentException("At least one of start or end parameter must be specified for range-based binning");
        }
    }

    @Generated
    public static RangeBinBuilder builder() {
        return new RangeBinBuilder();
    }

    @Nullable
    @Generated
    public UnresolvedExpression getStart() {
        return this.start;
    }

    @Nullable
    @Generated
    public UnresolvedExpression getEnd() {
        return this.end;
    }

    @Override
    @Generated
    public String toString() {
        return "RangeBin(super=" + super.toString() + ", start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangeBin)) {
            return false;
        }
        RangeBin other = (RangeBin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnresolvedExpression this$start = this.getStart();
        UnresolvedExpression other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        UnresolvedExpression this$end = this.getEnd();
        UnresolvedExpression other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RangeBin;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UnresolvedExpression $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        UnresolvedExpression $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    @Generated
    public static class RangeBinBuilder {
        @Generated
        private UnresolvedExpression field;
        @Generated
        private String alias;
        @Generated
        private UnresolvedExpression start;
        @Generated
        private UnresolvedExpression end;

        @Generated
        RangeBinBuilder() {
        }

        @Generated
        public RangeBinBuilder field(UnresolvedExpression field) {
            this.field = field;
            return this;
        }

        @Generated
        public RangeBinBuilder alias(@Nullable String alias) {
            this.alias = alias;
            return this;
        }

        @Generated
        public RangeBinBuilder start(@Nullable UnresolvedExpression start) {
            this.start = start;
            return this;
        }

        @Generated
        public RangeBinBuilder end(@Nullable UnresolvedExpression end) {
            this.end = end;
            return this;
        }

        @Generated
        public RangeBin build() {
            return new RangeBin(this.field, this.alias, this.start, this.end);
        }

        @Generated
        public String toString() {
            return "RangeBin.RangeBinBuilder(field=" + String.valueOf(this.field) + ", alias=" + this.alias + ", start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + ")";
        }
    }
}

