/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.transport.memorycontainer.memory.MemoryEvent;

public class MemoryResult
implements ToXContentObject,
Writeable {
    private final String memoryId;
    private final String memory;
    private final MemoryEvent event;
    private final String oldMemory;

    public MemoryResult(String memoryId, String memory, MemoryEvent event, String oldMemory) {
        this.memoryId = memoryId;
        this.memory = memory;
        this.event = event;
        this.oldMemory = oldMemory;
    }

    public MemoryResult(StreamInput in) throws IOException {
        this.memoryId = in.readString();
        this.memory = in.readString();
        this.event = MemoryEvent.fromString(in.readString());
        this.oldMemory = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.memoryId);
        out.writeString(this.memory);
        out.writeString(this.event.getValue());
        out.writeOptionalString(this.oldMemory);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.memoryId);
        builder.field("text", this.memory);
        builder.field("event", this.event.getValue());
        if (this.oldMemory != null) {
            builder.field("old_memory", this.oldMemory);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public static MemoryResultBuilder builder() {
        return new MemoryResultBuilder();
    }

    @Generated
    public String getMemoryId() {
        return this.memoryId;
    }

    @Generated
    public String getMemory() {
        return this.memory;
    }

    @Generated
    public MemoryEvent getEvent() {
        return this.event;
    }

    @Generated
    public String getOldMemory() {
        return this.oldMemory;
    }

    @Generated
    public String toString() {
        return "MemoryResult(memoryId=" + this.getMemoryId() + ", memory=" + this.getMemory() + ", event=" + String.valueOf((Object)this.getEvent()) + ", oldMemory=" + this.getOldMemory() + ")";
    }

    @Generated
    public static class MemoryResultBuilder {
        @Generated
        private String memoryId;
        @Generated
        private String memory;
        @Generated
        private MemoryEvent event;
        @Generated
        private String oldMemory;

        @Generated
        MemoryResultBuilder() {
        }

        @Generated
        public MemoryResultBuilder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        @Generated
        public MemoryResultBuilder memory(String memory) {
            this.memory = memory;
            return this;
        }

        @Generated
        public MemoryResultBuilder event(MemoryEvent event) {
            this.event = event;
            return this;
        }

        @Generated
        public MemoryResultBuilder oldMemory(String oldMemory) {
            this.oldMemory = oldMemory;
            return this;
        }

        @Generated
        public MemoryResult build() {
            return new MemoryResult(this.memoryId, this.memory, this.event, this.oldMemory);
        }

        @Generated
        public String toString() {
            return "MemoryResult.MemoryResultBuilder(memoryId=" + this.memoryId + ", memory=" + this.memory + ", event=" + String.valueOf((Object)this.event) + ", oldMemory=" + this.oldMemory + ")";
        }
    }
}

