
# 11 "plugins/extraction/g_extraction.mlg"
 

open Procq.Prim


# 9 "plugins/extraction/g_extraction.ml"

let _ = Mltop.add_known_module "rocq-runtime.plugins.extraction"

# 19 "plugins/extraction/g_extraction.mlg"
 

(* ML names *)

open Stdarg
open Pp
open Names
open Table
open Extract_env

let pr_mlname s = spc () ++ qs s


# 27 "plugins/extraction/g_extraction.ml"

let (wit_mlname, mlname) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~name:"mlname" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm string)))
       (fun s loc -> 
# 36 "plugins/extraction/g_extraction.mlg"
                     s 
# 39 "plugins/extraction/g_extraction.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm preident)))
      (fun id loc -> 
# 35 "plugins/extraction/g_extraction.mlg"
                        id 
# 46 "plugins/extraction/g_extraction.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 34 "plugins/extraction/g_extraction.mlg"
               pr_mlname 
# 51 "plugins/extraction/g_extraction.ml"
;
    }
let _ = (wit_mlname, mlname)


# 39 "plugins/extraction/g_extraction.mlg"
 

let pr_int_or_id = function
  | ArgInt i -> int i
  | ArgId id -> Id.print id


# 65 "plugins/extraction/g_extraction.ml"

let (wit_int_or_id, int_or_id) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~name:"int_or_id" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm integer)))
       (fun i loc -> 
# 50 "plugins/extraction/g_extraction.mlg"
                      ArgInt i 
# 77 "plugins/extraction/g_extraction.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm preident)))
      (fun id loc -> 
# 49 "plugins/extraction/g_extraction.mlg"
                        ArgId (Id.of_string id) 
# 84 "plugins/extraction/g_extraction.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 48 "plugins/extraction/g_extraction.mlg"
               pr_int_or_id 
# 89 "plugins/extraction/g_extraction.ml"
;
    }
let _ = (wit_int_or_id, int_or_id)


# 53 "plugins/extraction/g_extraction.mlg"
 

let pr_language = function
  | Ocaml -> str "OCaml"
  | Haskell -> str "Haskell"
  | Scheme -> str "Scheme"
  | JSON -> str "JSON"


# 105 "plugins/extraction/g_extraction.ml"

let (wit_language, language) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~name:"language" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next (Procq.Rule.stop)
        ((Procq.Symbol.token (Procq.terminal "JSON"))))
       (fun _ loc -> 
# 68 "plugins/extraction/g_extraction.mlg"
                  JSON 
# 118 "plugins/extraction/g_extraction.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop)
       ((Procq.Symbol.token (Procq.terminal "Scheme"))))
      (fun _ loc -> 
# 67 "plugins/extraction/g_extraction.mlg"
                    Scheme 
# 126 "plugins/extraction/g_extraction.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop)
       ((Procq.Symbol.token (Procq.terminal "Haskell"))))
      (fun _ loc -> 
# 66 "plugins/extraction/g_extraction.mlg"
                     Haskell 
# 134 "plugins/extraction/g_extraction.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop)
       ((Procq.Symbol.token (Procq.terminal "OCaml"))))
      (fun _ loc -> 
# 65 "plugins/extraction/g_extraction.mlg"
                   Ocaml 
# 142 "plugins/extraction/g_extraction.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 64 "plugins/extraction/g_extraction.mlg"
             pr_language 
# 147 "plugins/extraction/g_extraction.ml"
;
    }
let _ = (wit_language, language)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"Extraction" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extraction",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_global),
           Vernacextend.TyNil)),
          (let coqpp_body x () =
            Vernactypes.vtopaqueaccess (fun ~opaque_access -> (
# 75 "plugins/extraction/g_extraction.mlg"
                                  simple_extraction x 
# 163 "plugins/extraction/g_extraction.ml"
)
            ~opaque_access) in fun x ?loc ~atts () ->
            coqpp_body x (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Recursive",
           Vernacextend.TyTerminal
           ("Extraction",
            Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_global)),
            Vernacextend.TyNil))),
          (let coqpp_body l () =
            Vernactypes.vtopaqueaccess (fun ~opaque_access -> (
# 76 "plugins/extraction/g_extraction.mlg"
                                                      full_extraction None l 
# 180 "plugins/extraction/g_extraction.ml"
)
            ~opaque_access) in fun l ?loc ~atts () ->
            coqpp_body l (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extraction",
           Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_string),
           Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_global)),
           Vernacextend.TyNil))),
          (let coqpp_body f l () =
            Vernactypes.vtopaqueaccess (fun ~opaque_access -> (
# 80 "plugins/extraction/g_extraction.mlg"
       full_extraction (Some f) l 
# 196 "plugins/extraction/g_extraction.ml"
)
            ~opaque_access) in fun f l ?loc ~atts () ->
            coqpp_body f l (Attributes.unsupported_attributes atts)),
          None));
         (Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extraction",
           Vernacextend.TyTerminal
           ("TestCompile",
            Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_global)),
            Vernacextend.TyNil))),
          (let coqpp_body l () =
            Vernactypes.vtopaqueaccess (fun ~opaque_access -> (
# 84 "plugins/extraction/g_extraction.mlg"
       extract_and_compile l 
# 213 "plugins/extraction/g_extraction.ml"
)
            ~opaque_access) in fun l ?loc ~atts () ->
            coqpp_body l (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"SeparateExtraction" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Separate",
           Vernacextend.TyTerminal
           ("Extraction",
            Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_global)),
            Vernacextend.TyNil))),
          (let coqpp_body l () =
            Vernactypes.vtopaqueaccess (fun ~opaque_access -> (
# 90 "plugins/extraction/g_extraction.mlg"
       separate_extraction l 
# 232 "plugins/extraction/g_extraction.ml"
)
            ~opaque_access) in fun l ?loc ~atts () ->
            coqpp_body l (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ExtractionLibrary" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extraction",
           Vernacextend.TyTerminal
           ("Library",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
            Vernacextend.TyNil))),
          (let coqpp_body m () =
            Vernactypes.vtopaqueaccess (fun ~opaque_access -> (
# 96 "plugins/extraction/g_extraction.mlg"
       extraction_library false m 
# 251 "plugins/extraction/g_extraction.ml"
)
            ~opaque_access) in fun m ?loc ~atts () ->
            coqpp_body m (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"RecursiveExtractionLibrary" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Recursive",
           Vernacextend.TyTerminal
           ("Extraction",
            Vernacextend.TyTerminal
            ("Library",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_identref),
             Vernacextend.TyNil)))),
          (let coqpp_body m () =
            Vernactypes.vtopaqueaccess (fun ~opaque_access -> (
# 101 "plugins/extraction/g_extraction.mlg"
       extraction_library true m 
# 272 "plugins/extraction/g_extraction.ml"
)
            ~opaque_access) in fun m ?loc ~atts () ->
            coqpp_body m (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ExtractionLanguage" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extraction",
           Vernacextend.TyTerminal
           ("Language",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_language),
            Vernacextend.TyNil))),
          (let coqpp_body l () = Vernactypes.vtdefault (fun () -> 
# 107 "plugins/extraction/g_extraction.mlg"
       extraction_language l 
# 290 "plugins/extraction/g_extraction.ml"
) in
            fun l ?loc ~atts () ->
            coqpp_body l (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ExtractionInline" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extraction",
           Vernacextend.TyTerminal
           ("Inline",
            Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_global)),
            Vernacextend.TyNil))),
          (let coqpp_body l () = Vernactypes.vtdefault (fun () -> 
# 113 "plugins/extraction/g_extraction.mlg"
       extraction_inline true l 
# 308 "plugins/extraction/g_extraction.ml"
) in
            fun l ?loc ~atts () ->
            coqpp_body l (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ExtractionNoInline" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extraction",
           Vernacextend.TyTerminal
           ("NoInline",
            Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_global)),
            Vernacextend.TyNil))),
          (let coqpp_body l () = Vernactypes.vtdefault (fun () -> 
# 118 "plugins/extraction/g_extraction.mlg"
       extraction_inline false l 
# 326 "plugins/extraction/g_extraction.ml"
) in
            fun l ?loc ~atts () ->
            coqpp_body l (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"PrintExtractionInline" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print",
           Vernacextend.TyTerminal
           ("Extraction",
            Vernacextend.TyTerminal ("Inline", Vernacextend.TyNil))),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 123 "plugins/extraction/g_extraction.mlg"
      Feedback.msg_notice (print_extraction_inline ()) 
# 343 "plugins/extraction/g_extraction.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ResetExtractionInline" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Reset",
           Vernacextend.TyTerminal
           ("Extraction",
            Vernacextend.TyTerminal ("Inline", Vernacextend.TyNil))),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 128 "plugins/extraction/g_extraction.mlg"
       reset_extraction_inline () 
# 360 "plugins/extraction/g_extraction.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ExtractionImplicit" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extraction",
           Vernacextend.TyTerminal
           ("Implicit",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_global),
            Vernacextend.TyTerminal
            ("[",
             Vernacextend.TyNonTerminal (Extend.TUlist0 (Extend.TUentry (Genarg.get_arg_tag wit_int_or_id)),
             Vernacextend.TyTerminal ("]", Vernacextend.TyNil)))))),
          (let coqpp_body r l () = Vernactypes.vtdefault (fun () -> 
# 134 "plugins/extraction/g_extraction.mlg"
       extraction_implicit r l 
# 381 "plugins/extraction/g_extraction.ml"
) in
            fun r l ?loc ~atts () ->
            coqpp_body r l (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ExtractionBlacklist" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extraction",
           Vernacextend.TyTerminal
           ("Blacklist",
            Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_preident)),
            Vernacextend.TyNil))),
          (let coqpp_body l () = Vernactypes.vtdefault (fun () -> 
# 140 "plugins/extraction/g_extraction.mlg"
       extraction_blacklist l 
# 399 "plugins/extraction/g_extraction.ml"
) in
            fun l ?loc ~atts () ->
            coqpp_body l (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"PrintExtractionBlacklist" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print",
           Vernacextend.TyTerminal
           ("Extraction",
            Vernacextend.TyTerminal ("Blacklist", Vernacextend.TyNil))),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 145 "plugins/extraction/g_extraction.mlg"
       Feedback.msg_notice (print_extraction_blacklist ()) 
# 416 "plugins/extraction/g_extraction.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ResetExtractionBlacklist" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Reset",
           Vernacextend.TyTerminal
           ("Extraction",
            Vernacextend.TyTerminal ("Blacklist", Vernacextend.TyNil))),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 150 "plugins/extraction/g_extraction.mlg"
       reset_extraction_blacklist () 
# 433 "plugins/extraction/g_extraction.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ExtractionCallback" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extract",
           Vernacextend.TyTerminal
           ("Callback",
            Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_string)),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_global),
            Vernacextend.TyNil)))),
          (let coqpp_body o x () = Vernactypes.vtdefault (fun () -> 
# 158 "plugins/extraction/g_extraction.mlg"
       extract_callback o x 
# 452 "plugins/extraction/g_extraction.ml"
) in
            fun o x ?loc ~atts () ->
            coqpp_body o x (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"PrintExtractionCallback" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print",
           Vernacextend.TyTerminal
           ("Extraction",
            Vernacextend.TyTerminal ("Callback", Vernacextend.TyNil))),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 163 "plugins/extraction/g_extraction.mlg"
      Feedback.msg_notice (print_extraction_callback ()) 
# 469 "plugins/extraction/g_extraction.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ResetExtractionCallback" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Reset",
           Vernacextend.TyTerminal
           ("Extraction",
            Vernacextend.TyTerminal ("Callback", Vernacextend.TyNil))),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 168 "plugins/extraction/g_extraction.mlg"
       reset_extraction_callback () 
# 486 "plugins/extraction/g_extraction.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"PrintExtractionForeign" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print",
           Vernacextend.TyTerminal
           ("Extraction",
            Vernacextend.TyTerminal ("Foreign", Vernacextend.TyNil))),
          (let coqpp_body () = Vernactypes.vtdefault (fun () -> 
# 174 "plugins/extraction/g_extraction.mlg"
      Feedback.msg_notice (print_extraction_foreign ()) 
# 503 "plugins/extraction/g_extraction.ml"
) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ExtractionConstant" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extract",
           Vernacextend.TyTerminal
           ("Constant",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_global),
            Vernacextend.TyNonTerminal (Extend.TUlist0 (Extend.TUentry (Genarg.get_arg_tag wit_string)),
            Vernacextend.TyTerminal
            ("=>",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_mlname),
             Vernacextend.TyNil)))))),
          (let coqpp_body x idl y () = Vernactypes.vtdefault (fun () -> 
# 187 "plugins/extraction/g_extraction.mlg"
       extract_constant_inline false x idl y 
# 525 "plugins/extraction/g_extraction.ml"
) in
            fun x idl y ?loc ~atts () ->
            coqpp_body x idl y (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ExtractionForeignConstant" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extract",
           Vernacextend.TyTerminal
           ("Foreign",
            Vernacextend.TyTerminal
            ("Constant",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_global),
             Vernacextend.TyTerminal
             ("=>",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_string),
              Vernacextend.TyNil)))))),
          (let coqpp_body x y () = Vernactypes.vtdefault (fun () -> 
# 193 "plugins/extraction/g_extraction.mlg"
       extract_constant_foreign x y 
# 548 "plugins/extraction/g_extraction.ml"
) in
            fun x y ?loc ~atts () ->
            coqpp_body x y (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ExtractionInlinedConstant" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extract",
           Vernacextend.TyTerminal
           ("Inlined",
            Vernacextend.TyTerminal
            ("Constant",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_global),
             Vernacextend.TyTerminal
             ("=>",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_mlname),
              Vernacextend.TyNil)))))),
          (let coqpp_body x y () = Vernactypes.vtdefault (fun () -> 
# 198 "plugins/extraction/g_extraction.mlg"
       extract_constant_inline true x [] y 
# 571 "plugins/extraction/g_extraction.ml"
) in
            fun x y ?loc ~atts () ->
            coqpp_body x y (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ExtractionInductive" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Extract",
           Vernacextend.TyTerminal
           ("Inductive",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_global),
            Vernacextend.TyTerminal
            ("=>",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_mlname),
             Vernacextend.TyTerminal
             ("[",
              Vernacextend.TyNonTerminal (Extend.TUlist0 (Extend.TUentry (Genarg.get_arg_tag wit_mlname)),
              Vernacextend.TyTerminal
              ("]",
               Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_string)),
               Vernacextend.TyNil))))))))),
          (let coqpp_body x id idl o () =
            Vernactypes.vtdefault (fun () -> 
# 204 "plugins/extraction/g_extraction.mlg"
       extract_inductive x id idl o 
# 599 "plugins/extraction/g_extraction.ml"
) in
            fun x id idl o ?loc ~atts () ->
            coqpp_body x id idl o (Attributes.unsupported_attributes atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.extraction") ~command:"ShowExtraction" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Show",
           Vernacextend.TyTerminal ("Extraction", Vernacextend.TyNil)),
          (let coqpp_body () =
            Vernactypes.vtreadproof (fun ~pstate -> (
# 210 "plugins/extraction/g_extraction.mlg"
       show_extraction 
# 615 "plugins/extraction/g_extraction.ml"
) ~pstate) in
            fun ?loc ~atts () ->
            coqpp_body (Attributes.unsupported_attributes atts)),
          None))]

