﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/iotevents-data/IoTEventsData_EXPORTS.h>
#include <aws/iotevents-data/model/BatchAlarmActionErrorEntry.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTEventsData {
namespace Model {
class BatchDisableAlarmResult {
 public:
  AWS_IOTEVENTSDATA_API BatchDisableAlarmResult() = default;
  AWS_IOTEVENTSDATA_API BatchDisableAlarmResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTEVENTSDATA_API BatchDisableAlarmResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of errors associated with the request, or <code>null</code> if there
   * are no errors. Each error entry contains an entry ID that helps you identify the
   * entry that failed.</p>
   */
  inline const Aws::Vector<BatchAlarmActionErrorEntry>& GetErrorEntries() const { return m_errorEntries; }
  template <typename ErrorEntriesT = Aws::Vector<BatchAlarmActionErrorEntry>>
  void SetErrorEntries(ErrorEntriesT&& value) {
    m_errorEntriesHasBeenSet = true;
    m_errorEntries = std::forward<ErrorEntriesT>(value);
  }
  template <typename ErrorEntriesT = Aws::Vector<BatchAlarmActionErrorEntry>>
  BatchDisableAlarmResult& WithErrorEntries(ErrorEntriesT&& value) {
    SetErrorEntries(std::forward<ErrorEntriesT>(value));
    return *this;
  }
  template <typename ErrorEntriesT = BatchAlarmActionErrorEntry>
  BatchDisableAlarmResult& AddErrorEntries(ErrorEntriesT&& value) {
    m_errorEntriesHasBeenSet = true;
    m_errorEntries.emplace_back(std::forward<ErrorEntriesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  BatchDisableAlarmResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<BatchAlarmActionErrorEntry> m_errorEntries;

  Aws::String m_requestId;
  bool m_errorEntriesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTEventsData
}  // namespace Aws
