/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngineMessages;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessParameter;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ProcessRunner {
    private ProcessParameter[] params = new ProcessParameter[0];

    void setProcessParameters(ProcessParameter[] params) {
        this.params = params == null ? new ProcessParameter[]{} : params;
    }

    public ProcessParameter[] getProcessParameters() {
        return this.params;
    }

    protected ProcessFailureException missingArgException(String processId, String varname) {
        String msg = MessageFormat.format((String)TemplateEngineMessages.ProcessRunner_missingArg, (Object[])new Object[]{varname});
        return new ProcessFailureException(this.getProcessMessage(processId, 4, msg));
    }

    protected final boolean areArgumentsMatchingRequiredParameters(ProcessArgument[] args) {
        if (this.params == null && args != null || this.params != null && args == null) {
            return false;
        }
        if (this.params == null && args == null) {
            return true;
        }
        if (this.params.length != args.length) {
            return false;
        }
        int i = 0;
        while (i < this.params.length) {
            if (!args[i].isOfParameterType(this.params[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getArgumentsMismatchMessage(ProcessArgument[] args) {
        if (this.params == null && args != null) {
            return TemplateEngineMessages.getString("ProcessRunner.unexpectedArguments");
        }
        if (this.params != null && args == null) {
            return TemplateEngineMessages.getString("ProcessRunner.missingArguments");
        }
        if (this.params == null && args == null) {
            return null;
        }
        if (this.params.length != args.length) {
            return TemplateEngineMessages.getString("ProcessRunner.missingArguments");
        }
        int i = 0;
        while (i < this.params.length) {
            ProcessArgument arg = args[i];
            ProcessParameter param = this.params[i];
            if (!arg.isOfParameterType(param)) {
                return String.valueOf(TemplateEngineMessages.getString("ProcessRunner.argumentsMismatch")) + arg.getName();
            }
            ++i;
        }
        return null;
    }

    protected final String getProcessMessage(String processId, int code, String msg) {
        switch (code) {
            case 4: {
                return String.valueOf(processId) + TemplateEngineMessages.getString("ProcessRunner.error") + msg;
            }
            case 0: {
                return String.valueOf(processId) + TemplateEngineMessages.getString("ProcessRunner.success") + msg;
            }
        }
        return String.valueOf(processId) + TemplateEngineMessages.getString("ProcessRunner.info") + msg;
    }

    public abstract void process(TemplateCore var1, ProcessArgument[] var2, String var3, IProgressMonitor var4) throws ProcessFailureException;
}

