/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPTypedef
extends PlatformObject
implements ITypedef,
ITypeContainer,
ICPPInternalBinding {
    private IASTName[] declarations;
    private IType type;

    public CPPTypedef(IASTName name) {
        if (name != null && name.getParent() instanceof ICPPASTQualifiedName) {
            name = (IASTName)name.getParent();
        }
        this.declarations = new IASTName[]{name};
        if (name != null) {
            name.setBinding(this);
        }
    }

    @Override
    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    @Override
    public IASTNode getDefinition() {
        return this.declarations[0];
    }

    @Override
    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            IType t = this.getType();
            if (t != null) {
                return t.isSameType(((ITypedef)o).getType());
            }
            return false;
        }
        IType t = this.getType();
        if (t != null) {
            return t.isSameType(o);
        }
        return false;
    }

    @Override
    public IType getType() {
        if (this.type == null) {
            this.type = CPPVisitor.createType((IASTDeclarator)this.declarations[0].getParent());
        }
        return this.type;
    }

    @Override
    public void setType(IType t) {
        this.type = t;
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        return this.declarations[0].getSimpleID();
    }

    @Override
    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.declarations[0].getParent());
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    @Override
    public void addDefinition(IASTNode node) {
        this.addDeclaration(node);
    }

    @Override
    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = node.getParent() instanceof ICPPASTQualifiedName ? (IASTName)node.getParent() : (IASTName)node;
        this.declarations = this.declarations == null ? new IASTName[]{name} : (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? ArrayUtil.prepend(IASTName.class, this.declarations, name) : ArrayUtil.append(IASTName.class, this.declarations, name));
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        if (this.declarations != null && this.declarations.length > 0) {
            return CPPVisitor.findDeclarationOwner(this.declarations[0], true);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(ASTTypeUtil.getQualifiedName(this)) + " -> " + ASTTypeUtil.getType(this, true);
    }
}

