/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug;

import org.eclipse.cdt.utils.debug.DebugArrayType;
import org.eclipse.cdt.utils.debug.DebugBaseType;
import org.eclipse.cdt.utils.debug.DebugCrossRefType;
import org.eclipse.cdt.utils.debug.DebugDerivedType;
import org.eclipse.cdt.utils.debug.DebugEnumField;
import org.eclipse.cdt.utils.debug.DebugEnumType;
import org.eclipse.cdt.utils.debug.DebugField;
import org.eclipse.cdt.utils.debug.DebugFunctionType;
import org.eclipse.cdt.utils.debug.DebugPointerType;
import org.eclipse.cdt.utils.debug.DebugReferenceType;
import org.eclipse.cdt.utils.debug.DebugStructType;
import org.eclipse.cdt.utils.debug.DebugUnknownType;

public class DebugType {
    protected DebugType() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this instanceof DebugArrayType) {
            DebugArrayType arrayType = (DebugArrayType)this;
            int size = arrayType.getSize();
            DebugType type = arrayType.getComponentType();
            sb.append(type.toString());
            sb.append(" [").append(size).append(']');
        } else if (this instanceof DebugDerivedType) {
            DebugDerivedType derived = (DebugDerivedType)this;
            DebugType component = derived.getComponentType();
            if (component instanceof DebugStructType) {
                DebugStructType structType = (DebugStructType)component;
                sb.append(structType.getName());
            } else if (component != null) {
                sb.append(component.toString());
            }
            if (this instanceof DebugPointerType) {
                sb.append(" *");
            } else if (this instanceof DebugReferenceType) {
                sb.append(" &");
            } else if (this instanceof DebugCrossRefType && component == null) {
                DebugCrossRefType crossRef = (DebugCrossRefType)this;
                sb.append(crossRef.getCrossRefName());
            }
        } else if (this instanceof DebugBaseType) {
            DebugBaseType base = (DebugBaseType)this;
            String typeName = base.getTypeName();
            sb.append(typeName);
        } else if (this instanceof DebugFunctionType) {
            DebugFunctionType function = (DebugFunctionType)this;
            DebugType type = function.getReturnType();
            sb.append(type.toString());
            sb.append(" (*())");
        } else if (this instanceof DebugEnumType) {
            DebugEnumType enumarator = (DebugEnumType)this;
            DebugEnumField[] fields = enumarator.getDebugEnumFields();
            sb.append("enum ").append(enumarator.getName()).append(" {");
            int i = 0;
            while (i < fields.length) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(' ').append(fields[i].getName());
                sb.append(" = ").append(fields[i].getValue());
                ++i;
            }
            sb.append(" }");
        } else if (this instanceof DebugStructType) {
            DebugStructType struct = (DebugStructType)this;
            if (struct.isUnion()) {
                sb.append("union ");
            } else {
                sb.append("struct ");
            }
            sb.append(struct.getName()).append(" {");
            DebugField[] fields = struct.getDebugFields();
            int i = 0;
            while (i < fields.length) {
                if (i > 0) {
                    sb.append(';');
                }
                sb.append(' ').append(fields[i].getDebugType());
                sb.append(' ').append(fields[i].getName());
                ++i;
            }
            sb.append(" }");
        } else if (this instanceof DebugUnknownType) {
            DebugUnknownType unknown = (DebugUnknownType)this;
            sb.append(unknown.getName());
        }
        return sb.toString();
    }
}

