/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.macho;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.macho.ERandomAccessFile;

public class AR {
    protected String filename;
    protected ERandomAccessFile efile;
    protected long strtbl_pos = -1L;
    private ARHeader[] headers;

    public void dispose() {
        try {
            if (this.efile != null) {
                this.efile.close();
                this.efile = null;
            }
        }
        catch (IOException iOException) {}
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public static boolean isARHeader(byte[] ident) {
        return ident != null && ident.length >= 7 && ident[0] == 33 && ident[1] == 60 && ident[2] == 97 && ident[3] == 114 && ident[4] == 99 && ident[5] == 104 && ident[6] == 62;
    }

    public AR(String filename) throws IOException {
        this.filename = filename;
        this.efile = new ERandomAccessFile(filename, "r");
        String hdr = this.efile.readLine();
        if (hdr == null || hdr.compareTo("!<arch>") != 0) {
            this.efile.close();
            throw new IOException(CCorePlugin.getResourceString("Util.exception.invalidArchive"));
        }
    }

    private void loadHeaders() throws IOException {
        if (this.headers != null) {
            return;
        }
        Vector<ARHeader> v = new Vector<ARHeader>();
        try {
            while (this.efile.getFilePointer() < this.efile.length()) {
                ARHeader header = new ARHeader();
                header.getObjectName();
                long pos = this.efile.getFilePointer();
                v.add(header);
                if ((pos += header.getSize()) % 2L != 0L) {
                    ++pos;
                }
                this.efile.seek(pos);
            }
        }
        catch (IOException iOException) {}
        this.headers = v.toArray(new ARHeader[0]);
    }

    public ARHeader[] getHeaders() throws IOException {
        this.loadHeaders();
        return this.headers;
    }

    private boolean stringInStrings(String str, String[] set) {
        String[] stringArray = set;
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (str.compareTo(element) == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String[] extractFiles(String outdir, String[] names) throws IOException {
        Vector<String> names_used = new Vector<String>();
        this.loadHeaders();
        int count = 0;
        ARHeader[] aRHeaderArray = this.headers;
        int n = this.headers.length;
        int n2 = 0;
        while (n2 < n) {
            ARHeader header = aRHeaderArray[n2];
            String object_name = header.getObjectName();
            if (names == null || this.stringInStrings(object_name, names)) {
                object_name = count + "_" + object_name;
                ++count;
                byte[] data = header.getObjectData();
                File output = new File(outdir, object_name);
                names_used.add(object_name);
                RandomAccessFile rfile = new RandomAccessFile(output, "rw");
                rfile.write(data);
                rfile.close();
            }
            ++n2;
        }
        return names_used.toArray(new String[0]);
    }

    public String[] extractFiles(String outdir) throws IOException {
        return this.extractFiles(outdir, null);
    }

    public class ARHeader {
        private String object_name;
        private long size;
        private long macho_offset;

        private String removeBlanks(String str) {
            while (str.charAt(str.length() - 1) == ' ') {
                str = str.substring(0, str.length() - 1);
            }
            return str;
        }

        public ARHeader() throws IOException {
            int len;
            byte[] object_name = new byte[16];
            byte[] modification_time = new byte[12];
            byte[] uid = new byte[6];
            byte[] gid = new byte[6];
            byte[] mode = new byte[8];
            byte[] size = new byte[10];
            byte[] trailer = new byte[2];
            AR.this.efile.read(object_name);
            AR.this.efile.read(modification_time);
            AR.this.efile.read(uid);
            AR.this.efile.read(gid);
            AR.this.efile.read(mode);
            AR.this.efile.read(size);
            AR.this.efile.read(trailer);
            this.macho_offset = AR.this.efile.getFilePointer();
            this.object_name = this.removeBlanks(new String(object_name));
            this.size = Long.parseLong(this.removeBlanks(new String(size)));
            if (this.object_name.length() > 3 && this.object_name.charAt(0) == '#' && this.object_name.charAt(1) == '1' && this.object_name.charAt(2) == '/') {
                try {
                    len = Integer.parseInt(this.object_name.substring(3));
                    byte[] real_name = new byte[len];
                    AR.this.efile.read(real_name);
                    this.object_name = new String(real_name);
                    long pos = AR.this.efile.getFilePointer();
                    AR.this.efile.seek(this.macho_offset);
                    this.macho_offset = pos;
                }
                catch (Exception exception) {}
            }
            if ((len = this.object_name.length()) > 2 && this.object_name.charAt(len - 1) == '/') {
                this.object_name = this.object_name.substring(0, len - 1);
            }
        }

        public String getObjectName() {
            return this.object_name;
        }

        public long getSize() {
            return this.size;
        }

        public String getArchiveName() {
            return AR.this.filename;
        }

        public long getObjectDataOffset() throws IOException {
            return this.macho_offset;
        }

        public byte[] getObjectData() throws IOException {
            byte[] temp = new byte[(int)this.size];
            if (AR.this.efile != null) {
                AR.this.efile.seek(this.macho_offset);
                AR.this.efile.read(temp);
            } else {
                AR.this.efile = new ERandomAccessFile(AR.this.filename, "r");
                AR.this.efile.seek(this.macho_offset);
                AR.this.efile.read(temp);
                AR.this.efile.close();
                AR.this.efile = null;
            }
            return temp;
        }
    }
}

