/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.ExprManagerUtil;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;

public class ExprManager {
    private List bindingExprs = new ArrayList();
    private Map autoBindingExprMap = new HashMap();
    private Map autoBindingMap;
    private int entryLevel = 0;
    private IBaseQueryDefinition baseQueryDefn;
    private ScriptContext context;
    public static final int OVERALL_GROUP = 0;

    public ExprManager(IBaseQueryDefinition baseQueryDefn, ScriptContext cx) {
        this.baseQueryDefn = baseQueryDefn;
        this.autoBindingMap = new HashMap();
        this.context = cx;
    }

    public void addBindingExpr(String groupKey, Map resultsExprMap, int groupLevel) {
        if (resultsExprMap == null) {
            return;
        }
        this.bindingExprs.add(new GroupBindingColumn(groupKey, groupLevel, resultsExprMap));
    }

    void addAutoBindingExpr(String name, IBaseExpression baseExpr) {
        this.autoBindingExprMap.put(name, baseExpr);
        this.autoBindingMap.put(name, new Binding(name, baseExpr));
    }

    public IBaseExpression getExpr(String name) throws DataException {
        IBaseExpression baseExpr = this.getBindingExpr(name);
        if (baseExpr == null) {
            baseExpr = this.getAutoBindingExpr(name);
        }
        return baseExpr;
    }

    public IBinding getBinding(String name) throws DataException {
        int i = 0;
        while (i < this.bindingExprs.size()) {
            GroupBindingColumn gcb = (GroupBindingColumn)this.bindingExprs.get(i);
            if ((this.entryLevel == 0 || gcb.getGroupLevel() <= this.entryLevel) && gcb.getBinding(name) != null) {
                return gcb.getBinding(name);
            }
            ++i;
        }
        if (this.autoBindingMap.containsKey(name)) {
            return (IBinding)this.autoBindingMap.get(name);
        }
        return null;
    }

    private IBaseExpression getBindingExpr(String name) throws DataException {
        int i = 0;
        while (i < this.bindingExprs.size()) {
            IBaseExpression o;
            GroupBindingColumn gcb = (GroupBindingColumn)this.bindingExprs.get(i);
            if ((this.entryLevel == 0 || gcb.getGroupLevel() <= this.entryLevel) && (o = gcb.getExpression(name)) != null) {
                return o;
            }
            ++i;
        }
        return null;
    }

    IScriptExpression getAutoBindingExpr(String name) {
        return (IScriptExpression)this.autoBindingExprMap.get(name);
    }

    public List getBindingExprs() {
        return this.bindingExprs;
    }

    public Map getAutoBindingExprMap() {
        return this.autoBindingExprMap;
    }

    void setEntryGroupLevel(int i) {
        this.entryLevel = i;
    }

    public void validateColumnBinding() throws DataException {
        ExprManagerUtil.validateColumnBinding(this, this.baseQueryDefn, this.context);
    }
}

