/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.fs;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.OS;
import com.nvidia.viper.Activator;
import com.nvidia.viper.FileUtils;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.TemporaryDirs;
import com.nvidia.viper.ViewUtils;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.ViperRunMode;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.fs.LocalSystemDevicesData;
import com.nvidia.viper.jni.NativeUtils;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.run.NvprofResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.console.ConsoleView;

public final class LocalFileSystem
extends FileSystem {
    private IDevicesData deviceData = new LocalSystemDevicesData();
    private boolean nvprofWarning = false;

    @Override
    public String browseForDirectory(Shell shell, String title, String prompt, String value) {
        DirectoryDialog fd = new DirectoryDialog(shell, 69632);
        fd.setText(title);
        fd.setMessage(prompt);
        if (value != null) {
            fd.setFilterPath(value);
        }
        return fd.open();
    }

    public static String browseForFileOpen(Shell shell, String title, String setFileName, String prefKey) {
        FileDialog fd = new FileDialog(shell, 69632);
        return LocalFileSystem.getFilePath(title, setFileName, prefKey, fd);
    }

    public static String browseForSessionFileOpen(Shell shell) {
        FileDialog fd = new FileDialog(shell, 69632);
        fd.setFilterExtensions(new String[]{"*" + Viper.SESSION_FILE_EXT, "*"});
        fd.setFilterNames(new String[]{Viper.NVVP_FILE_TYPE, "All Files"});
        return LocalFileSystem.getFilePath("Open Session", null, "OpenDialogPath", fd);
    }

    private static String getFilePath(String title, String setFileName, String prefKey, FileDialog fd) {
        Path path;
        String filename;
        String preferencePath;
        fd.setText(title);
        fd.setFileName(setFileName);
        if (StringUtils.emptyToNull(prefKey) != null && StringUtils.emptyToNull(preferencePath = Activator.getDefault().getPreferenceStore().getString(prefKey)) != null) {
            fd.setFilterPath(preferencePath);
        }
        if (StringUtils.emptyToNull(filename = fd.open()) != null && (path = new Path(filename)).toFile().exists()) {
            Activator.getDefault().getPreferenceStore().setValue(prefKey, path.removeLastSegments(1).toOSString());
        }
        return filename;
    }

    public static String browseForFileSave(Shell shell, String title, String setFileName, String prefKey) {
        FileDialog fd = new FileDialog(shell, 73728);
        fd.setOverwrite(true);
        return LocalFileSystem.getFilePath(title, setFileName, prefKey, fd);
    }

    public static String browseForNvvpFileSave(Shell shell, String title, String setFileName, String prefKey) {
        return LocalFileSystem.browseForFileSave(shell, title, setFileName, prefKey, Viper.NVVP_FILE_TYPE, Viper.SESSION_FILE_EXT);
    }

    public static String browseForPDFFileSave(Shell shell, String title, String setFileName, String prefKey) {
        String[] fileNameSegments = setFileName.split("[(]");
        String fileName = fileNameSegments[0] != null ? fileNameSegments[0] : "";
        return LocalFileSystem.browseForFileSave(shell, title, fileName, prefKey, Viper.PDF_FILE_TYPE, ".pdf");
    }

    private static String browseForFileSave(Shell shell, String title, String setFileName, String prefKey, String fileType, String fileExtension) {
        FileDialog fd = new FileDialog(shell, 73728);
        fd.setOverwrite(true);
        fd.setFilterExtensions(new String[]{"*" + fileExtension, "*.*"});
        fd.setFilterNames(new String[]{fileType, "All Files"});
        String filename = LocalFileSystem.getFilePath(title, setFileName, prefKey, fd);
        if (filename != null && !filename.endsWith(fileExtension)) {
            filename = filename.concat(fileExtension);
        }
        return filename;
    }

    @Override
    public String browseForFile(Shell shell, String title, String prompt, String value) {
        FileDialog fd = new FileDialog(shell, 69632);
        fd.setText(title);
        if (value != null) {
            fd.setFilterPath(value);
        }
        return fd.open();
    }

    @Override
    public String[] browseForFileMulti(Shell shell, String title, String prompt, String value) throws CoreException {
        String filePath;
        FileDialog fd = new FileDialog(shell, 69634);
        fd.setText(title);
        if (value != null) {
            fd.setFilterPath(value);
        }
        if ((filePath = fd.open()) != null && !filePath.isEmpty()) {
            String[] filenames = fd.getFileNames();
            String[] filepaths = new String[filenames.length];
            String filedir = new Path(filePath).removeLastSegments(1).toOSString();
            int i = 0;
            while (i < filenames.length) {
                IPath path = new Path(filedir).append(filenames[i]);
                filepaths[i] = path.toOSString();
                ++i;
            }
            return filepaths;
        }
        return null;
    }

    @Override
    public void connect(IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("Connecting...", 1);
            monitor.worked(1);
            monitor.done();
        }
    }

    @Override
    public IDevicesData getDeviceData(boolean longRunning) {
        return this.deviceData;
    }

    @Override
    public String getName() {
        return "Local";
    }

    public ILaunchConfiguration getRebelLaunchConfiguration(Executable executable, String profilerArguments, IPath profileFile) throws CoreException, ViperException {
        Map<String, String> env;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        File rebelCmd = NativeUtils.findRebelExecutableInToolkit(Viper.REBEL_COMMAND_LINE_EXE);
        if (rebelCmd == null || !rebelCmd.exists()) {
            String fileExt = OS.local().equals((Object)OS.Windows) ? ".bat" : "";
            rebelCmd = FileUtils.findExecutableOnPath(Viper.REBEL_COMMAND_LINE_EXE, fileExt);
        }
        if (rebelCmd == null || !rebelCmd.exists()) {
            throw new ViperException(String.format(ViperMessages.ErrorExeNotInPath, Viper.REBEL_COMMAND_LINE_EXE));
        }
        String toolPath = rebelCmd.getAbsolutePath();
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, ICudaToolkit.Tool.RebelCmdLine.name());
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", toolPath);
        String strCWD = executable.getWorkingDir();
        if (strCWD == null && executable.getFilename() != null) {
            Path filePath = new Path(executable.getFilename());
            filePath = filePath.removeLastSegments(1);
            strCWD = filePath.toOSString();
        }
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", strCWD);
        workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        String args = String.valueOf(profilerArguments) + " -o " + "\"" + profileFile.toOSString() + "\"";
        args = String.valueOf(args) + " \"" + executable.getFilename() + "\"";
        if (executable.getArgs() != null) {
            args = String.valueOf(args) + " " + executable.getArgs();
        }
        if (args != null) {
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
        }
        if ((env = executable.getEnv()) != null) {
            workingCopy.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, env);
        }
        workingCopy.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        return workingCopy;
    }

    public ILaunchConfiguration getNvprofLaunchConfiguration(Executable executable, String profilerArguments, IPath profileFile) throws CoreException {
        Map<String, String> env;
        String toolPath;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        File nvprofFile = NativeUtils.getTool(ICudaToolkit.Tool.Nvprof);
        if (executable.isMPI()) {
            toolPath = new File(executable.getMPILauncher()).getAbsolutePath();
            profilerArguments = String.valueOf(executable.getMPIArg()) + " " + nvprofFile.getAbsolutePath() + " " + profilerArguments;
        } else {
            toolPath = nvprofFile.getAbsolutePath();
        }
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, ICudaToolkit.Tool.Nvprof.name());
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", toolPath);
        String strCWD = executable.getWorkingDir();
        if (strCWD == null && executable.getFilename() != null) {
            Path filePath = new Path(executable.getFilename());
            filePath = filePath.removeLastSegments(1);
            strCWD = filePath.toOSString();
        }
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", strCWD);
        workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        IPath logFile = profileFile.removeLastSegments(1);
        logFile = logFile.append(this.getNvprofLogFileName(executable));
        String args = String.valueOf(profilerArguments) + " -o " + "\"" + profileFile.toOSString() + "\"";
        if (!executable.isProfileAllProcesses()) {
            args = String.valueOf(args) + " --log-file-verbose \"" + logFile.toOSString() + "\"";
            args = String.valueOf(args) + " \"" + executable.getFilename() + "\"";
            if (executable.getArgs() != null) {
                args = String.valueOf(args) + " " + executable.getArgs();
            }
        }
        if (args != null) {
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
        }
        if ((env = executable.getEnv()) != null) {
            workingCopy.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, env);
        }
        workingCopy.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        return workingCopy;
    }

    public int getNvprofResult(ILaunch launch) throws ViperException {
        IProcess[] process;
        int retval = NvprofResult.NVPROF_SUCCESS.getCode();
        IProcess[] iProcessArray = process = launch.getProcesses();
        int n = process.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess iProcess = iProcessArray[n2];
            try {
                retval = iProcess.getExitValue();
                if (NvprofResult.NVPROF_SUCCESS.getCode() != retval) {
                    break;
                }
            }
            catch (Exception e) {
                if (ViperRunMode.getRunMode() == ViperRunMode.RunMode.TEST) {
                    System.out.println("failed to get nvprof return value");
                }
                ViperRunMode.setLastNvprofResult(null);
                throw new ViperException("nvprof unknown error", e);
            }
            ++n2;
        }
        return retval;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isExistingDirectory(String path) {
        return new File(path).isDirectory();
    }

    @Override
    public boolean isExistingFile(String path) {
        if (new File(path).isFile()) {
            return true;
        }
        IPath ipath = CoreUtil.getFileOnPath((String)path);
        return ipath != null;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isRunnable(String filename) {
        if (filename != null) {
            File file = new File(filename);
            return file.canExecute();
        }
        return false;
    }

    @Override
    public boolean isTimestampChanged(String path, long lastModifiedTime) {
        File file = new File(path);
        return file.exists() && file.lastModified() != lastModifiedTime;
    }

    @Override
    public File[] runNvprof(Executable executable, String profilerArguments, String outputFile, IProgressMonitor monitor) throws CoreException, ViperException {
        File[] files;
        IPath profileFolder = TemporaryDirs.launches.newSubfolder();
        IPath profilePath = profileFolder.append(outputFile);
        ILaunchConfiguration workingCopy = this.getNvprofLaunchConfiguration(executable, profilerArguments, profilePath);
        ILaunch launch = workingCopy.launch("run", monitor);
        this.waitForProcessCompletion(launch, monitor, 0);
        if (executable.isProfileAllProcesses() && monitor.isCanceled()) {
            monitor.setCanceled(false);
        }
        if (monitor.isCanceled()) {
            return null;
        }
        if (launch.getProcesses().length == 0) {
            throw new ViperException("Unable to create process");
        }
        this.createNvprofLogLink(profileFolder, executable);
        if (!executable.isProfileAllProcesses() && !executable.isMPI()) {
            this.checkNvprofErrorCode(this.getNvprofResult(launch));
        }
        if (executable != null && executable.isMultiProcess()) {
            File dir = profileFolder.toFile();
            String filePrefix = "api_";
            if (executable.isMPI()) {
                try {
                    filePrefix = String.valueOf(filePrefix) + InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    ViperExceptionHandler.logError(e.getMessage());
                }
            }
            FilterLogFile filter = new FilterLogFile(filePrefix);
            files = dir.listFiles(filter);
        } else {
            files = new File[]{profilePath.toFile()};
        }
        return files;
    }

    private void addConsoleDocumentListener(final ProcessConsole console, final String path) {
        console.getDocument().addPrenotifiedDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                IDocument doc = event.getDocument();
                FindReplaceDocumentAdapter fir = new FindReplaceDocumentAdapter(doc);
                IRegion reg = null;
                try {
                    reg = fir.find(0, "^nvprof log:.*$", true, true, false, true);
                }
                catch (BadLocationException e) {
                    ViperExceptionHandler.logError(e.getMessage());
                }
                if (reg == null) {
                    return;
                }
                int lineOffset = reg.getOffset();
                int lineLength = reg.getLength();
                IHyperlink fileLink = console.getHyperlink(lineOffset);
                if (fileLink != null) {
                    return;
                }
                fileLink = new ConsoleLogFileHyperlink(path);
                try {
                    console.addHyperlink(fileLink, lineOffset, lineLength);
                }
                catch (BadLocationException e) {
                    ViperExceptionHandler.logError(e.getMessage());
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    private void createNvprofLogLink(IPath profileFolder, Executable executable) {
        File[] files;
        if (executable != null && executable.isMultiProcess()) {
            File dir = profileFolder.toFile();
            FilterLogFile filter = new FilterLogFile("nvprof_");
            files = dir.listFiles(filter);
        } else {
            IPath profilePath = profileFolder.append(this.getNvprofLogFileName(null));
            files = new File[]{profilePath.toFile()};
        }
        ConsoleView consoleView = ViewUtils.findConsoleInDisplayThread();
        final IConsole console = consoleView.getConsole();
        this.nvprofWarning = false;
        int i = 0;
        while (i < files.length) {
            final File file = files[i];
            if (console != null && console instanceof ProcessConsole && file != null && file.exists()) {
                this.addConsoleDocumentListener((ProcessConsole)console, file.getAbsolutePath());
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String currentLine;
                            BufferedReader reader = new BufferedReader(new FileReader(file));
                            IOConsoleOutputStream stream = ((ProcessConsole)console).newOutputStream();
                            while ((currentLine = reader.readLine()) != null) {
                                if (currentLine.indexOf("Warning:") != -1 || currentLine.indexOf("Error:") != -1) {
                                    stream.setColor(ColorConstants.red);
                                    stream.write(String.valueOf(currentLine) + "\n");
                                    boolean status = currentLine.indexOf("Error:") == -1;
                                    LocalFileSystem.this.setNvprofWarningStatus(status);
                                }
                                if (ViperRunMode.getRunMode() != ViperRunMode.RunMode.TEST) continue;
                                System.out.println(currentLine);
                            }
                            stream.close();
                        }
                        catch (IOException e) {
                            ViperExceptionHandler.logError(e.getMessage());
                        }
                    }
                });
            }
            ++i;
        }
    }

    private synchronized void setNvprofWarningStatus(boolean status) {
        this.nvprofWarning = status;
    }

    protected void waitForProcessCompletion(final ILaunch launch, IProgressMonitor monitor, int timeOut) {
        IProcess[] processes;
        Timer timer = null;
        if (timeOut > 0) {
            timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    IProcess[] processes = launch.getProcesses();
                    try {
                        IProcess[] iProcessArray = processes;
                        int n = processes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProcess process = iProcessArray[n2];
                            process.terminate();
                            ++n2;
                        }
                    }
                    catch (DebugException e) {
                        ViperExceptionHandler.logError("Unable to terminate process", e);
                    }
                }
            }, timeOut * 1000);
        }
        IProcess[] iProcessArray = processes = launch.getProcesses();
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess process = iProcessArray[n2];
            while (!process.isTerminated()) {
                try {
                    if (monitor.isCanceled()) {
                        process.terminate();
                        break;
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    ViperExceptionHandler.logError("Unable to sleep thread", e);
                }
                catch (DebugException e) {
                    ViperExceptionHandler.logError("Unable to terminate process", e);
                }
            }
            ++n2;
        }
        if (timer != null) {
            timer.cancel();
        }
    }

    @Override
    public synchronized boolean readAndResetNvprofWarningStatus() {
        if (!this.nvprofWarning) {
            return false;
        }
        this.nvprofWarning = false;
        return true;
    }

    @Override
    public boolean isCustomScript() {
        return false;
    }

    @Override
    public File runRebelCommandLine(Executable executable, String profilerArguments, String outputFile, IProgressMonitor monitor) throws CoreException, ViperException {
        IPath profileFolder = TemporaryDirs.launches.newSubfolder();
        IPath profilePath = profileFolder.append(String.valueOf(outputFile) + Viper.REBEL_COMMAND_LINE_EXT);
        ILaunchConfiguration workingCopy = this.getRebelLaunchConfiguration(executable, profilerArguments, profilePath);
        ILaunch launch = workingCopy.launch("run", monitor);
        this.waitForProcessCompletion(launch, monitor, 0);
        if (monitor.isCanceled()) {
            return null;
        }
        IProcess[] process = launch.getProcesses();
        if (process == null || process.length == 0) {
            throw new ViperException(String.format("Unable to create process %s", Viper.REBEL_COMMAND_LINE_EXE));
        }
        IProcess[] iProcessArray = process;
        int n = process.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess iProcess = iProcessArray[n2];
            int retval = iProcess.getExitValue();
            if (retval != 0) {
                throw new ViperException(String.format("%s failed with error code %d", Viper.REBEL_COMMAND_LINE_EXE, retval));
            }
            ++n2;
        }
        return profilePath.toFile();
    }

    private class ConsoleLogFileHyperlink
    implements IHyperlink {
        String fFilePath;

        ConsoleLogFileHyperlink(String filePath) {
            this.fFilePath = filePath;
        }

        public void linkActivated() {
            File file = new File(this.fFilePath);
            if (file != null && file.exists()) {
                try {
                    IFileStore fileStore = EFS.getStore((URI)file.toURI());
                    FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    activePage.openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor", true);
                }
                catch (CoreException e1) {
                    ViperExceptionHandler.logError(e1.getMessage());
                }
            }
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }
    }

    private class FilterLogFile
    implements FileFilter {
        private String fileNamePrefix;

        FilterLogFile(String fileNamePrefix) {
            this.fileNamePrefix = fileNamePrefix;
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().startsWith(this.fileNamePrefix);
        }
    }
}

