/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.activity.CuptiActivityAPI;
import com.nvidia.viper.activity.CuptiActivityEnvironment;
import com.nvidia.viper.activity.CuptiActivityKernel;
import com.nvidia.viper.activity.CuptiActivityMarker;
import com.nvidia.viper.activity.CuptiActivityMarkerData;
import com.nvidia.viper.activity.CuptiActivityMemcpy;
import com.nvidia.viper.activity.CuptiActivityMemset;
import com.nvidia.viper.activity.CuptiActivityOpenAcc;
import com.nvidia.viper.activity.CuptiActivityOpenMP;
import com.nvidia.viper.activity.CuptiActivityOverhead;
import com.nvidia.viper.activity.CuptiActivityUvmCounter;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.activity.PThreadActivity;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.TimelineIntervalAPI;
import com.nvidia.viper.model.TimelineIntervalBase;
import com.nvidia.viper.model.TimelineIntervalEnvironment;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalMarker;
import com.nvidia.viper.model.TimelineIntervalMemcpy;
import com.nvidia.viper.model.TimelineIntervalMemset;
import com.nvidia.viper.model.TimelineIntervalOpenAcc;
import com.nvidia.viper.model.TimelineIntervalOpenMP;
import com.nvidia.viper.model.TimelineIntervalOverhead;
import com.nvidia.viper.model.TimelineIntervalPThread;
import com.nvidia.viper.model.TimelineIntervalRange;
import com.nvidia.viper.model.TimelineIntervalUVM;

public class TimelineIntervalFactory {
    public static ITimelineInterval buildInterval(ICuptiActivity activity, ICuptiActivity aux, ICuptiActivity endActivity) {
        if (activity == null) {
            return null;
        }
        if (!activity.isValid()) {
            return null;
        }
        TimelineIntervalBase interval = null;
        switch (activity.getKind()) {
            case CUPTI_ACTIVITY_KIND_INVALID: 
            case CUPTI_ACTIVITY_KIND_EVENT: 
            case CUPTI_ACTIVITY_KIND_METRIC: 
            case CUPTI_ACTIVITY_KIND_DEVICE: 
            case CUPTI_ACTIVITY_KIND_CONTEXT: 
            case CUPTI_ACTIVITY_KIND_NAME: 
            case CUPTI_ACTIVITY_KIND_MARKER_DATA: 
            case CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR: 
            case CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS: 
            case CUPTI_ACTIVITY_KIND_BRANCH: 
            case CUPTI_ACTIVITY_KIND_PREEMPTION: 
            case CUPTI_ACTIVITY_KIND_EVENT_INSTANCE: 
            case CUPTI_ACTIVITY_KIND_METRIC_INSTANCE: 
            case CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION: 
            case CUPTI_ACTIVITY_KIND_FUNCTION: 
            case CUPTI_ACTIVITY_KIND_MODULE: 
            case CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE: 
            case CUPTI_ACTIVITY_KIND_SHARED_ACCESS: {
                break;
            }
            case CUPTI_ACTIVITY_KIND_UVM_COUNTER: {
                TimelineIntervalKind intervalKind;
                CuptiActivityUvmCounter uvmCounter = (CuptiActivityUvmCounter)activity;
                switch (uvmCounter.getUvmCounterKind()) {
                    case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD: {
                        intervalKind = TimelineIntervalKind.UVM_MEMCPY_HTOD;
                        break;
                    }
                    case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH: {
                        intervalKind = TimelineIntervalKind.UVM_MEMCPY_DTOH;
                        break;
                    }
                    case CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOD: {
                        intervalKind = TimelineIntervalKind.UVM_MEMCPY_DTOD;
                        break;
                    }
                    case CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT: {
                        intervalKind = TimelineIntervalKind.UVM_PAGE_FAULT;
                        break;
                    }
                    case CUPTI_ACTIVITY_UVM_COUNTER_KIND_GPU_PAGE_FAULT_COUNT: {
                        intervalKind = TimelineIntervalKind.UVM_GPU_PAGE_FAULT;
                        break;
                    }
                    case CUPTI_ACTIVITY_UVM_COUNTER_KIND_PAGE_THROTTLING: {
                        intervalKind = TimelineIntervalKind.UVM_PAGE_THROTTLING;
                        break;
                    }
                    case CUPTI_ACTIVITY_UVM_COUNTER_KIND_THRASHING: {
                        intervalKind = TimelineIntervalKind.UVM_THRASHING;
                        break;
                    }
                    case CUPTI_ACTIVITY_UVM_COUNTER_KIND_REMOTE_MAP: {
                        intervalKind = TimelineIntervalKind.UVM_REMOTE_MAP;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (uvmCounter.isNew()) {
                    interval = new TimelineIntervalUVM(intervalKind, uvmCounter);
                    break;
                }
                CuptiActivityUvmCounter endCounter = (CuptiActivityUvmCounter)endActivity;
                if (endCounter == null) {
                    return null;
                }
                interval = new TimelineIntervalUVM(intervalKind, uvmCounter.getID(), uvmCounter.timestamp, endCounter.timestamp, endCounter.value - uvmCounter.value, uvmCounter.processId);
                break;
            }
            case CUPTI_ACTIVITY_KIND_KERNEL: 
            case CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL: 
            case CUPTI_ACTIVITY_KIND_CDP_KERNEL: {
                interval = new TimelineIntervalKernel((CuptiActivityKernel)activity);
                break;
            }
            case CUPTI_ACTIVITY_KIND_DRIVER: {
                interval = new TimelineIntervalAPI(TimelineIntervalKind.DRIVER, (CuptiActivityAPI)activity);
                break;
            }
            case CUPTI_ACTIVITY_KIND_ENVIRONMENT: {
                interval = new TimelineIntervalEnvironment((CuptiActivityEnvironment)activity);
                break;
            }
            case CUPTI_ACTIVITY_KIND_MARKER: {
                if (endActivity instanceof CuptiActivityMarker) {
                    interval = new TimelineIntervalRange((CuptiActivityMarker)activity, (CuptiActivityMarker)endActivity, (CuptiActivityMarkerData)aux);
                    break;
                }
                interval = new TimelineIntervalMarker((CuptiActivityMarker)activity, (CuptiActivityMarkerData)aux);
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMCPY: {
                CuptiActivityMemcpy memcpy = (CuptiActivityMemcpy)activity;
                switch (memcpy.getCopyKind()) {
                    case CUPTI_ACTIVITY_MEMCPY_KIND_DTOH: 
                    case CUPTI_ACTIVITY_MEMCPY_KIND_ATOH: {
                        interval = new TimelineIntervalMemcpy(TimelineIntervalKind.MEMCPY_DTOH, memcpy);
                        break;
                    }
                    case CUPTI_ACTIVITY_MEMCPY_KIND_HTOD: 
                    case CUPTI_ACTIVITY_MEMCPY_KIND_HTOA: {
                        interval = new TimelineIntervalMemcpy(TimelineIntervalKind.MEMCPY_HTOD, memcpy);
                        break;
                    }
                    case CUPTI_ACTIVITY_MEMCPY_KIND_ATOA: 
                    case CUPTI_ACTIVITY_MEMCPY_KIND_ATOD: 
                    case CUPTI_ACTIVITY_MEMCPY_KIND_DTOA: 
                    case CUPTI_ACTIVITY_MEMCPY_KIND_DTOD: {
                        interval = new TimelineIntervalMemcpy(TimelineIntervalKind.MEMCPY_DTOD, memcpy);
                        break;
                    }
                    case CUPTI_ACTIVITY_MEMCPY_KIND_HTOH: {
                        break;
                    }
                }
            }
            case CUPTI_ACTIVITY_KIND_MEMCPY2: {
                interval = new TimelineIntervalMemcpy(TimelineIntervalKind.MEMCPY_PTOP, (CuptiActivityMemcpy)activity);
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMSET: {
                interval = new TimelineIntervalMemset((CuptiActivityMemset)activity);
                break;
            }
            case CUPTI_ACTIVITY_KIND_OVERHEAD: {
                interval = new TimelineIntervalOverhead((CuptiActivityOverhead)activity);
                break;
            }
            case CUPTI_ACTIVITY_KIND_PC_SAMPLING: 
            case CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO: {
                break;
            }
            case CUPTI_ACTIVITY_KIND_RUNTIME: {
                interval = new TimelineIntervalAPI(TimelineIntervalKind.RUNTIME, (CuptiActivityAPI)activity);
                break;
            }
            case CUPTI_ACTIVITY_KIND_OPENACC_DATA: 
            case CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH: 
            case CUPTI_ACTIVITY_KIND_OPENACC_OTHER: {
                interval = new TimelineIntervalOpenAcc(TimelineIntervalKind.OPENACC, (CuptiActivityOpenAcc)activity);
                break;
            }
            case CUPTI_ACTIVITY_KIND_PTHREAD: {
                interval = new TimelineIntervalPThread(TimelineIntervalKind.PTHREAD, (PThreadActivity)activity);
                break;
            }
            case CUPTI_ACTIVITY_KIND_OPENMP: {
                interval = new TimelineIntervalOpenMP(TimelineIntervalKind.OPENMP, (CuptiActivityOpenMP)activity);
                break;
            }
        }
        return interval;
    }
}

