/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityOpenAcc;
import com.nvidia.viper.activity.CuptiOpenAccConstructKind;
import com.nvidia.viper.activity.CuptiOpenAccEventKind;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKind;
import java.util.Set;

public class TimelineIntervalOpenAcc
extends TimelineIntervalHierarchy
implements IModel,
ITimelineInterval {
    protected CuptiActivityOpenAcc activity;

    public TimelineIntervalOpenAcc(TimelineIntervalKind kind, CuptiActivityOpenAcc activity) {
        super(kind, activity.start, activity.end, activity.getID());
        this.activity = activity;
        this.primaryTimeline = null;
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.activity.getName();
    }

    @Override
    public Set<Integer> getCorrelationIds() {
        return this.activity.correlations;
    }

    public boolean isOpenAccDataInterval() {
        return this.activity.isOpenAccData();
    }

    public boolean isOpenAccLaunchInterval() {
        return this.activity.isOpenAccLaunch();
    }

    public boolean isOpenAccOtherInterval() {
        return this.activity.isOpenAccOther();
    }

    @Override
    public ViperColors.GradientColors getColor(ViperColors.GradientColors colors) {
        if (this.isOpenAccDataInterval()) {
            return ViperColors.INTERVAL_OPENACC_DATA_COLORS;
        }
        if (this.isOpenAccLaunchInterval()) {
            return ViperColors.INTERVAL_OPENACC_LAUNCH_COLORS;
        }
        if (this.isOpenAccOtherInterval()) {
            return ViperColors.INTERVAL_OPENACC_OTHER_COLORS;
        }
        return null;
    }

    public long getExternalId() {
        return this.activity.externalId;
    }

    public String getEventKind() {
        return CuptiActivityOpenAcc.getCuptiEventName(CuptiOpenAccEventKind.valueOf(this.activity.eventKind));
    }

    public String getParentConstruct() {
        return CuptiActivityOpenAcc.getCuptiConstructName(CuptiOpenAccConstructKind.valueOf(this.activity.parentConstruct));
    }

    public int getVersion() {
        return this.activity.version;
    }

    public boolean getImplicit() {
        return this.activity.implicit == 1;
    }

    public String getDeviceType() {
        return CuptiActivityOpenAcc.getOpenAccDeviceTypeName(this.activity.deviceType);
    }

    public int getDeviceNumber() {
        return this.activity.deviceNumber;
    }

    public int getThreadId() {
        return this.activity.threadId;
    }

    public long getAsync() {
        return this.activity.async;
    }

    public long getAsyncMap() {
        return this.activity.asyncMap;
    }

    public int getLineNo() {
        return this.activity.lineNo;
    }

    public int getEndLineNo() {
        return this.activity.endLineNo;
    }

    public int getFuncLineNo() {
        return this.activity.funcLineNo;
    }

    public int getFuncEndLineNo() {
        return this.activity.funcEndLineNo;
    }

    public int getCuDeviceId() {
        return this.activity.cuDeviceId;
    }

    public int getCuContextId() {
        return this.activity.cuContextId;
    }

    public int getCuStreamId() {
        return this.activity.cuStreamId;
    }

    public int getCuProcessId() {
        return this.activity.cuProcessId;
    }

    public int getCuThreadId() {
        return this.activity.cuThreadId;
    }

    public String getRelativeFilePath() {
        return this.activity.getRelativePath();
    }

    public String getFullFilePath() {
        return this.activity.srcFile;
    }

    public String getFuncName() {
        return this.activity.funcName;
    }

    public long getNumGangs() {
        return this.activity.numGangs;
    }

    public long getNumWorkers() {
        return this.activity.numWorkers;
    }

    public long getVectorLength() {
        return this.activity.vectorLength;
    }

    public String getKernelName() {
        return this.activity.kernelName;
    }

    public long getBytes() {
        return this.activity.bytes;
    }

    public long getHostPtr() {
        return this.activity.hostPtr;
    }

    public long getDevicePtr() {
        return this.activity.devicePtr;
    }

    public String getVarName() {
        return this.activity.varName;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.activity.appendToPDM(pdm.getNativeHandle());
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }
}

