/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.TimeFormatter;
import com.nvidia.viper.jni.OpenMPAggregate;
import com.nvidia.viper.ui.OpenMPLabelType;
import java.text.NumberFormat;
import org.eclipse.jface.viewers.ColumnLabelProvider;

public class OpenMPLabelProvider
extends ColumnLabelProvider {
    private OpenMPLabelType contentType;
    private static NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    private static TimeFormatter numberFormatter = new TimeFormatter();

    static {
        numberFormatter.setFractionDigits(5);
        percentFormatter.setMaximumFractionDigits(3);
        percentFormatter.setGroupingUsed(false);
    }

    public OpenMPLabelProvider(OpenMPLabelType type) {
        this.contentType = type;
    }

    public String getText(Object element) {
        if (element instanceof OpenMPAggregate) {
            OpenMPAggregate aggreate = (OpenMPAggregate)element;
            switch (this.contentType) {
                case name: {
                    return aggreate.getName();
                }
                case percentage: {
                    return percentFormatter.format((double)aggreate.getInclusiveTime() / (double)aggreate.getTotalTime());
                }
                case totalTime: {
                    return numberFormatter.format(aggreate.getInclusiveTime(), true);
                }
                case calls: {
                    return new Long(aggreate.getCalls()).toString();
                }
            }
            return "";
        }
        return "";
    }

    public String getTitle() {
        switch (this.contentType) {
            case name: {
                return "Name";
            }
            case percentage: {
                return "%";
            }
            case totalTime: {
                return "Time";
            }
            case calls: {
                return "Calls";
            }
        }
        return "";
    }
}

