/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.actions.ReportGenerationAction;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.expertsystem.ExpertSystemStepAction;
import com.nvidia.viper.expertsystem.IExpertSystemStage;
import com.nvidia.viper.fs.LocalFileSystem;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.analysis.GuidedAnalysisStageControl;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.nebula.widgets.pshelf.AbstractRenderer;
import org.eclipse.nebula.widgets.pshelf.PShelf;
import org.eclipse.nebula.widgets.pshelf.PShelfItem;
import org.eclipse.nebula.widgets.pshelf.RedmondShelfRenderer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class GuidedAnalysisComposite
extends Composite {
    private static final String ENABLED_REPORTGEN_TOOLTIP = "Generate a PDF report of the selected kernel";
    private static final String DISABLED_REPORTGEN_TOOLTIP = "Select a kernel and perform analysis to generate a report";
    private ExpertSystem viperExpertSystem;
    private final ToolItem reportGeneration;
    private final PShelf shelf;

    public GuidedAnalysisComposite(Composite buttonsParent, final Composite outlineParent, int style) {
        super(outlineParent, style);
        this.setLayout((Layout)new FillLayout(256));
        this.shelf = new PShelf((Composite)this, 0);
        this.shelf.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PShelfItem item;
                GuidedAnalysisStageControl stageControl;
                if (e != null && e.item instanceof PShelfItem && (stageControl = (GuidedAnalysisStageControl)((Object)(item = (PShelfItem)e.item).getData())) != null && GuidedAnalysisComposite.this.viperExpertSystem != null) {
                    IExpertSystemStage stage = stageControl.getExpertSystemStage();
                    new ExpertSystemStepAction(stage.getStageKind()).perform(GuidedAnalysisComposite.this.viperExpertSystem.getSession());
                }
            }
        });
        RedmondShelfRenderer renderer = new RedmondShelfRenderer();
        this.shelf.setRenderer((AbstractRenderer)renderer);
        renderer.setHoverGradient1(renderer.getGradient1());
        renderer.setHoverGradient2(renderer.getGradient1());
        renderer.setHoverForeground(renderer.getForeground());
        renderer.setSelectedGradient1(renderer.getSelectedGradient2());
        renderer.setGradient1(renderer.getSelectedGradient2());
        renderer.setGradient2(renderer.getSelectedGradient2());
        renderer.setForeground(renderer.getSelectedForeground());
        ToolBar buttonComposite = new ToolBar(buttonsParent, 131072);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        GridLayout bgl = new GridLayout(1, true);
        bgl.marginWidth = 0;
        bgl.marginHeight = 0;
        buttonComposite.setLayout((Layout)bgl);
        this.reportGeneration = new ToolItem(buttonComposite, 0);
        this.reportGeneration.setText("Export PDF Report");
        this.reportGeneration.setImage(ViperImages.get("icons/en/run_analysis.png"));
        this.reportGeneration.setEnabled(false);
        this.reportGeneration.setToolTipText(DISABLED_REPORTGEN_TOOLTIP);
        this.registerReportButtonVisibility();
        this.reportGeneration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimelineIntervalKernel kernel = AnalysisStage.getAnalysisHostLaunchedKernel(GuidedAnalysisComposite.this.viperExpertSystem.getSession());
                GC gc = new GC((Drawable)outlineParent);
                String pdfFileName = LocalFileSystem.browseForPDFFileSave(GuidedAnalysisComposite.this.getShell(), "Save As PDF", kernel.getDisplayName(), "SaveAsPdfPath");
                if (pdfFileName != null) {
                    String outputFileName = pdfFileName;
                    final ReportGenerationRunnableWithProgress reportGenProgress = new ReportGenerationRunnableWithProgress(gc, outputFileName);
                    GuidedAnalysisComposite.this.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                new ProgressMonitorDialog(GuidedAnalysisComposite.this.getShell()).run(true, true, (IRunnableWithProgress)reportGenProgress);
                                int status = reportGenProgress.getStatus();
                                if (status != 0) {
                                    if (status == 8) {
                                        ViperExceptionHandler.logError("Cancelled Report Generation");
                                    } else {
                                        ViperExceptionHandler.logError("Error while generating report!");
                                    }
                                }
                            }
                            catch (InvocationTargetException e1) {
                                ViperExceptionHandler.handle("Error with report generation", e1.getMessage(), e1);
                            }
                            catch (InterruptedException e1) {
                                ViperExceptionHandler.handle("Something went terribly wrong during report generation!", e1.getMessage(), e1);
                            }
                        }
                    });
                }
            }
        });
        this.reconcileStages();
    }

    private void assignStage(int i, PShelfItem[] items, IExpertSystemStage stage, boolean active) {
        PShelfItem item = items.length > i ? items[i] : this.createItem();
        item.setText(String.valueOf(i + 1) + ". " + stage.getTitle(ResultOutput.UI));
        GuidedAnalysisStageControl stageControl = (GuidedAnalysisStageControl)((Object)item.getData());
        stageControl.setExpertSystemStage(stage);
        this.configureItemScroll(item);
        if (active) {
            this.shelf.setSelection(item);
        }
    }

    private void configureItemScroll(PShelfItem item) {
        Composite body = item.getBody();
        Control[] controlArray = body.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof ScrolledComposite) {
                this.resizeScroll((ScrolledComposite)child);
            }
            ++n2;
        }
    }

    private PShelfItem createItem() {
        PShelfItem item = new PShelfItem(this.shelf, 0);
        Composite body = item.getBody();
        body.setLayout((Layout)new FillLayout());
        final ScrolledComposite scrolledComposite = new ScrolledComposite(body, 512);
        GuidedAnalysisStageControl stageControl = new GuidedAnalysisStageControl((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)stageControl);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        item.setData((Object)stageControl);
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GuidedAnalysisComposite.this.resizeScroll(scrolledComposite);
            }
        });
        return item;
    }

    public Control getButtonsControl() {
        return this.reportGeneration.getParent();
    }

    private void reconcileStages() {
        int i;
        PShelfItem[] items = this.shelf.getItems();
        if (this.viperExpertSystem != null) {
            IExpertSystemStage[] visibleStages = this.viperExpertSystem.getVisitedStages();
            IExpertSystemStage currentStage = this.viperExpertSystem.getCurrentStage();
            i = 0;
            while (i < visibleStages.length) {
                IExpertSystemStage stage;
                this.assignStage(i, items, stage, currentStage == (stage = visibleStages[i]));
                ++i;
            }
        } else {
            i = 0;
        }
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    public void refreshCurrentStage() {
        if (this.viperExpertSystem != null) {
            IExpertSystemStage current = this.viperExpertSystem.getCurrentStage();
            if (current != null) {
                PShelfItem[] items = this.shelf.getItems();
                int i = 0;
                while (i < items.length) {
                    PShelfItem item = items[i];
                    GuidedAnalysisStageControl stageControl = (GuidedAnalysisStageControl)((Object)item.getData());
                    if (stageControl != null && stageControl.getExpertSystemStage() == current) {
                        this.assignStage(i, items, current, true);
                        this.shelf.setSelection(item);
                        break;
                    }
                    ++i;
                }
            }
            this.shelf.getParent().layout(true, true);
        }
    }

    public void refreshStages() {
        this.reconcileStages();
        this.shelf.getParent().layout(true, true);
    }

    private void registerReportButtonVisibility() {
        if (this.viperExpertSystem != null) {
            this.viperExpertSystem.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                @Override
                public void propertyChange(IModel model, String propertyName) {
                    if (model instanceof ExpertSystem) {
                        ExpertSystem expertSystem = (ExpertSystem)model;
                        ExpertSystemStageKind currentStage = expertSystem.getCurrentStageKind();
                        switch (currentStage) {
                            case INTRO: 
                            case APPLICATION: 
                            case KERNELS: {
                                GuidedAnalysisComposite.this.reportGeneration.setEnabled(false);
                                GuidedAnalysisComposite.this.reportGeneration.setToolTipText(GuidedAnalysisComposite.DISABLED_REPORTGEN_TOOLTIP);
                                break;
                            }
                            case BOUNDS: 
                            case LATENCY: 
                            case COMPUTE: 
                            case MEMORY: {
                                TimelineIntervalPair primary = GuidedAnalysisComposite.this.viperExpertSystem.getSession().getPrimarySelected();
                                if (primary == null) break;
                                GuidedAnalysisComposite.this.reportGeneration.setEnabled(true);
                                GuidedAnalysisComposite.this.reportGeneration.setToolTipText(GuidedAnalysisComposite.ENABLED_REPORTGEN_TOOLTIP);
                                break;
                            }
                            default: {
                                GuidedAnalysisComposite.this.reportGeneration.setEnabled(false);
                                GuidedAnalysisComposite.this.reportGeneration.setToolTipText(GuidedAnalysisComposite.DISABLED_REPORTGEN_TOOLTIP);
                            }
                        }
                    }
                }
            });
        }
    }

    private void resizeScroll(ScrolledComposite scrolledComposite) {
        Control content = scrolledComposite.getContent();
        Rectangle clientArea = scrolledComposite.getClientArea();
        Point size = content.computeSize(clientArea.width, -1);
        scrolledComposite.setMinSize(new Point(size.x + 2 * scrolledComposite.getBorderWidth(), size.y + 2 * scrolledComposite.getBorderWidth()));
    }

    public void setExpertSystem(ExpertSystem expertSystem) {
        this.viperExpertSystem = expertSystem;
        this.reconcileStages();
        this.shelf.getParent().layout(true, true);
        this.registerReportButtonVisibility();
    }

    private final class ReportGenerationRunnableWithProgress
    implements IRunnableWithProgress {
        private final GC gc;
        private final String outputFileName;
        private int status;

        private ReportGenerationRunnableWithProgress(GC gc, String outputFileName) {
            this.gc = gc;
            this.outputFileName = outputFileName;
        }

        public int getStatus() {
            return this.status;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                if (GuidedAnalysisComposite.this.shelf != null) {
                    GuidedAnalysisComposite.this.shelf.setSelectAnimation(false);
                }
                try {
                    this.status = new ReportGenerationAction(GuidedAnalysisComposite.this.viperExpertSystem.getSession(), this.gc, this.outputFileName, monitor).run();
                }
                catch (ViperException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                if (GuidedAnalysisComposite.this.shelf != null) {
                    GuidedAnalysisComposite.this.shelf.setSelectAnimation(true);
                }
            }
        }
    }
}

