/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultInstructionExecution;
import com.nvidia.viper.editor.SourceSassEditorInput;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SourceSassModel;
import com.nvidia.viper.ui.analysis.AnalysisResultControl;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class InstructionExecutionResultControl
extends AnalysisResultControl {
    private IEditorPart editor = null;

    public InstructionExecutionResultControl(Composite parent, AnalysisResult result, Session session) {
        super(parent, result, session);
        this.activeSession.addPropertyChangeListener(new ISessionPropertyChangeListener(){

            @Override
            public void propertyChange(IModel model, String propertyName) {
                if ("session:timelinereset".equals(propertyName) && InstructionExecutionResultControl.this.editor != null) {
                    InstructionExecutionResultControl.this.editor.getSite().getPage().closeEditor(InstructionExecutionResultControl.this.editor, false);
                }
            }
        });
    }

    @Override
    protected boolean allowsSelection() {
        return false;
    }

    @Override
    protected boolean hasExtension() {
        return true;
    }

    @Override
    protected void createExtension(Composite parent) {
        Label label;
        final AnalysisResultInstructionExecution analysisResultInstExec = this.getSourceLevelResult();
        String[] funcNameList = analysisResultInstExec.getFunctionNameList(this.activeSession);
        if (funcNameList != null && funcNameList.length > 0) {
            label = new Label(parent, 0);
            label.setText("Cuda Functions :");
            label.setLayoutData((Object)new GridData(4, 4, true, true));
            final List listFunctions = new List(parent, 2560);
            listFunctions.setLayoutData((Object)new GridData(4, 4, true, true));
            listFunctions.setItems(funcNameList);
            listFunctions.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String function = listFunctions.getItem(listFunctions.getSelectionIndex());
                    SourceSassModel model = new SourceSassModel(InstructionExecutionResultControl.this.activeSession, InstructionExecutionResultControl.this.getSourceLevelResult(), analysisResultInstExec.getFunctionId(function, InstructionExecutionResultControl.this.activeSession));
                    InstructionExecutionResultControl.this.openEditor(model);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        label = new Label(parent, 0);
        label.setText("Maximum instruction execution count in assembly: " + analysisResultInstExec.getMaxInstExecuted(this.activeSession));
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(parent, 0);
        label.setText("Average instruction execution count in assembly: " + analysisResultInstExec.getAvgInstCount(this.activeSession));
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(parent, 0);
        label.setText("Instructions executed for the kernel: " + analysisResultInstExec.getTotalInstExecuted(this.activeSession));
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(parent, 0);
        label.setText("Thread instructions executed for the kernel: " + analysisResultInstExec.getTotalThreadInstExecuted(this.activeSession));
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(parent, 0);
        label.setText("Non-predicated thread instructions executed for the kernel: " + analysisResultInstExec.getTotalNonPredThreadInstExecuted(this.activeSession));
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(parent, 256);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        double warpNonPredEfficiency = analysisResultInstExec.getWarpNonPredEfficiency(this.activeSession);
        label = new Label(parent, 0);
        label.setText(String.format("Warp non-predicated execution efficiency of the kernel: %.1f%%", warpNonPredEfficiency));
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        double warpEfficiency = analysisResultInstExec.getWarpEfficiency(this.activeSession);
        label = new Label(parent, 0);
        label.setText(String.format("Warp execution efficiency of the kernel: %.1f%%", warpEfficiency));
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        String[] srcFileNameList = analysisResultInstExec.getSourceFileNameList(this.activeSession);
        if (srcFileNameList != null && srcFileNameList.length > 0) {
            label = new Label(parent, 0);
            label.setText("Source files :");
            label.setLayoutData((Object)new GridData(4, 4, true, true));
            final List listFiles = new List(parent, 2560);
            listFiles.setLayoutData((Object)new GridData(4, 4, true, true));
            listFiles.setItems(srcFileNameList);
            listFiles.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String fileName = listFiles.getItem(listFiles.getSelectionIndex());
                    SourceSassModel model = new SourceSassModel(InstructionExecutionResultControl.this.activeSession, InstructionExecutionResultControl.this.getSourceLevelResult(), fileName, analysisResultInstExec.getFileLineNumber(fileName, InstructionExecutionResultControl.this.activeSession));
                    InstructionExecutionResultControl.this.openEditor(model);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    @Override
    public boolean grabsVerticalSpace() {
        return false;
    }

    private AnalysisResultInstructionExecution getSourceLevelResult() {
        return (AnalysisResultInstructionExecution)this.result;
    }

    private void openEditor(SourceSassModel model) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            this.editor = activePage.openEditor((IEditorInput)new SourceSassEditorInput(model), "com.nvidia.viper.sourcesasseditor");
        }
        catch (PartInitException e1) {
            ViperExceptionHandler.handle(ViperMessages.Instruction_Execution_Failed_Title, ViperMessages.Instruction_Execution_Failed_Message, new ViperException(e1));
        }
    }
}

