/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.activity.CuptiDevType;
import com.nvidia.viper.ui.analysis.TopologyCanvas;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Listener;

public class NodeFigure
extends RectangleFigure
implements MouseListener,
MouseMotionListener {
    public static String PROPERTY_NODE_MOVED = "prop.node.moved";
    public static String PROPERTY_NODE_SELECTED = "prop.node.selected";
    public static int SELECTED_WIDTH = 2;
    public static int NOT_SELECTED_WIDTH = 1;
    private List<EventListener> listeners = new ArrayList<EventListener>();
    private NodeNameFigure deviceName = new NodeNameFigure();
    private CuptiDevType devType;
    private int id;
    private Point location;
    public static int NODE_WIDTH = 100;

    public NodeFigure(String name, int id, CuptiDevType devType) {
        this.id = id;
        if (devType == CuptiDevType.CUPTI_DEV_TYPE_GPU) {
            this.createGPU(name);
        } else {
            this.createCPU(id);
        }
        this.devType = devType;
        this.setOpaque(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void createGPU(String name) {
        ToolbarLayout layoutMngr = new ToolbarLayout();
        layoutMngr.setSpacing(-4);
        this.setLayoutManager((LayoutManager)layoutMngr);
        this.setBackgroundColor(ViperColors.COLOR_GPU);
        Label idLabel = new Label("GPU " + this.id);
        idLabel.setForegroundColor(ViperColors.COLOR_NVLINK);
        idLabel.setTextAlignment(2);
        idLabel.setFont(TopologyCanvas.LABEL_FONT);
        idLabel.setBorder((Border)new MarginBorder(3));
        this.add((IFigure)idLabel);
        Label nameLabel = new Label(name);
        nameLabel.setTextAlignment(2);
        nameLabel.setFont(TopologyCanvas.LABEL_FONT);
        this.add((IFigure)nameLabel);
        this.setPreferredSize(NODE_WIDTH, 50);
        this.setToolTip((IFigure)new Label(name));
    }

    private void createCPU(int id) {
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.setBackgroundColor(ViperColors.COLOR_CPU);
        String text = id == -1 ? "CPU" : "CPU " + Integer.toString(id);
        Label label = new Label(text);
        label.setTextAlignment(2);
        label.setForegroundColor(ViperColors.COLOR_DEVICE);
        this.add((IFigure)label, BorderLayout.CENTER);
        this.setPreferredSize(NODE_WIDTH, 150);
        this.setToolTip((IFigure)new Label(text));
    }

    public CuptiDevType getDevType() {
        return this.devType;
    }

    public int getId() {
        return this.id;
    }

    public NodeNameFigure getGpuNameFigure() {
        return this.deviceName;
    }

    public void mouseDragged(MouseEvent me) {
        if (this.location == null) {
            return;
        }
        Point newLocation = me.getLocation();
        if (newLocation == null) {
            return;
        }
        Rectangle client = this.getParent().getClientArea();
        if (!client.contains(this.location)) {
            return;
        }
        Dimension offset = newLocation.getDifference(this.location);
        if (offset.width == 0 && offset.height == 0) {
            return;
        }
        this.location = newLocation;
        UpdateManager updateMgr = this.getUpdateManager();
        LayoutManager layoutMgr = this.getParent().getLayoutManager();
        Rectangle bounds = this.getBounds();
        updateMgr.addDirtyRegion(this.getParent(), bounds);
        bounds = bounds.getCopy().translate(offset.width, offset.height);
        layoutMgr.setConstraint((IFigure)this, (Object)bounds);
        this.translate(offset.width, offset.height);
        updateMgr.addDirtyRegion(this.getParent(), bounds);
        me.consume();
        this.fire(PROPERTY_NODE_MOVED);
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        this.location = me.getLocation();
        me.consume();
        this.fire(PROPERTY_NODE_SELECTED);
    }

    public void mouseReleased(MouseEvent me) {
        if (this.location == null) {
            return;
        }
        this.location = null;
        me.consume();
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void addListener(EventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void fire(String property) {
        for (EventListener listener : this.listeners) {
            if (!(listener instanceof TopologyCanvas)) continue;
            ((TopologyCanvas)((Object)listener)).propertyChanged(this, property);
        }
    }

    public class NodeNameFigure
    extends Figure {
        public NodeNameFigure() {
            ToolbarLayout layout = new ToolbarLayout();
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(false);
            layout.setSpacing(2);
            this.setLayoutManager((LayoutManager)layout);
        }
    }
}

