/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.providers.AbstractCSSPropertyHandlerProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class RegistryCSSPropertyHandlerProvider
extends AbstractCSSPropertyHandlerProvider {
    private static final String ATTR_COMPOSITE = "composite";
    private static final String ATTR_ADAPTER = "adapter";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PROPERTY_NAME = "property-name";
    private static final String ATTR_HANDLER = "handler";
    private static final String ATTR_DEPRECATED = "deprecated";
    private static final String PROPERTY_HANDLERS_EXTPOINT = "org.eclipse.e4.ui.css.core.propertyHandler";
    private static final String DEPRECATED_PROPERTY_HANDLERS_EXTPOINT = "org.eclipse.e4.ui.css.swt.property.handler";
    private IExtensionRegistry registry;
    private boolean hasDeprecatedProperties = false;
    private Map<String, Map<String, ICSSPropertyHandler>> propertyHandlerMap = new HashMap<String, Map<String, ICSSPropertyHandler>>();

    public RegistryCSSPropertyHandlerProvider(IExtensionRegistry registry) {
        this.registry = registry;
        if (this.configure(DEPRECATED_PROPERTY_HANDLERS_EXTPOINT)) {
            System.err.println("Extension point org.eclipse.e4.ui.css.swt.property.handler is deprecated; use org.eclipse.e4.ui.css.core.propertyHandler");
        }
        this.configure(PROPERTY_HANDLERS_EXTPOINT);
    }

    public RegistryCSSPropertyHandlerProvider(IExtensionRegistry registry, String extensionPointId) {
        this.registry = registry;
        this.configure(extensionPointId);
    }

    protected boolean configure(String extensionPointId) {
        IExtensionPoint extPoint = this.registry.getExtensionPoint(extensionPointId);
        if (extPoint == null) {
            return false;
        }
        IExtension[] extensions = extPoint.getExtensions();
        if (extensions.length == 0) {
            return false;
        }
        HashMap handlersMap = new HashMap();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equals(ATTR_HANDLER)) {
                    String name = ce.getAttribute(ATTR_COMPOSITE);
                    String adapter = ce.getAttribute(ATTR_ADAPTER);
                    IConfigurationElement[] children = ce.getChildren();
                    String[] names = new String[children.length];
                    String[] deprecated = new String[children.length];
                    int i = 0;
                    while (i < children.length) {
                        if (children[i].getName().equals(ATTR_PROPERTY_NAME)) {
                            names[i] = children[i].getAttribute(ATTR_NAME);
                            deprecated[i] = children[i].getAttribute(ATTR_DEPRECATED);
                            if (deprecated[i] != null) {
                                this.hasDeprecatedProperties = true;
                            }
                        }
                        ++i;
                    }
                    try {
                        HashMap<String, ICSSPropertyHandler> adaptersMap = (HashMap<String, ICSSPropertyHandler>)handlersMap.get(adapter);
                        if (adaptersMap == null) {
                            adaptersMap = new HashMap<String, ICSSPropertyHandler>();
                            handlersMap.put(adapter, adaptersMap);
                        }
                        if (!adaptersMap.containsKey(name)) {
                            Object t = ce.createExecutableExtension(ATTR_HANDLER);
                            if (t instanceof ICSSPropertyHandler) {
                                int i2 = 0;
                                while (i2 < names.length) {
                                    adaptersMap.put(names[i2], deprecated[i2] == null ? (ICSSPropertyHandler)t : new DeprecatedPropertyHandlerWrapper((ICSSPropertyHandler)t, deprecated[i2]));
                                    ++i2;
                                }
                            } else {
                                this.logError("invalid property handler for " + name);
                            }
                        }
                    }
                    catch (CoreException e1) {
                        this.logError("invalid property handler for " + name + ": " + (Object)((Object)e1));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        this.propertyHandlerMap.putAll(handlersMap);
        return true;
    }

    @Override
    public Collection<ICSSPropertyHandler> getCSSPropertyHandlers(String property) throws Exception {
        ArrayList<ICSSPropertyHandler> handlers = new ArrayList<ICSSPropertyHandler>();
        for (Map<String, ICSSPropertyHandler> perElement : this.propertyHandlerMap.values()) {
            ICSSPropertyHandler h = perElement.get(property);
            if (h == null) continue;
            handlers.add(h);
        }
        return handlers;
    }

    @Override
    protected CSSStyleDeclaration getDefaultCSSStyleDeclaration(CSSEngine engine, CSSStylableElement stylableElement, CSSStyleDeclaration newStyle, String pseudoE) throws Exception {
        if (stylableElement.getDefaultStyleDeclaration(pseudoE) != null) {
            return stylableElement.getDefaultStyleDeclaration(pseudoE);
        }
        if (newStyle != null) {
            StringBuffer style = null;
            int length = newStyle.getLength();
            int i = 0;
            while (i < length) {
                String propertyName = newStyle.item(i);
                String[] compositePropertiesNames = engine.getCSSCompositePropertiesNames(propertyName);
                if (compositePropertiesNames != null) {
                    int j = 0;
                    while (j < compositePropertiesNames.length) {
                        propertyName = compositePropertiesNames[j];
                        String s = this.getCSSPropertyStyle(engine, stylableElement, propertyName, pseudoE);
                        if (s != null) {
                            if (style == null) {
                                style = new StringBuffer();
                            }
                            style.append(s);
                        }
                        ++j;
                    }
                } else {
                    String s = this.getCSSPropertyStyle(engine, stylableElement, propertyName, pseudoE);
                    if (s != null) {
                        if (style == null) {
                            style = new StringBuffer();
                        }
                        style.append(s);
                    }
                }
                ++i;
            }
            if (style != null) {
                CSSStyleDeclaration defaultStyleDeclaration = engine.parseStyleDeclaration(style.toString());
                stylableElement.setDefaultStyleDeclaration(pseudoE, defaultStyleDeclaration);
                return defaultStyleDeclaration;
            }
        }
        return stylableElement.getDefaultStyleDeclaration(pseudoE);
    }

    @Override
    public Collection<ICSSPropertyHandler> getCSSPropertyHandlers(Object element, String property) throws Exception {
        ArrayList<ICSSPropertyHandler> handlers = new ArrayList<ICSSPropertyHandler>();
        Class<?> clazz = element.getClass();
        while (clazz != Object.class) {
            ICSSPropertyHandler handler;
            if (this.propertyHandlerMap.containsKey(clazz.getName()) && (handler = this.propertyHandlerMap.get(clazz.getName()).get(property)) != null) {
                handlers.add(handler);
            }
            clazz = clazz.getSuperclass();
        }
        return handlers;
    }

    @Override
    public Collection<String> getCSSProperties(Object element) {
        HashSet<String> properties = new HashSet<String>();
        Class<?> clazz = element.getClass();
        while (clazz != Object.class) {
            Map<String, ICSSPropertyHandler> handlerMap = this.propertyHandlerMap.get(clazz.getName());
            if (handlerMap != null) {
                if (!this.hasDeprecatedProperties) {
                    properties.addAll(handlerMap.keySet());
                } else {
                    for (Map.Entry<String, ICSSPropertyHandler> entry : handlerMap.entrySet()) {
                        if (entry.getValue() instanceof DeprecatedPropertyHandlerWrapper) continue;
                        properties.add(entry.getKey());
                    }
                }
            }
            clazz = clazz.getSuperclass();
        }
        return properties;
    }

    protected void logError(String message) {
        RuntimeLog.log((IStatus)new Status(4, "org.eclipse.e4.ui.css.core", message));
    }

    private class DeprecatedPropertyHandlerWrapper
    implements ICSSPropertyHandler {
        private ICSSPropertyHandler delegate;
        private String message;
        private Set<String> logged = new HashSet<String>();

        DeprecatedPropertyHandlerWrapper(ICSSPropertyHandler handler, String message) {
            this.delegate = handler;
            this.message = message;
        }

        @Override
        public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
            this.logIfNecessary(property);
            return this.delegate.applyCSSProperty(element, property, value, pseudo, engine);
        }

        @Override
        public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
            this.logIfNecessary(property);
            return this.delegate.retrieveCSSProperty(element, property, pseudo, engine);
        }

        private void logIfNecessary(String property) {
            if (!this.logged.contains(property)) {
                this.logged.add(property);
                RegistryCSSPropertyHandlerProvider.this.logError("CSS property '" + property + "' has been deprecated: " + this.message);
            }
        }
    }
}

