/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.nvidia.common";
    private static Activator plugin;
    private static int minimumMinorRevision;
    private static boolean notifyAboutUnsupportedJavaVersion;

    static {
        minimumMinorRevision = 7;
        notifyAboutUnsupportedJavaVersion = false;
    }

    private static void checkJavaVersion() {
        String versionString = System.getProperty("java.version");
        if (!versionString.startsWith("1.")) {
            return;
        }
        int idx = versionString.indexOf(46, 3);
        if (idx < 0) {
            return;
        }
        int version = Integer.parseInt(versionString.substring(2, idx));
        notifyAboutUnsupportedJavaVersion = version < minimumMinorRevision;
    }

    public Activator() {
        Activator.checkJavaVersion();
    }

    private static void displayUnsupportedJavaVersionWarning(Shell shell) {
        String version = System.getProperty("java.version");
        String product = Platform.getProduct().getName();
        String warningMessage = String.valueOf(product) + " was launched using java " + version + ", which is not supported.\n Please use Java 1." + minimumMinorRevision + " or later";
        MessageDialog.openWarning((Shell)shell, (String)"Java version is not supported", (String)warningMessage);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (!notifyAboutUnsupportedJavaVersion) {
            return;
        }
        final IWorkbench wb = PlatformUI.getWorkbench();
        wb.addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
                wb.removeWindowListener((IWindowListener)this);
                Activator.displayUnsupportedJavaVersionWarning(window.getShell());
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowOpened(IWorkbenchWindow window) {
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        Activator.log(e, null, new Object[0]);
    }

    public static void log(Throwable e, String format, Object ... args) {
        String message = format != null ? String.format(format, args) : null;
        Status status = new Status(4, PLUGIN_ID, message, e);
        Activator pl = Activator.getDefault();
        if (pl != null && pl.getLog() != null) {
            pl.getLog().log((IStatus)status);
        } else {
            if (message != null) {
                System.err.println(message);
            }
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public static void log(String format, Object ... args) {
        Activator.log(null, format, args);
    }
}

