/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.internal.ui.refactoring.AbstractChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPreviewChangeFilter;

public class CompositeChangeNode
extends AbstractChangeNode {
    private final RefactoringPreviewChangeFilter fFilter;

    public CompositeChangeNode(PreviewNode parent, RefactoringPreviewChangeFilter filter, CompositeChange change) {
        super(parent, (Change)change);
        this.fFilter = filter;
    }

    int getActive() {
        return this.getCompositeChangeActive();
    }

    public ImageDescriptor getImageDescriptor() {
        return RefactoringPluginImages.DESC_OBJS_COMPOSITE_CHANGE;
    }

    PreviewNode[] doCreateChildren() {
        ArrayList children = new ArrayList();
        this.getFlattendedChildren(children, this, (CompositeChange)this.getChange());
        return children.toArray(new PreviewNode[children.size()]);
    }

    private void getFlattendedChildren(List result, CompositeChangeNode parent, CompositeChange focus) {
        Change[] changes = focus.getChildren();
        int i = 0;
        while (i < changes.length) {
            Change change = changes[i];
            if (this.fFilter == null || this.fFilter.select(change)) {
                if (change instanceof CompositeChange && ((CompositeChange)change).isSynthetic()) {
                    this.getFlattendedChildren(result, parent, (CompositeChange)change);
                } else {
                    result.add(CompositeChangeNode.createNode(parent, change));
                }
            }
            ++i;
        }
    }
}

